/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.SVNCommandUtil;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.ISVNEventHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc.SVNPropertyData;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNWCClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNPropDelCommand
extends SVNPropertiesCommand {
    public SVNPropDelCommand() {
        super("propdel", new String[]{"pdel", "pd"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    @Override
    public void run() throws SVNException {
        String propertyName = this.getSVNEnvironment().popArgument();
        if (propertyName == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isRevprop()) {
            String target = this.checkRevPropTarget(this.getSVNEnvironment().getStartRevision(), targets);
            if (SVNCommandUtil.isURL(target)) {
                SVNURL url = SVNURL.parseURIEncoded(target);
                this.getSVNEnvironment().getClientManager().getWCClient().doSetRevisionProperty(url, this.getSVNEnvironment().getStartRevision(), propertyName, null, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
            } else {
                File targetFile = new SVNPath(target).getFile();
                this.getSVNEnvironment().getClientManager().getWCClient().doSetRevisionProperty(targetFile, this.getSVNEnvironment().getStartRevision(), propertyName, null, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
            }
        } else if (this.getSVNEnvironment().getStartRevision() != SVNRevision.UNDEFINED) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Cannot specify revision for deleting versioned property ''{0}''", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        } else {
            SVNDepth depth = this.getSVNEnvironment().getDepth();
            if (depth == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            final boolean[] deletedNonExistent = new boolean[]{false};
            client.setEventHandler(new ISVNEventHandler(){

                @Override
                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    if (event.getAction() == SVNEventAction.PROPERTY_DELETE_NONEXISTENT) {
                        deletedNonExistent[0] = true;
                    }
                }

                @Override
                public void checkCancelled() throws SVNCancelException {
                    SVNPropDelCommand.this.getSVNEnvironment().checkCancelled();
                }
            });
            for (String string : targets) {
                SVNPath target = new SVNPath(string);
                if (!target.isFile()) continue;
                boolean success = true;
                try {
                    if (target.isFile()) {
                        client.doSetProperty(target.getFile(), propertyName, null, this.getSVNEnvironment().isForce(), depth, this, changeLists);
                    } else {
                        client.setCommitHandler(this.getSVNEnvironment());
                        client.doSetProperty(target.getURL(), propertyName, null, SVNRevision.HEAD, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isForce(), this);
                    }
                    if (deletedNonExistent[0]) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Attempting to delete nonexistent property ''{0}''", (Object)propertyName);
                        this.getSVNEnvironment().getOut().println(err.getFullMessage());
                        success = false;
                    }
                }
                catch (SVNException e) {
                    success = this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.ENTRY_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                }
                this.clearCollectedProperties();
                if (!success || this.getSVNEnvironment().isQuiet() || !success) continue;
                String path = SVNCommandUtil.getLocalPath(string);
                String message = depth.isRecursive() ? "property ''{0}'' deleted (recursively) from ''{1}''." : "property ''{0}'' deleted from ''{1}''.";
                message = MessageFormat.format(message, propertyName, path);
                this.getSVNEnvironment().getOut().println(message);
            }
        }
    }

    @Override
    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        super.handleProperty(revision, property);
        if (!this.getSVNEnvironment().isQuiet()) {
            String message = "property ''{0}'' deleted from repository revision {1}";
            message = MessageFormat.format(message, property.getName(), new Long(revision));
            this.getSVNEnvironment().getOut().println(message);
        }
    }
}

