/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.SVNCommandUtil;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileType;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import afu.org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import afu.org.tmatesoft.svn.core.wc.SVNPropertyData;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNWCClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNPropSetCommand
extends SVNPropertiesCommand {
    public SVNPropSetCommand() {
        super("propset", new String[]{"pset", "ps"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.FILE);
        options.add(SVNOption.ENCODING);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNErrorMessage err;
        String argument;
        String propertyName = this.getSVNEnvironment().popArgument();
        if (propertyName == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error(err2, SVNLogType.CLIENT);
        }
        if (!SVNPropertiesManager.isValidPropertyName(propertyName)) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is not a valid Subversion property name", (Object)propertyName);
            SVNErrorManager.error(err2, SVNLogType.CLIENT);
        }
        String encoding = null;
        if (SVNPropertiesManager.propNeedsTranslation(propertyName)) {
            encoding = this.getSVNEnvironment().getEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
        } else if (this.getSVNEnvironment().getEncoding() != null) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Bad encoding option: prop value not stored as UTF8");
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        }
        SVNPropertyValue propertyValue = null;
        if (encoding != null) {
            if (this.getSVNEnvironment().getFileData() != null) {
                String stringValue = null;
                try {
                    stringValue = new String(this.getSVNEnvironment().getFileData(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    stringValue = new String(this.getSVNEnvironment().getFileData());
                }
                propertyValue = SVNPropertyValue.create(stringValue);
            } else {
                argument = this.getSVNEnvironment().popArgument();
                if (argument == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                propertyValue = SVNPropertyValue.create(argument);
            }
        } else if (this.getSVNEnvironment().getFileData() != null) {
            propertyValue = SVNPropertyValue.create(propertyName, this.getSVNEnvironment().getFileData());
        } else {
            argument = this.getSVNEnvironment().popArgument();
            if (argument == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            propertyValue = SVNPropertyValue.create(propertyName, argument.getBytes());
        }
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (this.getSVNEnvironment().isRevprop()) {
            String target;
            if (targets.isEmpty()) {
                targets.add("");
            }
            if (SVNCommandUtil.isURL(target = this.checkRevPropTarget(this.getSVNEnvironment().getStartRevision(), targets))) {
                SVNURL revPropURL = SVNURL.parseURIEncoded(target);
                this.getSVNEnvironment().getClientManager().getWCClient().doSetRevisionProperty(revPropURL, this.getSVNEnvironment().getStartRevision(), propertyName, propertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
            } else {
                File targetFile = new SVNPath(target).getFile();
                this.getSVNEnvironment().getClientManager().getWCClient().doSetRevisionProperty(targetFile, this.getSVNEnvironment().getStartRevision(), propertyName, propertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
            }
        } else if (this.getSVNEnvironment().getStartRevision() != SVNRevision.UNDEFINED) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Cannot specify revision for setting versioned property ''{0}''", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        } else {
            SVNDepth depth = this.getSVNEnvironment().getDepth();
            if (depth == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            if (targets.isEmpty()) {
                if (this.getSVNEnvironment().getFileData() == null) {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Explicit target required (''{0}'' interpreted as prop value)", (Object)propertyValue);
                    SVNErrorManager.error(err3, SVNLogType.CLIENT);
                } else {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Explicit target argument required");
                    SVNErrorManager.error(err3, SVNLogType.CLIENT);
                }
            }
            this.printBinaryMimeTypeWarning(targets, propertyName, propertyValue);
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            for (String string : targets) {
                SVNPath target = new SVNPath(string);
                if (!target.isFile()) continue;
                boolean success = true;
                try {
                    if (target.isFile()) {
                        client.doSetProperty(target.getFile(), propertyName, propertyValue, this.getSVNEnvironment().isForce(), depth, this, changeLists);
                    } else {
                        client.setCommitHandler(this.getSVNEnvironment());
                        client.doSetProperty(target.getURL(), propertyName, propertyValue, SVNRevision.HEAD, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isForce(), this);
                    }
                }
                catch (SVNException e) {
                    success = this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.ENTRY_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                }
                this.clearCollectedProperties();
                if (this.getSVNEnvironment().isQuiet()) continue;
                this.checkBooleanProperty(propertyName, propertyValue);
                if (!success) continue;
                String path = SVNCommandUtil.getLocalPath(string);
                String message = depth.isRecursive() ? "property ''{0}'' set (recursively) on ''{1}''" : "property ''{0}'' set on ''{1}''";
                message = MessageFormat.format(message, propertyName, path);
                this.getSVNEnvironment().getOut().println(message);
            }
        }
    }

    @Override
    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        super.handleProperty(revision, property);
        if (!this.getSVNEnvironment().isQuiet()) {
            String message = "property ''{0}'' set on repository revision {1}";
            message = MessageFormat.format(message, property.getName(), new Long(revision));
            this.getSVNEnvironment().getOut().println(message);
        }
    }

    private void printBinaryMimeTypeWarning(Collection targets, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if ("svn:mime-type".equals(propertyName)) {
            for (Object target : targets) {
                String detectedMimeType;
                SVNPropertyValue canonicalPropertyValue;
                String path = (String)target;
                File localAbsPath = SVNFileUtil.createFilePath(path).getAbsoluteFile();
                if (SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath)) != SVNNodeKind.FILE || !SVNProperty.isBinaryMimeType(SVNPropertyValue.getPropertyAsString(canonicalPropertyValue = SVNPropertiesManager.validatePropertyValue(localAbsPath, SVNNodeKind.FILE, propertyName, propertyValue, false, null, null))) || (detectedMimeType = SVNFileUtil.detectMimeType(localAbsPath, null)) != null && SVNProperty.isBinaryMimeType(detectedMimeType)) continue;
                this.getEnvironment().getErr().println("svn: warning: '" + SVNPropertyValue.getPropertyAsString(canonicalPropertyValue) + "' is a binary mime-type but file '" + localAbsPath + "' " + "looks like text; diff, merge, blame, and other " + "operations will stop working on this file");
            }
        }
    }
}

