/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnadmin;

import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SVNAdminRemoveTransactionsCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    public SVNAdminRemoveTransactionsCommand() {
        super("rmtxns", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        ArrayList<SVNAdminOption> options = new ArrayList<SVNAdminOption>();
        options.add(SVNAdminOption.QUIET);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        List<String> targets = this.getEnvironment().combineTargets(null, false);
        if (!targets.isEmpty()) {
            targets.remove(0);
        }
        String[] transactions = targets.toArray(new String[targets.size()]);
        client.setEventHandler(this);
        client.doRemoveTransactions(this.getLocalRepository(), transactions);
    }

    @Override
    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event != null && event.getAction() == SVNAdminEventAction.TRANSACTION_REMOVED) {
            if (!this.getSVNAdminEnvironment().isQuiet()) {
                String txnName = event.getTxnName();
                this.getEnvironment().getOut().println("Transaction '" + txnName + "' removed.");
            }
        } else if (event.getError() != null) {
            this.getEnvironment().handleError(event.getError());
        }
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

