/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnadmin;

import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;

public class SVNAdminVerifyCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    public SVNAdminVerifyCommand() {
        super("verify", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.REVISION);
        options.add(SVNAdminOption.QUIET);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNRevision start = this.getSVNAdminEnvironment().getStartRevision();
        SVNRevision end = this.getSVNAdminEnvironment().getEndRevision();
        SVNRepository repository = SVNRepositoryFactory.create(SVNURL.fromFile(this.getLocalRepository()));
        repository.setCanceller(this.getEnvironment());
        long latestRevision = repository.getLatestRevision();
        long startRev = this.getRevisionNumber(start, latestRevision, repository);
        long endRev = this.getRevisionNumber(end, latestRevision, repository);
        if (startRev < 0L) {
            startRev = 0L;
            endRev = latestRevision;
        } else if (endRev < 0L) {
            endRev = startRev;
        }
        if (startRev > endRev) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "First revision cannot be higher than second"), SVNLogType.CLIENT);
        }
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        if (!this.getSVNAdminEnvironment().isQuiet()) {
            client.setEventHandler(this);
        }
        client.doVerify(this.getLocalRepository(), SVNRevision.create(startRev), SVNRevision.create(endRev));
    }

    @Override
    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
            this.getEnvironment().getErr().println(event.getMessage());
        }
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

