/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.AbstractSVNCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import java.util.Collection;
import java.util.Collections;

public abstract class SVNLookCommand
extends AbstractSVNCommand {
    public SVNLookCommand(String name, String[] aliases) {
        super(name, aliases);
    }

    @Override
    public Collection getGlobalOptions() {
        return Collections.EMPTY_LIST;
    }

    protected SVNLookCommandEnvironment getSVNLookEnvironment() {
        return (SVNLookCommandEnvironment)this.getEnvironment();
    }

    @Override
    protected String getResourceBundleName() {
        return "afu.org.tmatesoft.svn.cli.svnlook.commands";
    }

    protected FSRoot getFSRoot() throws SVNException {
        FSRepository repository = this.getSVNLookEnvironment().getRepository();
        if (this.getSVNLookEnvironment().isRevision()) {
            long rev = this.getSVNLookEnvironment().getRevision();
            if (rev < 0L) {
                rev = repository.getLatestRevision();
            }
            return repository.getFSFS().createRevisionRoot(rev);
        }
        return repository.getFSFS().createTransactionRoot(this.getSVNLookEnvironment().getTransactionInfo());
    }

    protected SVNProperties getProperties() throws SVNException {
        FSRoot root = this.getFSRoot();
        if (root instanceof FSTransactionRoot) {
            return root.getOwner().getTransactionProperties(((FSTransactionRoot)root).getTxnID());
        }
        return root.getOwner().getRevisionProperties(root.getRevision());
    }

    protected SVNRevision getRevisionObject() {
        if (!SVNRevision.isValidRevisionNumber(this.getSVNLookEnvironment().getRevision())) {
            return SVNRevision.HEAD;
        }
        return SVNRevision.create(this.getSVNLookEnvironment().getRevision());
    }
}

