/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnversion;

import afu.org.tmatesoft.svn.cli.AbstractSVNCommand;
import afu.org.tmatesoft.svn.cli.svnversion.SVNVersionCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnversion.SVNVersionOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNClientManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SVNVersionCommand
extends AbstractSVNCommand {
    public SVNVersionCommand() {
        super("", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        ArrayList<SVNVersionOption> options = new ArrayList<SVNVersionOption>();
        options.add(SVNVersionOption.NO_NEWLINE);
        options.add(SVNVersionOption.COMMITTED);
        options.add(SVNVersionOption.HELP);
        options.add(SVNVersionOption.VERSION);
        return options;
    }

    protected SVNVersionCommandEnvironment getSVNVersionEnvironment() {
        return (SVNVersionCommandEnvironment)this.getEnvironment();
    }

    @Override
    protected String getResourceBundleName() {
        return "afu.org.tmatesoft.svn.cli.svnversion.commands";
    }

    @Override
    public void run() throws SVNException {
        String id;
        SVNPath target;
        List<String> targets = this.getEnvironment().combineTargets(null, false);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if ((target = new SVNPath(targets.get(0))).isURL()) {
            target = new SVNPath("");
            targets.add(0, "");
        }
        String trailURL = targets.size() > 1 ? targets.get(1) : null;
        if (target.isFile() && (id = SVNClientManager.newInstance().getWCClient().doGetWorkingCopyID(target.getFile(), trailURL, this.getSVNVersionEnvironment().isCommitted())) != null) {
            this.getEnvironment().getOut().print(id);
            if (!this.getSVNVersionEnvironment().isNoNewLine()) {
                this.getEnvironment().getOut().println();
            }
        }
    }

    @Override
    public Collection getGlobalOptions() {
        return Collections.EMPTY_LIST;
    }
}

