/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core;

import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import java.util.Date;

public class SVNCommitInfo {
    public static final SVNCommitInfo NULL = new SVNCommitInfo(-1L, null, null, null);
    private long myNewRevision;
    private Date myDate;
    private String myAuthor;
    private SVNErrorMessage myErrorMessage;

    public SVNCommitInfo(long revision, String author, Date date) {
        this(revision, author, date, null);
    }

    public SVNCommitInfo(long revision, String author, Date date, SVNErrorMessage error) {
        this.myNewRevision = revision;
        this.myAuthor = author;
        this.myDate = date;
        this.myErrorMessage = error;
    }

    public long getNewRevision() {
        return this.myNewRevision;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    public SVNException getError() {
        if (this.myErrorMessage != null) {
            return new SVNException(this.getErrorMessage());
        }
        return null;
    }

    public String toString() {
        if (this == NULL) {
            return "EMPTY COMMIT";
        }
        if (this.myErrorMessage == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("r");
            sb.append(this.myNewRevision);
            if (this.myAuthor != null) {
                sb.append(" by '");
                sb.append(this.myAuthor);
                sb.append("'");
            }
            if (this.myDate != null) {
                sb.append(" at ");
                sb.append(this.myDate);
            }
            return sb.toString();
        }
        return this.myErrorMessage.getFullMessage();
    }
}

