/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SVNNodeKind
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5851L;
    public static final SVNNodeKind NONE = new SVNNodeKind(2);
    public static final SVNNodeKind FILE = new SVNNodeKind(1);
    public static final SVNNodeKind DIR = new SVNNodeKind(0);
    public static final SVNNodeKind UNKNOWN = new SVNNodeKind(3);
    private int myID;

    private SVNNodeKind(int id) {
        this.myID = id;
    }

    public static SVNNodeKind getNodeKindById(int id) {
        if (id == FILE.getID()) {
            return FILE;
        }
        if (id == DIR.getID()) {
            return DIR;
        }
        if (id == NONE.getID()) {
            return NONE;
        }
        return UNKNOWN;
    }

    public static SVNNodeKind parseKind(String kind) {
        if ("file".equals(kind)) {
            return FILE;
        }
        if ("dir".equals(kind)) {
            return DIR;
        }
        if ("none".equals(kind) || kind == null) {
            return NONE;
        }
        return UNKNOWN;
    }

    public String toString() {
        if (this == NONE) {
            return "none";
        }
        if (this == FILE) {
            return "file";
        }
        if (this == DIR) {
            return "dir";
        }
        return "unknown";
    }

    public int compareTo(Object o) {
        if (o == null || o.getClass() != SVNNodeKind.class) {
            return -1;
        }
        int otherID = ((SVNNodeKind)o).myID;
        return this.myID > otherID ? 1 : (this.myID < otherID ? -1 : 0);
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeInt(this.myID);
    }

    private void readObject(ObjectInputStream is) throws IOException {
        this.myID = is.readInt();
    }

    private Object readResolve() {
        return SVNNodeKind.fromID(this.myID);
    }

    private static SVNNodeKind fromID(int id) {
        if (SVNNodeKind.DIR.myID == id) {
            return DIR;
        }
        if (SVNNodeKind.FILE.myID == id) {
            return FILE;
        }
        if (SVNNodeKind.NONE.myID == id) {
            return NONE;
        }
        return UNKNOWN;
    }

    public int getID() {
        return this.myID;
    }
}

