/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.auth;

import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import afu.org.tmatesoft.svn.core.auth.ISVNProxyManager;
import afu.org.tmatesoft.svn.core.auth.ISVNProxyManagerEx;
import afu.org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import afu.org.tmatesoft.svn.core.auth.SVNAuthentication;
import afu.org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import afu.org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import afu.org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import afu.org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;

public class BasicAuthenticationManager
implements ISVNAuthenticationManager,
ISVNProxyManagerEx,
ISVNSSHHostVerifier {
    private List<SVNAuthentication> myPasswordAuthentications;
    private List<SVNAuthentication> mySSHAuthentications;
    private List<SVNAuthentication> myUserNameAuthentications;
    private List<SVNAuthentication> mySSLAuthentications;
    private int mySSHIndex;
    private int myPasswordIndex;
    private int myUserNameIndex;
    private int mySSLIndex;
    private String myProxyHost;
    private int myProxyPort;
    private String myProxyUserName;
    private char[] myProxyPassword;
    private boolean myIsAuthenticationForced;

    public static BasicAuthenticationManager newInstance(String userName, char[] password) {
        return BasicAuthenticationManager.newInstance(new SVNAuthentication[]{SVNPasswordAuthentication.newInstance(userName, password, false, null, false), SVNSSHAuthentication.newInstance(userName, password, -1, false, null, false), SVNUserNameAuthentication.newInstance(userName, false, null, false)});
    }

    public static BasicAuthenticationManager newInstance(String userName, File keyFile, char[] passphrase, int portNumber) {
        return BasicAuthenticationManager.newInstance(new SVNAuthentication[]{SVNSSHAuthentication.newInstance(userName, keyFile, passphrase, portNumber, false, null, false), SVNUserNameAuthentication.newInstance(userName, false, null, false)});
    }

    public static BasicAuthenticationManager newInstance(SVNAuthentication[] credentials) {
        return new BasicAuthenticationManager(credentials);
    }

    public static void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication, SVNURL accessedURL, ISVNAuthenticationManager authManager) throws SVNException {
        if (authManager instanceof ISVNAuthenticationManagerExt) {
            ((ISVNAuthenticationManagerExt)authManager).acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication, accessedURL);
        } else {
            authManager.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication);
        }
    }

    public BasicAuthenticationManager(String userName, String password) {
        this(new SVNAuthentication[]{SVNPasswordAuthentication.newInstance(userName, password != null ? password.toCharArray() : null, false, null, false), SVNSSHAuthentication.newInstance(userName, password != null ? password.toCharArray() : null, -1, false, null, false), SVNUserNameAuthentication.newInstance(userName, false, null, false)});
    }

    public BasicAuthenticationManager(String userName, File keyFile, String passphrase, int portNumber) {
        this(new SVNAuthentication[]{SVNSSHAuthentication.newInstance(userName, keyFile, passphrase != null ? passphrase.toCharArray() : null, portNumber, false, null, false), SVNUserNameAuthentication.newInstance(userName, false, null, false)});
    }

    public BasicAuthenticationManager(SVNAuthentication[] authentications) {
        this.setAuthentications(authentications);
    }

    public void setAuthentications(SVNAuthentication[] authentications) {
        this.dismissSensitiveData();
        this.myPasswordAuthentications = new ArrayList<SVNAuthentication>();
        this.mySSHAuthentications = new ArrayList<SVNAuthentication>();
        this.myUserNameAuthentications = new ArrayList<SVNAuthentication>();
        this.mySSLAuthentications = new ArrayList<SVNAuthentication>();
        this.myPasswordIndex = 0;
        this.mySSHIndex = 0;
        this.mySSLIndex = 0;
        this.myUserNameIndex = 0;
        for (int i = 0; authentications != null && i < authentications.length; ++i) {
            SVNAuthentication auth = authentications[i];
            if (auth instanceof SVNPasswordAuthentication) {
                this.myPasswordAuthentications.add(auth);
                continue;
            }
            if (auth instanceof SVNSSHAuthentication) {
                this.mySSHAuthentications.add(auth);
                continue;
            }
            if (auth instanceof SVNUserNameAuthentication) {
                this.myUserNameAuthentications.add(auth);
                continue;
            }
            if (!(auth instanceof SVNSSLAuthentication)) continue;
            this.mySSLAuthentications.add(auth);
        }
    }

    public void setProxy(String proxyHost, int proxyPort, String proxyUserName, String proxyPassword) {
        this.setProxy(proxyHost, proxyPort, proxyUserName, proxyPassword != null ? proxyPassword.toCharArray() : null);
    }

    public void setProxy(String proxyHost, int proxyPort, String proxyUserName, char[] proxyPassword) {
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort >= 0 ? proxyPort : 3128;
        this.myProxyUserName = proxyUserName;
        this.myProxyPassword = proxyPassword;
    }

    @Override
    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        if ("svn.ssh".equals(kind) && this.mySSHAuthentications.size() > 0) {
            this.mySSHIndex = 0;
            return this.mySSHAuthentications.get(0);
        }
        if ("svn.simple".equals(kind) && this.myPasswordAuthentications.size() > 0) {
            this.myPasswordIndex = 0;
            return this.myPasswordAuthentications.get(0);
        }
        if ("svn.username".equals(kind) && this.myUserNameAuthentications.size() > 0) {
            this.myUserNameIndex = 0;
            return this.myUserNameAuthentications.get(0);
        }
        if ("svn.ssl.client-passphrase".equals(kind) && this.mySSLAuthentications.size() > 0) {
            this.mySSLIndex = 0;
            return this.mySSLAuthentications.get(0);
        }
        if ("svn.username".equals(kind)) {
            if (url.getUserInfo() != null && !"".equals(url.getUserInfo())) {
                return SVNUserNameAuthentication.newInstance(url.getUserInfo(), false, url, false);
            }
            return SVNUserNameAuthentication.newInstance(null, false, url, false);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    @Override
    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        if ("svn.ssh".equals(kind) && this.mySSHIndex + 1 < this.mySSHAuthentications.size()) {
            ++this.mySSHIndex;
            return this.mySSHAuthentications.get(this.mySSHIndex);
        }
        if ("svn.simple".equals(kind) && this.myPasswordIndex + 1 < this.myPasswordAuthentications.size()) {
            ++this.myPasswordIndex;
            return this.myPasswordAuthentications.get(this.myPasswordIndex);
        }
        if ("svn.username".equals(kind) && this.myUserNameIndex + 1 < this.myUserNameAuthentications.size()) {
            ++this.myUserNameIndex;
            return this.myUserNameAuthentications.get(this.myUserNameIndex);
        }
        if ("svn.ssl.client-passphrase".equals(kind) && this.mySSLIndex + 1 < this.mySSLAuthentications.size()) {
            ++this.mySSLIndex;
            return this.mySSLAuthentications.get(this.mySSLIndex);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    @Override
    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
    }

    @Override
    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        return this;
    }

    @Override
    public TrustManager getTrustManager(SVNURL url) throws SVNException {
        return null;
    }

    @Override
    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) {
    }

    @Override
    public void acknowledgeTrustManager(TrustManager manager) {
    }

    @Override
    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean forced) {
        this.myIsAuthenticationForced = forced;
    }

    @Override
    public String getProxyHost() {
        return this.myProxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.myProxyPort;
    }

    @Override
    public String getProxyUserName() {
        return this.myProxyUserName;
    }

    @Override
    public String getProxyPassword() {
        return this.myProxyPassword != null ? new String(this.myProxyPassword) : null;
    }

    @Override
    public char[] getProxyPasswordValue() {
        return this.myProxyPassword;
    }

    @Override
    public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
    }

    @Override
    public int getReadTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return 3600000;
        }
        return 0;
    }

    @Override
    public int getConnectTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return 60000;
        }
        return 0;
    }

    @Override
    public void verifyHostKey(String hostName, int port, String keyAlgorithm, byte[] hostKey) throws SVNException {
    }

    public void dismissSensitiveData() {
        this.dismissSensitiveData(this.myPasswordAuthentications);
        this.dismissSensitiveData(this.mySSHAuthentications);
        this.dismissSensitiveData(this.myUserNameAuthentications);
        this.dismissSensitiveData(this.mySSLAuthentications);
        this.myPasswordIndex = 0;
        this.mySSHIndex = 0;
        this.mySSLIndex = 0;
        this.myUserNameIndex = 0;
    }

    private void dismissSensitiveData(List<SVNAuthentication> auths) {
        if (auths == null) {
            return;
        }
        for (SVNAuthentication auth : auths) {
            auth.dismissSensitiveData();
        }
        auths.clear();
    }
}

