/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.delta;

import afu.org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import java.nio.ByteBuffer;

public abstract class SVNDeltaAlgorithm {
    private ByteBuffer myNewData = ByteBuffer.allocate(1024);
    private ByteBuffer myData = ByteBuffer.allocate(2048);
    private int myNewDataLength;
    private int myInstructionsLength;
    private SVNDiffInstruction myTemplateInstruction = new SVNDiffInstruction(0, 0, 0);

    public void reset() {
        this.myNewData.clear();
        this.myData.clear();
        this.myInstructionsLength = 0;
        this.myNewDataLength = 0;
    }

    public abstract void computeDelta(byte[] var1, int var2, byte[] var3, int var4);

    public ByteBuffer getData() {
        if (this.myNewData.position() > 0) {
            this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, this.myNewData.position());
            this.myData.put(this.myNewData.array(), 0, this.myNewData.position());
            this.myNewData.clear();
        }
        this.myData.flip();
        return this.myData;
    }

    public int getInstructionsLength() {
        return this.myInstructionsLength;
    }

    public int getNewDataLength() {
        return this.myNewDataLength;
    }

    protected void copyFromSource(int position, int length) {
        this.myTemplateInstruction.type = 0;
        this.myTemplateInstruction.offset = position;
        this.myTemplateInstruction.length = length;
        this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, 10);
        this.myTemplateInstruction.writeTo(this.myData);
        this.myInstructionsLength = this.myData.position();
    }

    protected void copyFromTarget(int position, int length) {
        this.myTemplateInstruction.type = 1;
        this.myTemplateInstruction.offset = position;
        this.myTemplateInstruction.length = length;
        this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, 10);
        this.myTemplateInstruction.writeTo(this.myData);
        this.myInstructionsLength = this.myData.position();
    }

    protected void copyFromNewData(byte[] data, int offset, int length) {
        this.myTemplateInstruction.type = 2;
        this.myTemplateInstruction.offset = 0;
        this.myTemplateInstruction.length = length;
        this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, 10);
        this.myTemplateInstruction.writeTo(this.myData);
        this.myInstructionsLength = this.myData.position();
        this.myNewData = SVNDeltaAlgorithm.ensureBufferSize(this.myNewData, length);
        this.myNewData.put(data, offset, length);
        this.myNewDataLength += length;
    }

    private static ByteBuffer ensureBufferSize(ByteBuffer buffer, int size) {
        if (buffer.remaining() < size) {
            ByteBuffer newBuffer = ByteBuffer.allocate((buffer.position() + size) * 3 / 2);
            newBuffer.put(buffer.array(), 0, buffer.position());
            buffer = newBuffer;
        }
        return buffer;
    }
}

