/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNMergeInfo;
import afu.org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import afu.org.tmatesoft.svn.core.SVNMergeRange;
import afu.org.tmatesoft.svn.core.SVNMergeRangeList;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSFS;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNMergeInfoManager;
import afu.org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import afu.org.tmatesoft.svn.core.io.SVNFileRevision;
import afu.org.tmatesoft.svn.core.io.SVNLocationEntry;
import afu.org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class FSFileRevisionsFinder {
    private FSFS myFSFS;
    private SVNDeltaGenerator myDeltaGenerator;

    public FSFileRevisionsFinder(FSFS fsfs) {
        this.myFSFS = fsfs;
    }

    public int getFileRevisions(String path, long startRevision, long endRevision, boolean includeMergedRevisions, ISVNFileRevisionHandler handler) throws SVNException {
        SVNLocationEntry mainPathRev;
        SVNHashMap duplicatePathRevs = new SVNHashMap();
        LinkedList mainLinePathRevisions = this.findInterestingRevisions(null, path, startRevision, endRevision, includeMergedRevisions, false, duplicatePathRevs);
        LinkedList mergedPathRevisions = null;
        mergedPathRevisions = includeMergedRevisions ? this.findMergedRevisions(mainLinePathRevisions, duplicatePathRevs) : new LinkedList();
        SVNErrorManager.assertionFailure(!mainLinePathRevisions.isEmpty(), "no main line path revisions found", SVNLogType.FSFS);
        SendBaton sb = new SendBaton();
        sb.myLastProps = new SVNProperties();
        int mainLinePos = mainLinePathRevisions.size() - 1;
        int mergedPos = mergedPathRevisions.size() - 1;
        int i = 0;
        while (mainLinePos >= 0 && mergedPos >= 0) {
            mainPathRev = (SVNLocationEntry)mainLinePathRevisions.get(mainLinePos);
            SVNLocationEntry mergedPathRev = (SVNLocationEntry)mergedPathRevisions.get(mergedPos);
            if (mainPathRev.getRevision() <= mergedPathRev.getRevision()) {
                this.sendPathRevision(mainPathRev, sb, handler);
                --mainLinePos;
            } else {
                this.sendPathRevision(mergedPathRev, sb, handler);
                --mergedPos;
            }
            ++i;
        }
        while (mainLinePos >= 0) {
            mainPathRev = (SVNLocationEntry)mainLinePathRevisions.get(mainLinePos);
            this.sendPathRevision(mainPathRev, sb, handler);
            ++i;
            --mainLinePos;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPathRevision(SVNLocationEntry pathRevision, SendBaton sendBaton, ISVNFileRevisionHandler handler) throws SVNException {
        SVNProperties props;
        FSRevisionRoot root;
        block2: {
            block3: {
                SVNProperties revProps = this.myFSFS.getRevisionProperties(pathRevision.getRevision());
                root = this.myFSFS.createRevisionRoot(pathRevision.getRevision());
                FSRevisionNode fileNode = root.getRevisionNode(pathRevision.getPath());
                props = fileNode.getProperties(this.myFSFS);
                SVNProperties propDiffs = FSRepositoryUtil.getPropsDiffs(sendBaton.myLastProps, props);
                boolean contentsChanged = false;
                contentsChanged = sendBaton.myLastRoot != null ? FSRepositoryUtil.areFileContentsChanged(sendBaton.myLastRoot, sendBaton.myLastPath, root, pathRevision.getPath()) : true;
                if (handler == null) break block2;
                handler.openRevision(new SVNFileRevision(pathRevision.getPath(), pathRevision.getRevision(), revProps, propDiffs, pathRevision.isResultOfMerge()));
                if (!contentsChanged) break block3;
                SVNDeltaCombiner sourceCombiner = new SVNDeltaCombiner();
                SVNDeltaCombiner targetCombiner = new SVNDeltaCombiner();
                handler.applyTextDelta(pathRevision.getPath(), null);
                InputStream sourceStream = null;
                InputStream targetStream = null;
                try {
                    sourceStream = sendBaton.myLastRoot != null && sendBaton.myLastPath != null ? sendBaton.myLastRoot.getFileStreamForPath(sourceCombiner, sendBaton.myLastPath) : FSInputStream.createDeltaStream(sourceCombiner, (FSRevisionNode)null, this.myFSFS);
                    targetStream = root.getFileStreamForPath(targetCombiner, pathRevision.getPath());
                    SVNDeltaGenerator deltaGenerator = this.getDeltaGenerator();
                    deltaGenerator.sendDelta(pathRevision.getPath(), sourceStream, 0L, targetStream, handler, false);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(sourceStream);
                    SVNFileUtil.closeFile(targetStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(sourceStream);
                SVNFileUtil.closeFile(targetStream);
                handler.closeRevision(pathRevision.getPath());
                break block2;
            }
            handler.closeRevision(pathRevision.getPath());
        }
        sendBaton.myLastRoot = root;
        sendBaton.myLastPath = pathRevision.getPath();
        sendBaton.myLastProps = props;
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private LinkedList findMergedRevisions(LinkedList mainLinePathRevisions, Map duplicatePathRevs) throws SVNException {
        LinkedList mergedPathRevisions = new LinkedList();
        LinkedList oldPathRevisions = mainLinePathRevisions;
        LinkedList newPathRevisions = null;
        do {
            newPathRevisions = new LinkedList();
            for (SVNLocationEntry oldPathRevision : oldPathRevisions) {
                Map mergedMergeInfo = oldPathRevision.getMergedMergeInfo();
                if (mergedMergeInfo == null) continue;
                for (String path : mergedMergeInfo.keySet()) {
                    SVNMergeRangeList rangeList = (SVNMergeRangeList)mergedMergeInfo.get(path);
                    SVNMergeRange[] ranges = rangeList.getRanges();
                    for (int j = 0; j < ranges.length; ++j) {
                        SVNMergeRange range = ranges[j];
                        FSRevisionRoot root = this.myFSFS.createRevisionRoot(range.getEndRevision());
                        SVNNodeKind kind = root.checkNodeKind(path);
                        if (kind != SVNNodeKind.FILE) continue;
                        newPathRevisions = this.findInterestingRevisions(newPathRevisions, path, range.getStartRevision(), range.getEndRevision(), true, true, duplicatePathRevs);
                    }
                }
            }
            mergedPathRevisions.addAll(newPathRevisions);
            oldPathRevisions = newPathRevisions;
        } while (!newPathRevisions.isEmpty());
        Collections.sort(mergedPathRevisions, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                SVNLocationEntry pathRevision1 = (SVNLocationEntry)arg0;
                SVNLocationEntry pathRevision2 = (SVNLocationEntry)arg1;
                if (pathRevision1.getRevision() == pathRevision2.getRevision()) {
                    return 0;
                }
                return pathRevision1.getRevision() < pathRevision2.getRevision() ? 1 : -1;
            }
        });
        return mergedPathRevisions;
    }

    private LinkedList findInterestingRevisions(LinkedList pathRevisions, String path, long startRevision, long endRevision, boolean includeMergedRevisions, boolean markAsMerged, Map duplicatePathRevs) throws SVNException {
        FSRevisionRoot root = this.myFSFS.createRevisionRoot(endRevision);
        if (root.checkNodeKind(path) != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "''{0}'' is not a file in revision ''{1}''", path, new Long(endRevision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        pathRevisions = pathRevisions == null ? new LinkedList() : pathRevisions;
        FSNodeHistory history = root.getNodeHistory(path);
        while ((history = history.getPreviousHistory(true)) != null) {
            long histRev = history.getHistoryEntry().getRevision();
            String histPath = history.getHistoryEntry().getPath();
            if (includeMergedRevisions && duplicatePathRevs.containsKey(histPath + ":" + histRev)) break;
            SVNLocationEntry pathRev = null;
            Map mergedMergeInfo = null;
            if (includeMergedRevisions) {
                mergedMergeInfo = this.getMergedMergeInfo(histPath, histRev);
                pathRev = new SVNLocationEntry(histRev, histPath, markAsMerged, mergedMergeInfo);
                duplicatePathRevs.put(histPath + ":" + histRev, pathRev);
            } else {
                pathRev = new SVNLocationEntry(histRev, histPath, markAsMerged, null);
            }
            pathRevisions.addLast(pathRev);
            if (histRev > startRevision) continue;
            break;
        }
        return pathRevisions;
    }

    private Map getMergedMergeInfo(String path, long revision) throws SVNException {
        Map currentMergeInfo = this.getPathMergeInfo(path, revision);
        TreeMap previousMergeInfo = null;
        try {
            previousMergeInfo = this.getPathMergeInfo(path, revision - 1L);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                previousMergeInfo = new TreeMap();
            }
            throw svne;
        }
        TreeMap<String, SVNMergeRangeList> deleted = new TreeMap<String, SVNMergeRangeList>();
        Map<String, SVNMergeRangeList> changed = new TreeMap<String, SVNMergeRangeList>();
        SVNMergeInfoUtil.diffMergeInfo(deleted, changed, previousMergeInfo, currentMergeInfo, false);
        changed = SVNMergeInfoUtil.mergeMergeInfos(changed, deleted);
        return changed;
    }

    public Map getPathMergeInfo(String path, long revision) throws SVNException {
        SVNMergeInfoManager mergeInfoManager = new SVNMergeInfoManager();
        FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
        Map tmpMergeInfo = mergeInfoManager.getMergeInfo(new String[]{path}, root, SVNMergeInfoInheritance.INHERITED, false);
        SVNMergeInfo mergeInfo = (SVNMergeInfo)tmpMergeInfo.get(path);
        if (mergeInfo != null) {
            return mergeInfo.getMergeSourcesToMergeLists();
        }
        return new TreeMap();
    }

    private static class SendBaton {
        private FSRevisionRoot myLastRoot;
        private String myLastPath;
        private SVNProperties myLastProps;

        private SendBaton() {
        }
    }
}

