/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.util;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public class SVNUUIDGenerator {
    private static final int NODE_LENGTH = 6;
    private static byte[] ourUUIDStateNode = new byte[6];
    private static long ourUUIDStateSeqNum;
    private static long ourLastGeneratedTime;
    private static long ourFudgeFactor;

    private static long getCurrentTime() {
        long currentTime = System.currentTimeMillis();
        if (ourLastGeneratedTime != currentTime) {
            ourFudgeFactor = ourLastGeneratedTime + ourFudgeFactor > currentTime ? ourLastGeneratedTime + ourFudgeFactor - currentTime + 1L : 0L;
            ourLastGeneratedTime = currentTime;
        } else {
            ++ourFudgeFactor;
        }
        return currentTime + ourFudgeFactor;
    }

    public static String generateUUIDString() throws SVNException {
        return SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
    }

    public static synchronized byte[] generateUUID() throws SVNException {
        if (ourUUIDStateNode[0] == 0) {
            SVNUUIDGenerator.initState();
        }
        long timestamp = SVNUUIDGenerator.getCurrentTime();
        byte[] uuidData = new byte[16];
        uuidData[0] = (byte)timestamp;
        uuidData[1] = (byte)(timestamp >> 8);
        uuidData[2] = (byte)(timestamp >> 16);
        uuidData[3] = (byte)(timestamp >> 24);
        uuidData[4] = (byte)(timestamp >> 32);
        uuidData[5] = (byte)(timestamp >> 40);
        uuidData[6] = (byte)(timestamp >> 48);
        uuidData[7] = (byte)(timestamp >> 56 & 0xFL | 0x10L);
        uuidData[8] = (byte)(ourUUIDStateSeqNum >> 8 & 0x3FL | 0x80L);
        uuidData[9] = (byte)ourUUIDStateSeqNum;
        System.arraycopy(ourUUIDStateNode, 0, uuidData, 10, 6);
        return uuidData;
    }

    public static String formatUUID(byte[] uuid) {
        if (uuid.length < 16) {
            byte[] tmpBuf = new byte[16];
            Arrays.fill(tmpBuf, (byte)0);
            System.arraycopy(uuid, 0, tmpBuf, 0, uuid.length);
            uuid = tmpBuf;
        }
        StringBuffer sb = new StringBuffer();
        SVNFormatUtil.appendHexNumber(sb, uuid[0]);
        SVNFormatUtil.appendHexNumber(sb, uuid[1]);
        SVNFormatUtil.appendHexNumber(sb, uuid[2]);
        SVNFormatUtil.appendHexNumber(sb, uuid[3]);
        sb.append('-');
        SVNFormatUtil.appendHexNumber(sb, uuid[4]);
        SVNFormatUtil.appendHexNumber(sb, uuid[5]);
        sb.append('-');
        SVNFormatUtil.appendHexNumber(sb, uuid[6]);
        SVNFormatUtil.appendHexNumber(sb, uuid[7]);
        sb.append('-');
        SVNFormatUtil.appendHexNumber(sb, uuid[8]);
        SVNFormatUtil.appendHexNumber(sb, uuid[9]);
        sb.append('-');
        SVNFormatUtil.appendHexNumber(sb, uuid[10]);
        SVNFormatUtil.appendHexNumber(sb, uuid[11]);
        SVNFormatUtil.appendHexNumber(sb, uuid[12]);
        SVNFormatUtil.appendHexNumber(sb, uuid[13]);
        SVNFormatUtil.appendHexNumber(sb, uuid[14]);
        SVNFormatUtil.appendHexNumber(sb, uuid[15]);
        return sb.toString();
    }

    private static void initState() throws SVNException {
        long currentTime = System.currentTimeMillis() * 10L + 122192928000000000L;
        Random randomGen = new Random();
        randomGen.setSeed((currentTime >> 32 ^ currentTime) & 0xFFFFFFFFL);
        ourUUIDStateSeqNum = randomGen.nextLong() & 0xFFFFL;
        SVNUUIDGenerator.getRandomInfo(ourUUIDStateNode);
    }

    private static void getRandomInfo(byte[] node) throws SVNException {
        UID uid = new UID();
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
        digest.update(uid.toString().getBytes());
        byte[] seed = digest.digest();
        int numToCopy = node.length < seed.length ? node.length : seed.length;
        System.arraycopy(seed, 0, node, 0, numToCopy);
        node[0] = (byte)(node[0] | 1);
    }
}

