/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.SVNCommitInfo;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.io.ISVNEditor;
import afu.org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.OutputStream;

public class SVNDepthFilterEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private SVNDepth myRequestedDepth;
    private boolean myHasTarget;
    private NodeBaton myCurrentNodeBaton;

    private SVNDepthFilterEditor(SVNDepth depth, ISVNEditor delegate, boolean hasTarget) {
        this.myRequestedDepth = depth;
        this.myDelegate = delegate;
        this.myHasTarget = hasTarget;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.absentDir(path);
        }
    }

    @Override
    public void absentFile(String path) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.absentFile(path);
        }
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.DIR)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
            this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.FILE)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
            this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.changeDirProperty(name, value);
        }
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.changeFileProperty(path, name, value);
        }
    }

    @Override
    public void closeDir() throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.closeDir();
        }
        this.myCurrentNodeBaton = this.myCurrentNodeBaton.myParentBaton;
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        return this.myDelegate.closeEdit();
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.closeFile(path, textChecksum);
        }
        this.myCurrentNodeBaton = this.myCurrentNodeBaton.myParentBaton;
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.FILE)) {
            this.myDelegate.deleteEntry(path, revision);
        }
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.DIR)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
            this.myDelegate.openDir(path, revision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.FILE)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
            this.myDelegate.openFile(path, revision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myCurrentNodeBaton = new NodeBaton(false, 1, null);
        this.myDelegate.openRoot(revision);
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.myDelegate.targetRevision(revision);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.applyTextDelta(path, baseChecksum);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            return this.myDelegate.textDeltaChunk(path, diffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.textDeltaEnd(path);
        }
    }

    public static ISVNEditor getDepthFilterEditor(SVNDepth requestedDepth, ISVNEditor delegate, boolean hasTarget) {
        if (requestedDepth == SVNDepth.UNKNOWN || requestedDepth == SVNDepth.INFINITY) {
            return delegate;
        }
        return new SVNDepthFilterEditor(requestedDepth, delegate, hasTarget);
    }

    private class NodeBaton {
        boolean myIsFiltered;
        int myDirDepth;
        NodeBaton myParentBaton;

        public NodeBaton(boolean isFiltered, int depth, NodeBaton parent) {
            this.myIsFiltered = isFiltered;
            this.myDirDepth = depth;
            this.myParentBaton = parent;
        }

        public boolean canEdit(SVNNodeKind entryKind) throws SVNException {
            if (this.myIsFiltered) {
                return false;
            }
            int effectiveDepth = this.myDirDepth - (SVNDepthFilterEditor.this.myHasTarget ? 1 : 0);
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.EMPTY) {
                return effectiveDepth <= 0;
            }
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.FILES) {
                return effectiveDepth <= 0 || entryKind == SVNNodeKind.FILE && effectiveDepth == 1;
            }
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.IMMEDIATES) {
                return effectiveDepth <= 1;
            }
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.INFINITY) {
                return true;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "depth should be a valid constant");
            SVNErrorManager.error(err, SVNLogType.WC);
            return false;
        }
    }
}

