/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.SVNAuthenticationException;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.logging.Level;

public class SVNErrorManager {
    public static void cancel(String message, SVNLogType logType) throws SVNCancelException {
        SVNErrorManager.cancel(message, Level.FINE, logType);
    }

    public static void cancel(String message, Level logLevel, SVNLogType logType) throws SVNCancelException {
        SVNDebugLog.getDefaultLog().log(logType, message, logLevel);
        throw new SVNCancelException(SVNErrorMessage.create(SVNErrorCode.CANCELLED, message));
    }

    public static void authenticationFailed(String message, Object messageObject) throws SVNAuthenticationException {
        SVNErrorManager.authenticationFailed(message, messageObject, Level.FINE);
    }

    public static void authenticationFailed(String message, Object messageObject, Level logLevel) throws SVNAuthenticationException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, message, messageObject);
        SVNDebugLog.getDefaultLog().log(SVNLogType.NETWORK, err.getMessage(), logLevel);
        throw new SVNAuthenticationException(err);
    }

    public static void error(SVNErrorMessage err, SVNLogType logType) throws SVNException {
        SVNErrorManager.error(err, Level.FINE, logType);
    }

    public static void error(SVNErrorMessage err, Level logLevel, SVNLogType logType) throws SVNException {
        if (err == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        SVNDebugLog.getDefaultLog().log(logType, err.getFullMessage(), logLevel);
        if (err.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err);
        }
        if (err.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err);
        }
        throw new SVNException(err);
    }

    public static void error(SVNErrorMessage err, Throwable cause, SVNLogType logType) throws SVNException {
        SVNErrorManager.error(err, cause, Level.FINE, logType);
    }

    public static void error(SVNErrorMessage err, Throwable cause, Level logLevel, SVNLogType logType) throws SVNException {
        if (err == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        SVNDebugLog.getDefaultLog().log(logType, err.getMessage(), logLevel);
        if (cause != null) {
            SVNDebugLog.getDefaultLog().log(logType, cause, logLevel);
        }
        if (err.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err);
        }
        if (err.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err);
        }
        throw new SVNException(err, cause);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2, SVNLogType logType) throws SVNException {
        SVNErrorManager.error(err1, err2, Level.FINE, logType);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2, Level logLevel, SVNLogType logType) throws SVNException {
        if (err1 == null) {
            SVNErrorManager.error(err2, logLevel, logType);
        } else if (err2 == null) {
            SVNErrorManager.error(err1, logLevel, logType);
        }
        err1.setChildErrorMessage(err2);
        SVNDebugLog.getDefaultLog().log(logType, err1.getMessage(), logLevel);
        if (err1.getErrorCode() == SVNErrorCode.CANCELLED || err2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err1);
        }
        if (err1.getErrorCode().isAuthentication() || err2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err1);
        }
        throw new SVNException(err1);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2, Throwable cause, SVNLogType logType) throws SVNException {
        SVNErrorManager.error(err1, err2, cause, Level.FINE, logType);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2, Throwable cause, Level logLevel, SVNLogType logType) throws SVNException {
        if (err1 == null) {
            SVNErrorManager.error(err2, cause, logLevel, logType);
        } else if (err2 == null) {
            SVNErrorManager.error(err1, cause, logLevel, logType);
        }
        err1.setChildErrorMessage(err2);
        SVNDebugLog.getDefaultLog().log(logType, err1.getMessage(), logLevel);
        if (err1.getErrorCode() == SVNErrorCode.CANCELLED || err2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err1, cause);
        }
        if (err1.getErrorCode().isAuthentication() || err2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err1, cause);
        }
        throw new SVNException(err1, cause);
    }

    public static void assertionFailure(boolean isTrueCondition, String optionalMessage, SVNLogType logType) throws SVNException {
        if (!isTrueCondition) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                StackTraceElement callerStackElement = stackTraceElements[1];
                String genericAssertionFailureReport = "Assertion failure in class ''{0}'' (file {1}) in method ''{2}'' on line {3}";
                genericAssertionFailureReport = optionalMessage != null ? genericAssertionFailureReport + ": {4}" : genericAssertionFailureReport;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, genericAssertionFailureReport, callerStackElement.getClassName(), callerStackElement.getFileName(), callerStackElement.getMethodName(), String.valueOf(callerStackElement.getLineNumber()), optionalMessage);
                SVNErrorManager.error(err, logType);
            }
        }
    }
}

