/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc.admin;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import afu.org.tmatesoft.svn.core.internal.wc.SVNSubstitutor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SVNTranslatorOutputStream
extends OutputStream {
    private SVNSubstitutor mySubstitutor;
    private OutputStream myDst;
    private ByteBuffer mySrcBuffer;
    private ByteBuffer myDstBuffer;

    public SVNTranslatorOutputStream(OutputStream dst, byte[] eol, boolean repair, Map keywords, boolean expand) {
        this.mySubstitutor = new SVNSubstitutor(eol, repair, keywords, expand);
        this.myDst = dst;
        this.mySrcBuffer = ByteBuffer.allocate(2048);
        this.myDstBuffer = ByteBuffer.allocate(2048);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mySrcBuffer = SVNTranslatorOutputStream.write(this.mySrcBuffer, b, off, len);
        this.mySrcBuffer.flip();
        try {
            this.myDstBuffer = this.mySubstitutor.translateChunk(this.mySrcBuffer, this.myDstBuffer);
        }
        catch (SVNException svne) {
            IOExceptionWrapper wrappedException = new IOExceptionWrapper(svne);
            throw wrappedException;
        }
        this.myDstBuffer.flip();
        this.myDst.write(this.myDstBuffer.array(), this.myDstBuffer.arrayOffset() + this.myDstBuffer.position(), this.myDstBuffer.remaining());
        this.mySrcBuffer.clear();
        this.myDstBuffer.clear();
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myDstBuffer = this.mySubstitutor.translateChunk(null, this.myDstBuffer);
        }
        catch (SVNException svne) {
            IOExceptionWrapper wrappedException = new IOExceptionWrapper(svne);
            throw wrappedException;
        }
        this.myDstBuffer.flip();
        if (this.myDstBuffer.hasRemaining()) {
            this.myDst.write(this.myDstBuffer.array(), this.myDstBuffer.arrayOffset() + this.myDstBuffer.position(), this.myDstBuffer.remaining());
        }
        this.myDstBuffer.clear();
        this.myDst.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.myDst.close();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    private static ByteBuffer write(ByteBuffer dst, byte[] bytes, int offset, int length) {
        if (dst.remaining() < length) {
            ByteBuffer newDst = ByteBuffer.allocate((dst.position() + length) * 3 / 2);
            dst.flip();
            dst = newDst.put(dst);
        }
        return dst.put(bytes, offset, length);
    }
}

