/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SvnNgInheritableProperties {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<File, Map<String, SVNProperties>> getInheritalbeProperites(SVNWCContext context, SVNRepository repository, File localAbsPath, long revision, SVNDepth depth) throws SVNException {
        SVNURL originalLocation = repository.getLocation();
        HashMap<File, Map<String, SVNProperties>> result = new HashMap<File, Map<String, SVNProperties>>();
        SVNWCDb.DirParsedInfo pdh = ((SVNWCDb)context.getDb()).parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbRoot wcRoot = pdh.wcDbDir.getWCRoot();
        File localRelPath = pdh.localRelPath;
        try {
            Map<File, File> nodesWithIProps = SvnWcDbProperties.getInheritedPropertiesNodes(wcRoot, localRelPath, depth);
            if (!nodesWithIProps.containsKey(localAbsPath) && SvnNgInheritableProperties.needsCachedIProps(context, localAbsPath, repository)) {
                nodesWithIProps.put(localAbsPath, localAbsPath);
            }
            for (File localNodeAbsPath : nodesWithIProps.keySet()) {
                String reposNodePath = SVNFileUtil.getFilePath(nodesWithIProps.get(localNodeAbsPath));
                if ("".equals(reposNodePath)) continue;
                SVNURL nodeURL = context.getNodeUrl(localNodeAbsPath);
                repository.setLocation(nodeURL, false);
                Map<String, SVNProperties> iprops = null;
                try {
                    iprops = repository.getInheritedProperties("", revision, null);
                    iprops = SvnNgInheritableProperties.translateInheritedPropertiesPaths(iprops);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) continue;
                    throw e;
                }
                result.put(localNodeAbsPath, iprops);
            }
        }
        finally {
            repository.setLocation(originalLocation, false);
        }
        return result;
    }

    public static Map<String, SVNProperties> translateInheritedPropertiesPaths(Map<String, SVNProperties> iprops) {
        HashMap<String, SVNProperties> filtered = new HashMap<String, SVNProperties>();
        for (String path : iprops.keySet()) {
            SVNProperties props = iprops.get(path);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            filtered.put(path, props);
        }
        return filtered;
    }

    private static boolean needsCachedIProps(SVNWCContext context, File localAbsPath, SVNRepository repository) throws SVNException {
        SVNWCContext.CheckWCRootInfo rootInfo = null;
        try {
            rootInfo = context.checkWCRoot(localAbsPath, true);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return false;
            }
            throw e;
        }
        if (rootInfo != null && (rootInfo.switched || rootInfo.wcRoot)) {
            SVNURL root;
            SVNURL location = repository.getLocation();
            return !location.equals(root = repository.getRepositoryRoot(true));
        }
        return false;
    }
}

