/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc.SVNPropertyData;
import afu.org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import afu.org.tmatesoft.svn.core.wc2.SvnSetProperty;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import java.io.File;

public class SvnNgSetProperty
extends SvnNgOperationRunner<SVNPropertyData, SvnSetProperty> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SVNPropertyData run(SVNWCContext context) throws SVNException {
        SvnNgPropertiesManager.checkPropertyName(((SvnSetProperty)this.getOperation()).getPropertyName(), ((SvnSetProperty)this.getOperation()).getPropertyValue());
        for (SvnTarget target : ((SvnSetProperty)this.getOperation()).getTargets()) {
            File localAbsPath = target.getFile();
            SVNNodeKind kind = SVNNodeKind.NONE;
            try {
                kind = this.getWcContext().readKind(this.getFirstTarget(), false);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    this.notifyNonExistentPath(localAbsPath);
                }
                throw e;
            }
            if (kind == SVNNodeKind.NONE || kind == SVNNodeKind.UNKNOWN) {
                this.notifyNonExistentPath(localAbsPath);
            }
            File lockedPath = context.acquireWriteLock(localAbsPath, false, true);
            try {
                SvnNgPropertiesManager.setProperty(this.getWcContext(), localAbsPath, ((SvnSetProperty)this.getOperation()).getPropertyName(), ((SvnSetProperty)this.getOperation()).getPropertyValue(), ((SvnSetProperty)this.getOperation()).getPropertyValueProvider(), ((SvnSetProperty)this.getOperation()).getDepth(), ((SvnSetProperty)this.getOperation()).isForce(), ((SvnSetProperty)this.getOperation()).getEventHandler(), (ISvnObjectReceiver)this.getOperation(), ((SvnSetProperty)this.getOperation()).getApplicableChangelists());
            }
            finally {
                context.releaseWriteLock(lockedPath);
            }
        }
        return (SVNPropertyData)((SvnSetProperty)this.getOperation()).first();
    }

    private void notifyNonExistentPath(File localAbsPath) throws SVNException {
        SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.PATH_NONEXISTENT, SVNEventAction.PATH_NONEXISTENT, null, null, -1L, -1L);
        if (((SvnSetProperty)this.getOperation()).getEventHandler() != null) {
            ((SvnSetProperty)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
        }
    }

    @Override
    public boolean isApplicable(SvnSetProperty operation, SvnWcGeneration wcGeneration) throws SVNException {
        return !operation.isRevisionProperty() && super.isApplicable(operation, wcGeneration);
    }
}

