/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.patch;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import afu.org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

public class SvnPropertiesPatchTarget
extends SvnTargetContent {
    private String name;
    private SVNPropertyValue value;
    private SVNPropertyValue patchedValue;
    private SvnDiffCallback.OperationKind operation;

    public static SvnPropertiesPatchTarget initPropTarget(String propName, SvnDiffCallback.OperationKind operation, SVNWCContext context, File absPath) throws SVNException {
        SVNPropertyValue value;
        SvnPropertiesPatchTarget propPatchTarget = new SvnPropertiesPatchTarget();
        propPatchTarget.setCurrentLine(1);
        propPatchTarget.setEolStyle(SVNWCContext.SVNEolStyle.None);
        propPatchTarget.setName(propName);
        propPatchTarget.setOperation(operation);
        try {
            SVNProperties actualProps = context.getActualProps(absPath);
            value = actualProps.getSVNPropertyValue(propName);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                value = null;
            }
            throw e;
        }
        propPatchTarget.setExisted(value != null);
        propPatchTarget.setValue(value);
        propPatchTarget.setPatchedValue(SVNPropertyValue.create(""));
        PropReadCallbacks propCallbacks = new PropReadCallbacks(propPatchTarget, value, 0L);
        propPatchTarget.setReadBaton(propCallbacks);
        propPatchTarget.setReadLineCallback(propCallbacks);
        propPatchTarget.setTellCallback(propCallbacks);
        propPatchTarget.setSeekCallback(propCallbacks);
        propPatchTarget.setWriteCallback(propCallbacks);
        propPatchTarget.setWriteBaton(propPatchTarget.getPatchedValue());
        return propPatchTarget;
    }

    public String getName() {
        return this.name;
    }

    public SVNPropertyValue getValue() {
        return this.value;
    }

    public SVNPropertyValue getPatchedValue() {
        return this.patchedValue;
    }

    public SvnDiffCallback.OperationKind getOperation() {
        return this.operation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(SVNPropertyValue value) {
        this.value = value;
    }

    public void setPatchedValue(SVNPropertyValue patchedValue) {
        this.patchedValue = patchedValue;
    }

    public void setOperation(SvnDiffCallback.OperationKind operation) {
        this.operation = operation;
    }

    private static class PropReadCallbacks
    implements SvnTargetContent.ITellCallback,
    SvnTargetContent.IRealLineCallback,
    SvnTargetContent.ISeekCallback,
    SvnTargetContent.IWriteCallback {
        private final SvnPropertiesPatchTarget propPatchTarget;
        private SVNPropertyValue value;
        private long offset;

        private PropReadCallbacks(SvnPropertiesPatchTarget propPatchTarget, SVNPropertyValue value, long offset) {
            this.propPatchTarget = propPatchTarget;
            this.value = value;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readLine(Object baton, String[] eolStr, boolean[] eof) throws SVNException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int pos;
                byte[] valueBytes = SVNPropertyValue.getPropertyAsBytes(this.value);
                if (this.offset >= (long)valueBytes.length) {
                    eolStr[0] = null;
                    eof[0] = true;
                    String string = null;
                    return string;
                }
                eolStr[0] = null;
                boolean foundEof = false;
                do {
                    pos = (int)this.offset;
                    ++this.offset;
                    if (pos == valueBytes.length || valueBytes[pos] == 0) {
                        foundEof = true;
                        break;
                    }
                    if (valueBytes[pos] == 10) {
                        eolStr[0] = "\n";
                        continue;
                    }
                    if (valueBytes[pos] == 13) {
                        eolStr[0] = "\r";
                        if (pos >= valueBytes.length || valueBytes[pos + 1] != 10) continue;
                        eolStr[0] = "\r\n";
                        ++this.offset;
                        continue;
                    }
                    byteArrayOutputStream.write(valueBytes[pos]);
                } while (eolStr[0] == null && pos < valueBytes.length);
                if (eof != null) {
                    eof[0] = foundEof;
                }
                String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                return string;
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile(byteArrayOutputStream);
            }
            return null;
        }

        @Override
        public void seek(Object object, long offset) {
            PropReadCallbacks propReadCallbacks = (PropReadCallbacks)object;
            propReadCallbacks.offset = offset;
        }

        @Override
        public long tell(Object readBaton) {
            PropReadCallbacks propReadCallbacks = (PropReadCallbacks)readBaton;
            return propReadCallbacks.offset;
        }

        @Override
        public void write(Object writeBaton, String s2) {
            this.propPatchTarget.patchedValue = SVNPropertyValue.create(SVNPropertyValue.getPropertyAsString(this.propPatchTarget.patchedValue) + s2);
        }
    }
}

