/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.remote;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNPropertyData;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc2.SvnSetProperty;
import afu.org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteSetRevisionProperty
extends SvnRemoteOperationRunner<SVNPropertyData, SvnSetProperty> {
    @Override
    public boolean isApplicable(SvnSetProperty operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.isRevisionProperty();
    }

    @Override
    protected SVNPropertyData run() throws SVNException {
        SVNErrorMessage err;
        String propertyName = ((SvnSetProperty)this.getOperation()).getPropertyName();
        SVNPropertyValue propertyValue = ((SvnSetProperty)this.getOperation()).getPropertyValue();
        boolean force = ((SvnSetProperty)this.getOperation()).isForce();
        SvnRepositoryAccess access = this.getRepositoryAccess();
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = access.createRepositoryFor(((SvnSetProperty)this.getOperation()).getFirstTarget(), SVNRevision.HEAD, SVNRevision.HEAD, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        if (propertyValue != null && !SVNPropertiesManager.isValidPropertyName(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!force && "svn:author".equals(propertyName) && propertyValue != null && propertyValue.isString() && propertyValue.getString().indexOf(10) >= 0) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE, "Value will not be set unless forced");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Structure<SvnRepositoryAccess.RevisionsPair> revPair = access.getRevisionNumber(repository, null, ((SvnSetProperty)this.getOperation()).getRevision(), null);
        long revNumber = revPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        repository.setRevisionPropertyValue(revNumber, propertyName, propertyValue);
        return new SVNPropertyData(propertyName, propertyValue, ((SvnSetProperty)this.getOperation()).getOptions());
    }
}

