/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.plume.JWhich;
import afu.plume.Option;
import afu.plume.OptionGroup;
import afu.plume.SimpleLog;
import afu.plume.StringBuilderDelimited;
import afu.plume.Unpublicized;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class Options {
    private static String eol = System.getProperty("line.separator");
    private boolean parse_options_after_arg = true;
    private String options_str = "";
    private Class<?> main_class = Void.TYPE;
    private final List<OptionInfo> options = new ArrayList<OptionInfo>();
    private final Map<String, OptionInfo> name_map = new LinkedHashMap<String, OptionInfo>();
    private final Map<String, OptionGroupInfo> group_map = new LinkedHashMap<String, OptionGroupInfo>();
    private boolean use_groups;
    private final boolean use_dashes = true;
    private boolean use_single_dash = false;
    private static final String LIST_HELP = "[+] marked option can be specified multiple times";
    private boolean print_list_help = false;
    @Option(value="Treat arguments to lists as space-separated.")
    public static boolean split_lists = false;
    public String usage_synopsis = null;
    private final SimpleLog debug_options = new SimpleLog(false);

    public void enableDebugLogging(boolean enabled) {
        this.debug_options.enabled = enabled;
    }

    public Options(Object ... args) {
        this("", args);
    }

    public Options(String usage_synopsis, Object ... args) {
        if (args.length == 0) {
            throw new Error("Must pass at least one object to Options constructor");
        }
        this.usage_synopsis = usage_synopsis;
        this.use_groups = false;
        boolean seen_first_opt = false;
        for (Object obj : args) {
            Field[] fields;
            Class<?> clazz;
            boolean is_class = obj instanceof Class;
            String current_group = null;
            Class<?> clazz2 = clazz = is_class ? (Class<?>)obj : obj.getClass();
            if (this.main_class == Void.TYPE) {
                this.main_class = clazz;
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                boolean unpublicized;
                try {
                    Object obj_nonraw = obj;
                    this.debug_options.log("Considering field %s of object %s%n", f, obj_nonraw);
                }
                catch (Throwable t) {
                    this.debug_options.log("Considering field %s of object of type %s%n", f, obj.getClass());
                }
                try {
                    this.debug_options.log("  with annotations %s%n", Arrays.toString(f.getDeclaredAnnotations()));
                }
                catch (ArrayStoreException e) {
                    if (e.getMessage() != null && Objects.equals(e.getMessage(), "sun.reflect.annotation.TypeNotPresentExceptionProxy")) {
                        this.debug_options.log("  with TypeNotPresentExceptionProxy while getting annotations%n", new Object[0]);
                    }
                    throw e;
                }
                Option option = Options.safeGetAnnotation(f, Option.class);
                if (option == null) continue;
                boolean bl = unpublicized = Options.safeGetAnnotation(f, Unpublicized.class) != null;
                if (is_class && !Modifier.isStatic(f.getModifiers())) {
                    throw new Error("non-static option " + f + " in class " + obj);
                }
                OptionInfo oi = new OptionInfo(f, option, is_class ? null : obj, unpublicized);
                this.options.add(oi);
                if (oi.list != null && !oi.unpublicized) {
                    this.print_list_help = true;
                }
                OptionGroup optionGroup = Options.safeGetAnnotation(f, OptionGroup.class);
                if (!seen_first_opt) {
                    seen_first_opt = true;
                    if (optionGroup == null) continue;
                    this.use_groups = true;
                }
                if (!this.use_groups) {
                    if (optionGroup == null) continue;
                    throw new Error("missing @OptionGroup annotation on the first @Option-annotated field of class " + this.main_class);
                }
                if (current_group == null && optionGroup == null) {
                    throw new Error("missing @OptionGroup annotation in field " + f + " of class " + obj);
                }
                if (optionGroup != null) {
                    String name = optionGroup.value();
                    if (this.group_map.containsKey(name)) {
                        throw new Error("option group " + name + " declared twice");
                    }
                    OptionGroupInfo gi = new OptionGroupInfo(optionGroup);
                    this.group_map.put(name, gi);
                    current_group = name;
                }
                OptionGroupInfo ogi = this.group_map.get(current_group);
                ogi.optionList.add(oi);
            }
        }
        String prefix = this.use_single_dash ? "-" : "--";
        for (OptionInfo oi : this.options) {
            if (oi.short_name != null) {
                if (this.name_map.containsKey("-" + oi.short_name)) {
                    throw new Error("short name " + oi + " appears twice");
                }
                this.name_map.put("-" + oi.short_name, oi);
            }
            if (this.name_map.containsKey(prefix + oi.long_name)) {
                throw new Error("long name " + oi + " appears twice");
            }
            this.name_map.put(prefix + oi.long_name, oi);
            if (oi.long_name.contains("-")) {
                this.name_map.put(prefix + oi.long_name.replace('-', '_'), oi);
            }
            if (oi.aliases.length <= 0) continue;
            for (String alias : oi.aliases) {
                if (this.name_map.containsKey(alias)) {
                    throw new Error("alias " + oi + " appears twice");
                }
                this.name_map.put(alias, oi);
            }
        }
    }

    private static <T extends Annotation> T safeGetAnnotation(Field f, Class<T> annotationClass) {
        T annotation;
        try {
            T cast;
            annotation = cast = f.getAnnotation(annotationClass);
        }
        catch (Exception e) {
            System.out.printf("Exception in call to f.getAnnotation(%s)%n  for f=%s%n  %s%nClasspath =%n", annotationClass, f, e.getMessage());
            JWhich.printClasspath();
            annotation = null;
        }
        return annotation;
    }

    public void parse_options_after_arg(boolean val) {
        this.parse_options_after_arg = val;
    }

    public void use_single_dash(boolean val) {
        this.use_single_dash = val;
    }

    public String[] parse(String[] args) throws ArgException {
        ArrayList<String> non_options = new ArrayList<String>();
        boolean ignore_options = false;
        String tail = "";
        int ii = 0;
        while (ii < args.length) {
            String arg;
            if (tail.length() > 0) {
                arg = tail;
                tail = "";
            } else {
                arg = args[ii];
            }
            if (arg.equals("--")) {
                ignore_options = true;
            } else if ((arg.startsWith("--") || arg.startsWith("-")) && !ignore_options) {
                String arg_value;
                String arg_name;
                int eq_pos;
                int split_pos = arg.indexOf(",-");
                if (split_pos == 0) {
                    arg = arg.substring(1);
                    split_pos = arg.indexOf(",-");
                }
                if (split_pos > 0) {
                    tail = arg.substring(split_pos + 1);
                    arg = arg.substring(0, split_pos);
                }
                if ((eq_pos = arg.indexOf(61)) == -1) {
                    arg_name = arg;
                    arg_value = null;
                } else {
                    arg_name = arg.substring(0, eq_pos);
                    arg_value = arg.substring(eq_pos + 1);
                }
                OptionInfo oi = this.name_map.get(arg_name);
                if (oi == null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(String.format("unknown option name '%s' in arg '%s'", arg_name, arg));
                    throw new ArgException(msg.toString());
                }
                if (oi.argument_required() && arg_value == null) {
                    if (++ii >= args.length) {
                        throw new ArgException("option %s requires an argument", arg);
                    }
                    arg_value = args[ii];
                }
                this.set_arg(oi, arg_name, arg_value);
            } else {
                if (!this.parse_options_after_arg) {
                    ignore_options = true;
                }
                non_options.add(arg);
            }
            if (tail.length() != 0) continue;
            ++ii;
        }
        String[] result = non_options.toArray(new String[non_options.size()]);
        return result;
    }

    public String[] parse(String args) throws ArgException {
        args = args.trim();
        ArrayList<String> arg_list = new ArrayList<String>();
        String arg = "";
        boolean active_quote = false;
        for (int ii = 0; ii < args.length(); ++ii) {
            char ch = args.charAt(ii);
            if (ch == '\'' || ch == '\"') {
                arg = arg + ch;
                ++ii;
                while (ii < args.length() && args.charAt(ii) != ch) {
                    arg = arg + args.charAt(ii++);
                }
                arg = arg + ch;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                arg_list.add(arg);
                arg = "";
                while (ii < args.length() && Character.isWhitespace(args.charAt(ii))) {
                    ++ii;
                }
                if (ii >= args.length()) continue;
                --ii;
                continue;
            }
            arg = arg + ch;
        }
        if (!arg.equals("")) {
            arg_list.add(arg);
        }
        String[] argsArray = arg_list.toArray(new String[arg_list.size()]);
        return this.parse(argsArray);
    }

    public String[] parse_or_usage(String[] args) {
        String[] non_options = null;
        try {
            non_options = this.parse(args);
        }
        catch (ArgException ae) {
            String message = ae.getMessage();
            if (message != null) {
                this.print_usage(message);
            } else {
                this.print_usage();
            }
            System.exit(-1);
        }
        return non_options;
    }

    public String[] parse_or_usage(String args) {
        String[] non_options = null;
        try {
            non_options = this.parse(args);
        }
        catch (ArgException ae) {
            String message = ae.getMessage();
            if (message != null) {
                this.print_usage(message);
            } else {
                this.print_usage();
            }
            System.exit(-1);
        }
        return non_options;
    }

    public void print_usage(PrintStream ps) {
        if (this.usage_synopsis != null) {
            ps.printf("Usage: %s%n", this.usage_synopsis);
        }
        ps.println(this.usage(new String[0]));
        if (this.print_list_help) {
            ps.println();
            ps.println(LIST_HELP);
        }
    }

    public void print_usage() {
        this.print_usage(System.out);
    }

    public void print_usage(PrintStream ps, String msg) {
        ps.println(msg);
        this.print_usage(ps);
    }

    public void print_usage(String msg) {
        this.print_usage(System.out, msg);
    }

    public void print_usage(PrintStream ps, String format, Object ... args) {
        ps.printf(format, args);
        if (!format.endsWith("%n")) {
            ps.println();
        }
        this.print_usage(ps);
    }

    public void print_usage(String format, Object ... args) {
        this.print_usage(System.out, format, args);
    }

    public String usage(String ... group_names) {
        return this.usage(false, group_names);
    }

    public String usage(boolean include_unpublicized, String ... group_names) {
        if (!this.use_groups) {
            if (group_names.length > 0) {
                throw new IllegalArgumentException("This instance of Options does not have any option groups defined");
            }
            return this.format_options(this.options, this.max_opt_len(this.options, include_unpublicized), include_unpublicized);
        }
        ArrayList<OptionGroupInfo> groups = new ArrayList<OptionGroupInfo>();
        if (group_names.length > 0) {
            for (String group_name : group_names) {
                if (!this.group_map.containsKey(group_name)) {
                    throw new IllegalArgumentException("invalid option group: " + (String)group_name);
                }
                OptionGroupInfo gi = this.group_map.get(group_name);
                if (!include_unpublicized && !gi.any_publicized()) {
                    throw new IllegalArgumentException("group does not contain any publicized options: " + (String)group_name);
                }
                groups.add(this.group_map.get(group_name));
            }
        } else {
            for (OptionGroupInfo gi : this.group_map.values()) {
                if ((gi.unpublicized || !gi.any_publicized()) && !include_unpublicized) continue;
                groups.add(gi);
            }
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (OptionGroupInfo gi : groups) {
            lengths.add(this.max_opt_len(gi.optionList, include_unpublicized));
        }
        int max_len = (Integer)Collections.max(lengths);
        StringBuilderDelimited buf = new StringBuilderDelimited(eol);
        for (OptionGroupInfo gi : groups) {
            buf.append(String.format("%n%s:", gi.name));
            buf.append(this.format_options(gi.optionList, max_len, include_unpublicized));
        }
        return buf.toString();
    }

    private String format_options(List<OptionInfo> opt_list, int max_len, boolean include_unpublicized) {
        StringBuilderDelimited buf = new StringBuilderDelimited(eol);
        for (OptionInfo oi : opt_list) {
            if (oi.unpublicized && !include_unpublicized) continue;
            String default_str = "";
            if (oi.default_str != null) {
                default_str = String.format(" [default %s]", oi.default_str);
            }
            String use = String.format("  %-" + max_len + "s - %s%s", oi.synopsis(), oi.description, default_str);
            buf.append(use);
        }
        return buf.toString();
    }

    private int max_opt_len(List<OptionInfo> opt_list, boolean include_unpublicized) {
        int max_len = 0;
        for (OptionInfo oi : opt_list) {
            int len;
            if (oi.unpublicized && !include_unpublicized || (len = oi.synopsis().length()) <= max_len) continue;
            max_len = len;
        }
        return max_len;
    }

    boolean isUsingGroups() {
        return this.use_groups;
    }

    boolean isUsingSingleDash() {
        return this.use_single_dash;
    }

    List<OptionInfo> getOptions() {
        return this.options;
    }

    Collection<OptionGroupInfo> getOptionGroups() {
        return this.group_map.values();
    }

    private void set_arg(OptionInfo oi, String arg_name, String arg_value) throws ArgException {
        block37: {
            Field f = oi.field;
            Class<?> type = oi.base_type;
            if (this.options_str.length() > 0) {
                this.options_str = this.options_str + " ";
            }
            this.options_str = this.options_str + arg_name;
            if (arg_value != null) {
                if (!arg_value.contains(" ")) {
                    this.options_str = this.options_str + "=" + arg_value;
                } else if (!arg_value.contains("'")) {
                    this.options_str = this.options_str + "='" + arg_value + "'";
                } else if (!arg_value.contains("\"")) {
                    this.options_str = this.options_str + "=\"" + arg_value + "\"";
                } else {
                    throw new ArgException("Can't quote for internal debugging: " + arg_value);
                }
            }
            if (arg_value == null) {
                if (type != Boolean.TYPE || type != Boolean.class) {
                    arg_value = "true";
                } else {
                    throw new ArgException("Value required for option " + arg_name);
                }
            }
            try {
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        boolean val;
                        String arg_value_lowercase = arg_value.toLowerCase();
                        if (arg_value_lowercase.equals("true") || arg_value_lowercase.equals("t")) {
                            val = true;
                        } else if (arg_value_lowercase.equals("false") || arg_value_lowercase.equals("f")) {
                            val = false;
                        } else {
                            throw new ArgException("Value \"%s\" for argument %s is not a boolean", arg_value, arg_name);
                        }
                        arg_value = val ? "true" : "false";
                        f.setBoolean(oi.obj, val);
                        break block37;
                    }
                    if (type == Integer.TYPE) {
                        int val;
                        try {
                            val = Integer.decode(arg_value);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not an integer", arg_value, arg_name);
                        }
                        f.setInt(oi.obj, val);
                        break block37;
                    }
                    if (type == Long.TYPE) {
                        long val;
                        try {
                            val = Long.decode(arg_value);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a long integer", arg_value, arg_name);
                        }
                        f.setLong(oi.obj, val);
                        break block37;
                    }
                    if (type == Float.TYPE) {
                        Float val;
                        try {
                            val = Float.valueOf(arg_value);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a float", arg_value, arg_name);
                        }
                        f.setFloat(oi.obj, val.floatValue());
                        break block37;
                    }
                    if (type == Double.TYPE) {
                        Double val;
                        try {
                            val = Double.valueOf(arg_value);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a double", arg_value, arg_name);
                        }
                        f.setDouble(oi.obj, val);
                        break block37;
                    }
                    throw new Error("Unexpected type " + type);
                }
                if (oi.list != null) {
                    if (split_lists) {
                        String[] aarr;
                        for (String aval : aarr = arg_value.split("  *")) {
                            Object val = this.get_ref_arg(oi, arg_name, aval);
                            oi.list.add(val);
                        }
                    } else {
                        Object val = this.get_ref_arg(oi, arg_name, arg_value);
                        oi.list.add(val);
                    }
                } else {
                    Object val = this.get_ref_arg(oi, arg_name, arg_value);
                    f.set(oi.obj, val);
                }
            }
            catch (ArgException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new Error("Unexpected error ", e);
            }
        }
    }

    private Object get_ref_arg(OptionInfo oi, String arg_name, String arg_value) throws ArgException {
        Object val = null;
        try {
            if (oi.constructor != null) {
                val = oi.constructor.newInstance(arg_value);
            } else if (oi.base_type.isEnum()) {
                Object tmpVal = this.getEnumValue(oi.base_type, arg_value);
                val = tmpVal;
            } else {
                Object tmpVal;
                if (oi.factory == null) {
                    throw new Error("No constructor or factory for argument " + arg_name);
                }
                val = tmpVal = oi.factory.invoke(null, arg_value);
            }
        }
        catch (Exception e) {
            throw new ArgException("Invalid argument (%s) for argument %s", arg_value, arg_name);
        }
        assert (val != null) : "@AssumeAssertion(nullness)";
        return val;
    }

    private <T extends Enum<T>> T getEnumValue(Class<T> enumType, String name) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException(enumType.getName() + " is not an enum type");
        }
        for (Enum constant : constants) {
            if (!constant.name().equalsIgnoreCase(name.replace('-', '_'))) continue;
            return (T)constant;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + "." + name);
    }

    private static String type_short_name(Class<?> type) {
        if (type.isPrimitive()) {
            return type.getName();
        }
        if (type == File.class) {
            return "filename";
        }
        if (type == Pattern.class) {
            return "regex";
        }
        if (type.isEnum()) {
            return "enum";
        }
        return type.getSimpleName().toLowerCase();
    }

    public String get_options_str() {
        return this.options_str;
    }

    public String settings() {
        return this.settings(false);
    }

    public String settings(boolean include_unpublicized) {
        StringBuilderDelimited out = new StringBuilderDelimited(eol);
        int max_len = this.max_opt_len(this.options, include_unpublicized);
        for (OptionInfo oi : this.options) {
            String use = String.format("%-" + max_len + "s = ", oi.long_name);
            try {
                use = use + oi.field.get(oi.obj);
            }
            catch (Exception e) {
                throw new Error("unexpected exception reading field " + oi.field, e);
            }
            out.append(use);
        }
        return out.toString();
    }

    public String toString() {
        StringBuilderDelimited out = new StringBuilderDelimited(eol);
        for (OptionInfo oi : this.options) {
            out.append(oi);
        }
        return out.toString();
    }

    private static ParseResult parse_option(String val) {
        String type_name;
        String description;
        String short_name;
        if (val.startsWith("-")) {
            if (val.length() < 4 || !val.substring(2, 3).equals(" ")) {
                throw new Error("Malformed @Option argument \"" + val + "\".  An argument that starts with '-' should contain a short name, a space, and a description.");
            }
            short_name = val.substring(1, 2);
            description = val.substring(3);
        } else {
            short_name = null;
            description = val;
        }
        if (description.startsWith("<")) {
            type_name = description.substring(1).replaceFirst(">.*", "");
            description = description.replaceFirst("<.*> ", "");
        } else {
            type_name = null;
        }
        return new ParseResult(short_name, type_name, description);
    }

    private static class ParseResult {
        String short_name;
        String type_name;
        String description;

        ParseResult(String short_name, String type_name, String description) {
            this.short_name = short_name;
            this.type_name = type_name;
            this.description = description;
        }
    }

    public static class ArgException
    extends Exception {
        static final long serialVersionUID = 20051223L;

        public ArgException(String s2) {
            super(s2);
        }

        public ArgException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }

    static class OptionGroupInfo {
        String name;
        boolean unpublicized;
        List<OptionInfo> optionList = new ArrayList<OptionInfo>();

        OptionGroupInfo(String name, boolean unpublicized) {
            this.name = name;
            this.unpublicized = unpublicized;
        }

        OptionGroupInfo(OptionGroup optionGroup) {
            this.name = optionGroup.value();
            this.unpublicized = optionGroup.unpublicized();
        }

        boolean any_publicized() {
            for (OptionInfo oi : this.optionList) {
                if (oi.unpublicized) continue;
                return true;
            }
            return false;
        }
    }

    class OptionInfo {
        Field field;
        Object obj;
        String short_name;
        String long_name;
        String[] aliases;
        String description;
        String jdoc;
        Map<String, String> enum_jdoc;
        String type_name;
        Class<?> base_type;
        String default_str = null;
        boolean no_doc_default = false;
        List<Object> list = null;
        Constructor<?> constructor = null;
        Method factory = null;
        boolean unpublicized;

        OptionInfo(Field field, Option option, Object obj, boolean unpublicized) {
            ParseResult pr;
            this.field = field;
            this.obj = obj;
            this.base_type = field.getType();
            this.unpublicized = unpublicized;
            this.aliases = option.aliases();
            this.no_doc_default = option.noDocDefault();
            this.long_name = field.getName();
            this.long_name = this.long_name.replace('_', '-');
            ArrayList default_obj = null;
            if (!Modifier.isPublic(field.getModifiers())) {
                throw new Error("option field is not public: " + field);
            }
            try {
                default_obj = field.get(obj);
                if (default_obj != null) {
                    this.default_str = ((Object)default_obj).toString();
                }
            }
            catch (Exception e) {
                throw new Error("Unexpected error getting default for " + field, e);
            }
            if (field.getType().isArray()) {
                throw new Error("@Option may not annotate a variable of array type: " + field);
            }
            Type gen_type = field.getGenericType();
            if (gen_type instanceof ParameterizedType) {
                List default_obj_as_list;
                ParameterizedType pt = (ParameterizedType)gen_type;
                Type raw_type = pt.getRawType();
                if (!raw_type.equals(List.class)) {
                    throw new Error("@Option supports List<...> but no other parameterized type; it does not support type " + pt + " for field " + field);
                }
                if (default_obj == null) {
                    ArrayList new_list = new ArrayList();
                    try {
                        field.set(obj, new_list);
                    }
                    catch (Exception e) {
                        throw new Error("Unexpected error setting default for " + field, e);
                    }
                    default_obj = new_list;
                }
                if (((List)default_obj).isEmpty()) {
                    this.default_str = null;
                }
                this.list = default_obj_as_list = (List)default_obj;
                this.base_type = (Class)pt.getActualTypeArguments()[0];
            }
            try {
                pr = Options.parse_option(option.value());
            }
            catch (Throwable e) {
                throw new Error("Error while processing @Option(\"" + option.value() + "\") on '" + field + "'", e);
            }
            this.short_name = pr.short_name;
            this.type_name = pr.type_name != null ? pr.type_name : Options.type_short_name(this.base_type);
            this.description = pr.description;
            if (!this.base_type.isPrimitive() && !this.base_type.isEnum()) {
                try {
                    if (this.base_type == Pattern.class) {
                        this.factory = Pattern.class.getMethod("compile", String.class);
                    } else {
                        this.constructor = this.base_type.getConstructor(String.class);
                    }
                }
                catch (Exception e) {
                    throw new Error("@Option does not support type " + this.base_type + " for field " + field + " because it does not have a string constructor", e);
                }
            }
        }

        public boolean argument_required() {
            Class<?> type = this.field.getType();
            return type != Boolean.TYPE && type != Boolean.class;
        }

        public String synopsis() {
            String prefix = Options.this.use_single_dash ? "-" : "--";
            String name = prefix + this.long_name;
            if (this.short_name != null) {
                name = String.format("-%s %s", this.short_name, name);
            }
            name = name + String.format("=<%s>", this.type_name);
            if (this.list != null) {
                name = name + " [+]";
            }
            return name;
        }

        public String toString() {
            String prefix = Options.this.use_single_dash ? "-" : "--";
            String short_name_str = "";
            if (this.short_name != null) {
                short_name_str = "-" + this.short_name + " ";
            }
            return String.format("%s%s%s field %s", short_name_str, prefix, this.long_name, this.field);
        }

        public Class<?> get_declaring_class() {
            return this.field.getDeclaringClass();
        }
    }
}

