/*
 * Decompiled with CFR 0.152.
 */
package annotations;

import annotations.Annotation;
import annotations.AnnotationBuilder;
import annotations.AnnotationFactory;
import annotations.ArrayBuilder;
import annotations.el.AnnotationDef;
import annotations.field.AnnotationAFT;
import annotations.field.AnnotationFieldType;
import annotations.field.ArrayAFT;
import annotations.field.EnumAFT;
import annotations.field.ScalarAFT;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Annotations {
    public static Set<Annotation> noAnnotations = Collections.emptySet();
    public static Map<String, ? extends AnnotationFieldType> noFieldTypes = Collections.emptyMap();
    public static Map<String, ? extends Object> noFieldValues = Collections.emptyMap();
    public static Set<Annotation> typeQualifierMetaAnnotations;
    public static EnumAFT aftRetentionPolicy;
    public static AnnotationDef adRetention;
    public static Annotation aRetentionClass;
    public static Annotation aRetentionRuntime;
    public static Annotation aRetentionSource;
    public static Set<Annotation> asRetentionClass;
    public static Set<Annotation> asRetentionRuntime;
    public static Set<Annotation> asRetentionSource;
    public static AnnotationDef adTarget;
    public static Annotation aTargetTypeUse;
    public static AnnotationDef adNonNull;
    public static Annotation aNonNull;
    public static AnnotationDef adTypeQualifier;
    public static Annotation aTypeQualifier;
    public static Set<AnnotationDef> standardDefs;

    private Annotations() {
    }

    static Map<String, ? extends AnnotationFieldType> valueFieldTypeOnly(AnnotationFieldType aft) {
        return Collections.singletonMap("value", aft);
    }

    public static Map<String, ? extends Object> valueFieldOnly(Object valueValue) {
        return Collections.singletonMap("value", valueValue);
    }

    public static AnnotationDef createValueAnnotationDef(String name, Set<Annotation> metaAnnotations, AnnotationFieldType aft) {
        return new AnnotationDef(name, metaAnnotations, Annotations.valueFieldTypeOnly(aft));
    }

    public static Annotation createValueAnnotation(AnnotationDef ad, Object value) {
        return new Annotation(ad, Annotations.valueFieldOnly(value));
    }

    public static Annotation getRetentionPolicyMetaAnnotation(RetentionPolicy rp) {
        switch (rp) {
            case CLASS: {
                return aRetentionClass;
            }
            case RUNTIME: {
                return aRetentionRuntime;
            }
            case SOURCE: {
                return aRetentionSource;
            }
        }
        throw new Error("This can't happen");
    }

    public static Set<Annotation> getRetentionPolicyMetaAnnotationSet(RetentionPolicy rp) {
        switch (rp) {
            case CLASS: {
                return asRetentionClass;
            }
            case RUNTIME: {
                return asRetentionRuntime;
            }
            case SOURCE: {
                return asRetentionSource;
            }
        }
        throw new Error("This can't happen");
    }

    private static Object convertAFV(ScalarAFT aft, Object x) {
        if (aft instanceof AnnotationAFT) {
            return Annotations.rebuild((Annotation)x);
        }
        return x;
    }

    public static final Annotation rebuild(Annotation a) {
        AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(a.def());
        if (ab != null) {
            for (Map.Entry<String, AnnotationFieldType> fieldDef : a.def().fieldTypes.entrySet()) {
                String fieldName = fieldDef.getKey();
                AnnotationFieldType fieldType = fieldDef.getValue();
                Object fieldValue = a.getFieldValue(fieldName);
                if (fieldValue == null) {
                    throw new IllegalArgumentException("annotation has no field value");
                }
                Object nnFieldValue = fieldValue;
                if (fieldType instanceof ArrayAFT) {
                    ArrayAFT aFieldType = (ArrayAFT)fieldType;
                    ArrayBuilder arrb = ab.beginArrayField(fieldName, aFieldType);
                    List l = (List)fieldValue;
                    if (aFieldType.elementType == null) {
                        throw new IllegalArgumentException("annotation field type is missing element type");
                    }
                    ScalarAFT nnElementType = aFieldType.elementType;
                    for (Object o : l) {
                        arrb.appendElement(Annotations.convertAFV(nnElementType, o));
                    }
                    arrb.finish();
                    continue;
                }
                ScalarAFT sFieldType = (ScalarAFT)fieldType;
                ab.addScalarField(fieldName, sFieldType, Annotations.convertAFV(sFieldType, fieldValue));
            }
            return ab.finish();
        }
        return null;
    }

    static {
        aftRetentionPolicy = new EnumAFT("java.lang.annotation.RetentionPolicy");
        adRetention = new AnnotationDef("java.lang.annotation.Retention");
        adRetention.setFieldTypes(Annotations.valueFieldTypeOnly(aftRetentionPolicy));
        aRetentionRuntime = Annotations.createValueAnnotation(adRetention, "RUNTIME");
        Annotations.adRetention.tlAnnotationsHere.add(aRetentionRuntime);
        aRetentionClass = Annotations.createValueAnnotation(adRetention, "CLASS");
        aRetentionSource = Annotations.createValueAnnotation(adRetention, "SOURCE");
        asRetentionClass = Collections.singleton(aRetentionClass);
        asRetentionRuntime = Collections.singleton(aRetentionRuntime);
        asRetentionSource = Collections.singleton(aRetentionSource);
        adTarget = Annotations.createValueAnnotationDef("java.lang.annotation.Target", asRetentionRuntime, new ArrayAFT(new EnumAFT("java.lang.annotation.ElementType")));
        aTargetTypeUse = Annotations.createValueAnnotation(adTarget, Collections.singletonList("TYPE_USE"));
        typeQualifierMetaAnnotations = new HashSet<Annotation>();
        typeQualifierMetaAnnotations.add(aRetentionRuntime);
        typeQualifierMetaAnnotations.add(aTargetTypeUse);
        adNonNull = new AnnotationDef("org.checkerframework.checker.nullness.qual.NonNull", typeQualifierMetaAnnotations, noFieldTypes);
        aNonNull = new Annotation(adNonNull, noFieldValues);
        adTypeQualifier = new AnnotationDef("org.checkerframework.framework.qual.TypeQualifier", asRetentionRuntime, noFieldTypes);
        aTypeQualifier = new Annotation(adTypeQualifier, noFieldValues);
        standardDefs = new LinkedHashSet<AnnotationDef>();
        standardDefs.add(adTarget);
        standardDefs.add(adRetention);
    }
}

