/*
 * Decompiled with CFR 0.152.
 */
package annotations.field;

import annotations.el.AnnotationDef;
import annotations.field.AFTVisitor;
import annotations.field.AnnotationAFT;
import annotations.field.ArrayAFT;
import annotations.field.BasicAFT;
import annotations.field.ClassTokenAFT;
import annotations.field.EnumAFT;
import annotations.field.ScalarAFT;
import annotations.util.EqualByStringRepresentation;
import java.util.Map;

public abstract class AnnotationFieldType
extends EqualByStringRepresentation {
    @Override
    public abstract String toString();

    public abstract String format(Object var1);

    public abstract boolean isValidValue(Object var1);

    public static AnnotationFieldType fromClass(Class<?> c, Map<String, AnnotationDef> adefs) {
        if (c.isAnnotation()) {
            Class<?> cAnno = c;
            return new AnnotationAFT(AnnotationDef.fromClass(cAnno, adefs));
        }
        if (c.isArray()) {
            return new ArrayAFT((ScalarAFT)AnnotationFieldType.fromClass(c.getComponentType(), adefs));
        }
        if (BasicAFT.bafts.containsKey(c)) {
            return BasicAFT.bafts.get(c);
        }
        if (c == Class.class) {
            return ClassTokenAFT.ctaft;
        }
        if (c.isEnum()) {
            return new EnumAFT(c.getName());
        }
        throw new Error("Unrecognized class: " + c);
    }

    public static final AnnotationFieldType unify(AnnotationFieldType aft1, AnnotationFieldType aft2) {
        if (aft1.equals(aft2)) {
            return aft1;
        }
        if (aft1 instanceof ArrayAFT && aft2 instanceof ArrayAFT) {
            if (((ArrayAFT)aft1).elementType == null) {
                return aft2;
            }
            if (((ArrayAFT)aft2).elementType == null) {
                return aft1;
            }
            return null;
        }
        if (aft1 instanceof AnnotationAFT && aft2 instanceof AnnotationAFT) {
            AnnotationDef ud = AnnotationDef.unify(((AnnotationAFT)aft1).annotationDef, ((AnnotationAFT)aft2).annotationDef);
            if (ud == null) {
                return null;
            }
            return new AnnotationAFT(ud);
        }
        return null;
    }

    public abstract <R, T> R accept(AFTVisitor<R, T> var1, T var2);
}

