/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.experimental.regex_qual;

import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualStore;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;

public class RegexQualifiedTransfer
extends QualTransfer<Regex> {
    private static final String IS_REGEX_METHOD_NAME = "isRegex";
    private static final String AS_REGEX_METHOD_NAME = "asRegex";

    public RegexQualifiedTransfer(QualAnalysis<Regex> analysis) {
        super(analysis);
    }

    @Override
    public TransferResult<QualValue<Regex>, QualStore<Regex>> visitMethodInvocation(MethodInvocationNode n, TransferInput<QualValue<Regex>, QualStore<Regex>> in) {
        TransferResult<QualValue<Regex>, QualStore<Regex>> result = super.visitMethodInvocation(n, in);
        MethodAccessNode target = n.getTarget();
        ExecutableElement method = target.getMethod();
        Node receiver = target.getReceiver();
        if (!(receiver instanceof ClassNameNode)) {
            return result;
        }
        ClassNameNode cn = (ClassNameNode)receiver;
        String receiverName = cn.getElement().toString();
        if (this.isRegexUtil(receiverName)) {
            if (ElementUtils.matchesElement(method, IS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
                QualStore<Regex> thenStore = result.getRegularStore();
                Store elseStore = thenStore.copy();
                ConditionalTransferResult<QualValue<Regex>, Store> newResult = new ConditionalTransferResult<QualValue<Regex>, Store>(result.getResultValue(), thenStore, elseStore);
                FlowExpressions.Receiver firstParam = FlowExpressions.internalReprOf(this.analysis.getContext().getAnnotationProvider(), n.getArgument(0));
                Node count = n.getArgument(1);
                if (count instanceof IntegerLiteralNode) {
                    IntegerLiteralNode iln = (IntegerLiteralNode)count;
                    Integer groupCount = iln.getValue();
                    Regex.RegexVal regex = new Regex.RegexVal(groupCount);
                    thenStore.insertValue(firstParam, regex);
                } else {
                    thenStore.insertValue(firstParam, new Regex.RegexVal(0));
                }
                return newResult;
            }
            if (ElementUtils.matchesElement(method, AS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
                Regex.RegexVal regex;
                Node count = n.getArgument(1);
                if (count instanceof IntegerLiteralNode) {
                    IntegerLiteralNode iln = (IntegerLiteralNode)count;
                    Integer groupCount = iln.getValue();
                    regex = new Regex.RegexVal(groupCount);
                } else {
                    regex = new Regex.RegexVal(0);
                }
                QualValue<Regex.RegexVal> newResultValue = this.analysis.createSingleAnnotationValue(regex, result.getResultValue().getType().getUnderlyingType().getOriginalType());
                return new RegularTransferResult<QualValue<Regex>, QualStore<Regex>>(newResultValue, result.getRegularStore());
            }
        }
        return result;
    }

    private boolean isRegexUtil(String receiver) {
        return receiver.equals("RegexUtil") || receiver.endsWith(".RegexUtil");
    }
}

