/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.nullness.KeyForAnalysis;
import org.checkerframework.checker.nullness.KeyForPropagationTreeAnnotator;
import org.checkerframework.checker.nullness.KeyForPropagator;
import org.checkerframework.checker.nullness.KeyForTransfer;
import org.checkerframework.checker.nullness.compatqual.KeyForDecl;
import org.checkerframework.checker.nullness.compatqual.KeyForType;
import org.checkerframework.checker.nullness.qual.Covariant;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.PolyKeyFor;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeReplacer;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.type.visitor.VisitHistory;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.typeinference.DefaultTypeArgumentInference;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.framework.util.typeinference.TypeArgumentInference;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class KeyForAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<CFValue, CFStore, KeyForTransfer, KeyForAnalysis> {
    protected final AnnotationMirror UNKNOWNKEYFOR;
    protected final AnnotationMirror KEYFOR;
    private final KeyForPropagator keyForPropagator;
    private final KeyForCanonicalizer keyForCanonicalizer = new KeyForCanonicalizer();
    protected final Class<? extends Annotation> checkerKeyForClass = KeyFor.class;
    protected final String identifierRegex = "[a-zA-Z_$][a-zA-Z_$0-9]*";
    protected final Pattern identifierPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private static final Pattern parameterPtn = Pattern.compile("#(\\d+)");

    public KeyForAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, true);
        this.KEYFOR = AnnotationUtils.fromClass(this.elements, KeyFor.class);
        this.UNKNOWNKEYFOR = AnnotationUtils.fromClass(this.elements, UnknownKeyFor.class);
        this.keyForPropagator = new KeyForPropagator(this.UNKNOWNKEYFOR);
        this.addAliasedAnnotation(KeyForDecl.class, this.KEYFOR);
        this.addAliasedAnnotation(KeyForType.class, this.KEYFOR);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(KeyFor.class, UnknownKeyFor.class, KeyForBottom.class, PolyKeyFor.class, PolyAll.class)));
    }

    @Override
    protected TypeArgumentInference createTypeArgumentInference() {
        return new KeyForTypeArgumentInference();
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        AnnotatedTypeMirror assignedTo;
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> result = super.constructorFromUse(tree);
        AnnotatedTypeMirror returnType = ((AnnotatedTypeMirror.AnnotatedExecutableType)result.first).getReturnType();
        Pair<Tree, AnnotatedTypeMirror> context = this.getVisitorState().getAssignmentContext();
        if (returnType.getKind() == TypeKind.DECLARED && context != null && context.first != null && (assignedTo = TypeArgInferenceUtil.assignedTo(this, this.getPath(tree))) != null && assignedTo.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType newClassType = (AnnotatedTypeMirror.AnnotatedDeclaredType)returnType;
            this.keyForPropagator.propagate(newClassType, (AnnotatedTypeMirror.AnnotatedDeclaredType)assignedTo, KeyForPropagator.PropagationDirection.TO_SUBTYPE, this);
        }
        return result;
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree call) {
        assert (call != null);
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(call);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        ExecutableElement methElem = method.getElement();
        AnnotatedTypeMirror.AnnotatedExecutableType declMethod = this.getAnnotatedType(methElem);
        HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
        List<AnnotatedTypeMirror> params = method.getParameterTypes();
        List<AnnotatedTypeMirror> declParams = declMethod.getParameterTypes();
        assert (params.size() == declParams.size());
        for (int i = 0; i < params.size(); ++i) {
            AnnotatedTypeMirror param = params.get(i);
            AnnotatedTypeMirror subst = this.substituteCall(call, declParams.get(i), param);
            mappings.put(param, subst);
        }
        AnnotatedTypeMirror returnType = method.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            AnnotatedTypeMirror subst = this.substituteCall(call, declMethod.getReturnType(), returnType);
            mappings.put(returnType, subst);
        }
        method = (AnnotatedTypeMirror.AnnotatedExecutableType)AnnotatedTypeReplacer.replace(method, mappings);
        return Pair.of(method, mfuPair.second);
    }

    private String receiver(MethodInvocationTree node) {
        ExpressionTree sel = node.getMethodSelect();
        if (sel.getKind() == Tree.Kind.IDENTIFIER) {
            return "";
        }
        if (sel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)sel).getExpression().toString();
        }
        ErrorReporter.errorAbort("KeyForAnnotatedTypeFactory.receiver: cannot be here");
        return null;
    }

    private AnnotatedTypeMirror substituteCall(MethodInvocationTree call, AnnotatedTypeMirror declInType, AnnotatedTypeMirror inType) {
        AnnotatedTypeMirror outType = inType.shallowCopy();
        AnnotationMirror anno = declInType.getAnnotation(KeyFor.class);
        if (anno != null) {
            List<String> inMaps = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            ArrayList<String> outMaps = new ArrayList<String>();
            String receiver = this.receiver(call);
            for (String inMapName : inMaps) {
                if (parameterPtn.matcher(inMapName).matches()) {
                    int param = Integer.valueOf(inMapName.substring(1));
                    if (param <= 0 || param > call.getArguments().size()) continue;
                    String res = call.getArguments().get(param - 1).toString();
                    outMaps.add(res);
                    continue;
                }
                if (inMapName.equals("this")) {
                    outMaps.add(receiver);
                    continue;
                }
                outMaps.add(inMapName);
            }
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, KeyFor.class);
            builder.setValue((CharSequence)"value", outMaps);
            AnnotationMirror newAnno = builder.build();
            outType.removeAnnotation(KeyFor.class);
            outType.addAnnotation(newAnno);
        }
        if (declInType.getKind() == TypeKind.DECLARED && outType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)outType;
            AnnotatedTypeMirror.AnnotatedDeclaredType declDeclaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)declInType;
            HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
            List<AnnotatedTypeMirror> typeArgs = declaredType.getTypeArguments();
            List<AnnotatedTypeMirror> declTypeArgs = declDeclaredType.getTypeArguments();
            assert (typeArgs.size() == declTypeArgs.size());
            for (int i = 0; i < typeArgs.size(); ++i) {
                AnnotatedTypeMirror typeArgument = typeArgs.get(i);
                AnnotatedTypeMirror substTypeArgument = this.substituteCall(call, declTypeArgs.get(i), typeArgument);
                mapping.put(typeArgument, substTypeArgument);
            }
            outType = AnnotatedTypeReplacer.replace(declaredType, mapping);
        } else if (declInType.getKind() == TypeKind.ARRAY & outType.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)outType;
            AnnotatedTypeMirror.AnnotatedArrayType declArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)declInType;
            AnnotatedTypeMirror elemType = arrayType.getComponentType();
            AnnotatedTypeMirror substElemType = this.substituteCall(call, declArrayType.getComponentType(), elemType);
            arrayType.setComponentType(substElemType);
        } else if (outType.getKind().isPrimitive() || outType.getKind() == TypeKind.WILDCARD || outType.getKind() == TypeKind.TYPEVAR) {
            // empty if block
        }
        return outType;
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new KeyForTypeHierarchy(this.checker, this.getQualifierHierarchy(), this.checker.getOption("ignoreRawTypeArguments", "true").equals("true"), this.checker.hasOption("invariantArrays"));
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this), new KeyForPropagationTreeAnnotator(this, this.keyForPropagator));
    }

    public AnnotationMirror createKeyForAnnotationMirrorWithValue(LinkedHashSet<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), KeyFor.class);
        builder.setValue((CharSequence)"value", values.toArray());
        return builder.build();
    }

    public AnnotationMirror createKeyForAnnotationMirrorWithValue(String value) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        values.add(value);
        return this.createKeyForAnnotationMirrorWithValue(values);
    }

    public boolean keyForValuesSubtypeCheck(AnnotationMirror varType, AnnotatedTypeMirror valueType, Tree t, MethodInvocationNode node) {
        List<String> val;
        TreePath path = this.getPath(t);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContextVarType = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodUse(node, this.getContext());
        LinkedHashSet<String> var = this.canonicalizeKeyForValues(varType, flowExprContextVarType, path, false, false);
        this.keyForCanonicalizeValue(valueType, path, t);
        AnnotationMirror keyForAnnotationMirrorValueType = valueType.getAnnotation(KeyFor.class);
        List<String> list = val = keyForAnnotationMirrorValueType == null ? null : AnnotationUtils.getElementValueArray(keyForAnnotationMirrorValueType, "value", String.class, false);
        if (var == null && val == null) {
            return true;
        }
        if (var == null || val == null) {
            return false;
        }
        return val.containsAll(var);
    }

    public void keyForCanonicalizeValues(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, TreePath path) {
        Tree t = path.getLeaf();
        Node node = this.getNodeForTree(t);
        if (node == null) {
            return;
        }
        this.keyForCanonicalizeValue(valueType, path, t);
        if (node instanceof MethodInvocationNode || node instanceof ObjectCreationNode) {
            this.keyForCanonicalizeValuesForMethodParams(varType, path, node);
        } else {
            this.keyForCanonicalizeValue(varType, path, t);
        }
    }

    private void keyForCanonicalizeValuesForMethodParams(AnnotatedTypeMirror varType, TreePath path, Node node) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContextVarType;
        if (!(node instanceof MethodInvocationNode) && !(node instanceof ObjectCreationNode)) {
            ErrorReporter.errorAbort("Unexpected node");
        }
        FlowExpressionParseUtil.FlowExpressionContext flowExpressionContext = flowExprContextVarType = node instanceof MethodInvocationNode ? FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodUse((MethodInvocationNode)node, this.getContext()) : FlowExpressionParseUtil.FlowExpressionContext.buildContextForNewClassUse((ObjectCreationNode)node, this.getContext());
        if (!this.keyForCanonicalizer.canonicalize(varType, flowExprContextVarType, path, false)) {
            this.keyForCanonicalizeValue(varType, path, node.getTree());
        }
    }

    private void keyForCanonicalizeValue(AnnotatedTypeMirror valueType, TreePath path, Tree t) {
        ArrayList<FlowExpressions.Receiver> methodParameters;
        ClassTree enclosingClass = TreeUtils.enclosingClass(path);
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(path);
        Node receiver = this.isTreeInStaticScope(t, enclosingMethod, path) ? new ClassNameNode(enclosingClass) : new ImplicitThisLiteralNode(InternalUtils.typeOf(enclosingClass));
        if (enclosingMethod != null) {
            methodParameters = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : enclosingMethod.getParameters()) {
                methodParameters.add(FlowExpressions.internalReprOf(this, new LocalVariableNode(variableTree, receiver)));
            }
        } else {
            methodParameters = null;
        }
        FlowExpressions.Receiver r = FlowExpressions.internalReprOf(this, receiver);
        FlowExpressionParseUtil.FlowExpressionContext flowExpressionContext = new FlowExpressionParseUtil.FlowExpressionContext(r, methodParameters, this.getContext());
        this.keyForCanonicalizer.canonicalize(valueType, flowExpressionContext, path, true);
    }

    private boolean isTreeInStaticScope(Tree t, MethodTree enclosingMethod, TreePath path) {
        if (enclosingMethod != null) {
            return enclosingMethod.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        }
        BlockTree block = TreeUtils.enclosingTopLevelBlock(path);
        if (block != null) {
            return block.isStatic();
        }
        if (t.getKind() != Tree.Kind.VARIABLE && (t = TreeUtils.enclosingVariable(path)) == null) {
            ErrorReporter.errorAbort("Unexpected tree.");
            return false;
        }
        return ((VariableTree)t).getModifiers().getFlags().contains((Object)Modifier.STATIC);
    }

    private LinkedHashSet<String> canonicalizeKeyForValues(AnnotationMirror anno, FlowExpressionParseUtil.FlowExpressionContext flowExprContext, TreePath path, boolean returnNullIfUnchanged, boolean use) {
        if (anno == null) {
            return null;
        }
        boolean unknownReceiver = flowExprContext.receiver == null || flowExprContext.receiver.containsUnknown();
        boolean valuesChanged = false;
        LinkedHashSet<String> newValues = new LinkedHashSet<String>();
        List<String> values = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
        for (String s2 : values) {
            FlowExpressions.Receiver varTypeReceiver = null;
            try {
                varTypeReceiver = FlowExpressionParseUtil.parse(s2, flowExprContext, path, use);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
                // empty catch block
            }
            if (unknownReceiver && (varTypeReceiver == null || varTypeReceiver.containsUnknown())) {
                try {
                    varTypeReceiver = FlowExpressionParseUtil.parse("this." + s2, flowExprContext, path, use);
                }
                catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
                    // empty catch block
                }
            }
            if (varTypeReceiver != null) {
                String newValue = varTypeReceiver.toString();
                newValues.add(newValue);
                if (newValue.equals(s2)) continue;
                valuesChanged = true;
                continue;
            }
            newValues.add(s2);
        }
        if (!returnNullIfUnchanged || valuesChanged) {
            return newValues;
        }
        return null;
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new KeyForQualifierHierarchy(factory);
    }

    public void canonicalizeForViewpointAdaptation(ExpressionTree invocation, AnnotatedTypeMirror type) {
        TreePath path = this.getPath(invocation);
        TreePath enclosingMethodPath = TreeUtils.pathTillOfKind(path, Tree.Kind.METHOD);
        if (path == null || enclosingMethodPath == null) {
            return;
        }
        Node node = this.getNodeForTree(path.getLeaf());
        if (node == null || node instanceof FunctionalInterfaceNode) {
            return;
        }
        if (invocation.getKind() != Tree.Kind.METHOD_INVOCATION && invocation.getKind() != Tree.Kind.NEW_CLASS) {
            ErrorReporter.errorAbort("canonicalizeForViewpointAdaptation can only be called on method invocationsand constructor calls.\ntree=" + invocation + "\n" + "type=" + type + "\n" + "node=" + node + "\n");
        }
        FlowExpressionParseUtil.FlowExpressionContext flowExpressionContext = KeyForAnnotatedTypeFactory.buildFlowExprContextForViewpointUse(node, enclosingMethodPath, this.getContext());
        this.keyForCanonicalizer.canonicalize(type, flowExpressionContext, path, true);
    }

    private static FlowExpressionParseUtil.FlowExpressionContext buildFlowExprContextForViewpointUse(Node node, TreePath enclosingMethodPath, BaseContext checkerContext) {
        FlowExpressions.Receiver internalReceiver;
        if (node instanceof MethodInvocationNode) {
            Node receiver = ((MethodInvocationNode)node).getTarget().getReceiver();
            internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
        } else if (node instanceof ObjectCreationNode) {
            internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), node);
        } else {
            throw new IllegalArgumentException("Node must be either a MethodInvocationNode or an ObjectCreationNode\nnode=" + node + "\n" + "enclosingMethodPath=" + enclosingMethodPath);
        }
        ClassTree classTree = TreeUtils.enclosingClass(enclosingMethodPath);
        MethodTree methodTree = (MethodTree)enclosingMethodPath.getLeaf();
        ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(InternalUtils.typeOf(classTree));
        ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
        for (VariableTree variableTree : methodTree.getParameters()) {
            internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
        }
        return new FlowExpressionParseUtil.FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
    }

    class KeyForTypeArgumentInference
    extends DefaultTypeArgumentInference {
        KeyForTypeArgumentInference() {
        }

        @Override
        public void adaptMethodType(AnnotatedTypeFactory typeFactory, ExpressionTree invocation, AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
            KeyForAnnotatedTypeFactory.this.canonicalizeForViewpointAdaptation(invocation, methodType);
        }

        @Override
        protected List<AnnotatedTypeMirror> getArgumentTypes(ExpressionTree expression, AnnotatedTypeFactory typeFactory) {
            List<AnnotatedTypeMirror> argTypes = super.getArgumentTypes(expression, typeFactory);
            if (!argTypes.isEmpty()) {
                TreePath pathToInvocation = KeyForAnnotatedTypeFactory.this.getPath(expression).getParentPath();
                TreePath enclosingMethodPath = TreeUtils.pathTillOfKind(pathToInvocation, Tree.Kind.METHOD);
                Node node = KeyForAnnotatedTypeFactory.this.getNodeForTree(expression);
                if (node == null || enclosingMethodPath == null) {
                    return argTypes;
                }
                FlowExpressionParseUtil.FlowExpressionContext flowExpressionContext = KeyForAnnotatedTypeFactory.buildFlowExprContextForViewpointUse(node, enclosingMethodPath, KeyForAnnotatedTypeFactory.this.getContext());
                for (AnnotatedTypeMirror argType : argTypes) {
                    KeyForAnnotatedTypeFactory.this.keyForCanonicalizer.canonicalize(argType, flowExpressionContext, pathToInvocation, true);
                }
            }
            return argTypes;
        }

        @Override
        protected AnnotatedTypeMirror getAssignedTo(ExpressionTree expression, AnnotatedTypeFactory typeFactory) {
            AnnotatedTypeMirror assignedTo = super.getAssignedTo(expression, typeFactory);
            if (assignedTo != null) {
                KeyForAnnotatedTypeFactory.this.canonicalizeForViewpointAdaptation(expression, assignedTo);
            }
            return assignedTo;
        }
    }

    private final class KeyForQualifierHierarchy
    extends GraphQualifierHierarchy {
        public KeyForQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, null);
        }

        @Override
        public AnnotationMirror getPolymorphicAnnotation(AnnotationMirror start) {
            AnnotationMirror top = this.getTopAnnotation(start);
            if (AnnotationUtils.areSameIgnoringValues(top, KeyForAnnotatedTypeFactory.this.UNKNOWNKEYFOR)) {
                return null;
            }
            if (this.polyQualifiers.containsKey(top)) {
                return (AnnotationMirror)this.polyQualifiers.get(top);
            }
            if (this.polyQualifiers.containsKey(this.polymorphicQualifier)) {
                return (AnnotationMirror)this.polyQualifiers.get(this.polymorphicQualifier);
            }
            ErrorReporter.errorAbort("GraphQualifierHierarchy: did not find the polymorphic qualifier corresponding to qualifier " + start + "; all polymorphic qualifiers: " + this.polyQualifiers + "; this: " + this);
            return null;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, KeyForAnnotatedTypeFactory.this.KEYFOR) && AnnotationUtils.areSameIgnoringValues(rhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                List<Object> lhsValues = null;
                List<Object> rhsValues = null;
                Map<? extends ExecutableElement, ? extends AnnotationValue> valMap = lhs.getElementValues();
                lhsValues = valMap.isEmpty() ? new ArrayList() : AnnotationUtils.getElementValueArray(lhs, "value", String.class, true);
                valMap = rhs.getElementValues();
                rhsValues = valMap.isEmpty() ? new ArrayList() : AnnotationUtils.getElementValueArray(rhs, "value", String.class, true);
                return rhsValues.containsAll(lhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                lhs = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                rhs = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    class KeyForCanonicalizer
    extends AnnotatedTypeScanner<Void, Void> {
        private FlowExpressionParseUtil.FlowExpressionContext context = null;
        private TreePath path = null;
        private boolean changed = false;
        private boolean use;

        KeyForCanonicalizer() {
        }

        protected boolean canonicalize(AnnotatedTypeMirror type, FlowExpressionParseUtil.FlowExpressionContext context, TreePath path, boolean use) {
            this.reset();
            this.use = use;
            this.context = context;
            this.path = path;
            this.changed = false;
            this.scan(type, null);
            return this.changed;
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void v) {
            if (type == null) {
                return null;
            }
            AnnotationMirror keyFor = type.getAnnotation(KeyFor.class);
            if (keyFor != null) {
                AnnotationMirror anno;
                LinkedHashSet newValues = KeyForAnnotatedTypeFactory.this.canonicalizeKeyForValues(keyFor, this.context, this.path, true, this.use);
                AnnotationMirror annotationMirror = anno = newValues == null ? null : KeyForAnnotatedTypeFactory.this.createKeyForAnnotationMirrorWithValue(newValues);
                if (anno != null) {
                    type.replaceAnnotation(anno);
                    this.changed = true;
                }
            }
            return (Void)super.scan(type, null);
        }
    }

    protected class KeyForTypeHierarchy
    extends DefaultTypeHierarchy {
        public KeyForTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrayComponents) {
            super(checker, qualifierHierarchy, ignoreRawTypes, invariantArrayComponents);
        }

        @Override
        public boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
            if (supertype.getKind() == TypeKind.TYPEVAR && subtype.getKind() == TypeKind.TYPEVAR && supertype.getAnnotations().isEmpty()) {
                return true;
            }
            if (subtype.hasAnnotation(KeyForBottom.class)) {
                return true;
            }
            return super.isSubtype(subtype, supertype, visited);
        }

        protected boolean isCovariant(int typeArgIndex, int[] covariantArgIndexes) {
            if (covariantArgIndexes != null) {
                for (int covariantIndex : covariantArgIndexes) {
                    if (typeArgIndex != covariantIndex) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Boolean visitTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited, boolean subtypeIsRaw, boolean supertypeIsRaw) {
            boolean ignoreTypeArgs;
            boolean bl = ignoreTypeArgs = this.ignoreRawTypes && (subtypeIsRaw || supertypeIsRaw);
            if (!ignoreTypeArgs) {
                TypeElement supertypeElem = (TypeElement)supertype.getUnderlyingType().asElement();
                int[] covariantArgIndexes = null;
                if (supertypeElem.getAnnotation(Covariant.class) != null) {
                    covariantArgIndexes = supertypeElem.getAnnotation(Covariant.class).value();
                }
                List<AnnotatedTypeMirror> subtypeTypeArgs = subtype.getTypeArguments();
                List<AnnotatedTypeMirror> supertypeTypeArgs = supertype.getTypeArguments();
                if (subtypeTypeArgs.isEmpty() || supertypeTypeArgs.isEmpty()) {
                    return true;
                }
                if (supertypeTypeArgs.size() > 0) {
                    for (int i = 0; i < supertypeTypeArgs.size(); ++i) {
                        AnnotatedTypeMirror superTypeArg = supertypeTypeArgs.get(i);
                        AnnotatedTypeMirror subTypeArg = subtypeTypeArgs.get(i);
                        if (subtypeIsRaw || supertypeIsRaw) {
                            this.rawnessComparer.isValidInHierarchy(subtype, supertype, this.currentTop, visited);
                            continue;
                        }
                        if (this.isContainedBy(subTypeArg, superTypeArg, visited, this.isCovariant(i, covariantArgIndexes))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

