/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import edu.umd.cs.findbugs.annotations.UnknownNullness;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.validation.constraints.NotNull;
import org.checkerframework.checker.initialization.InitializationAnnotatedTypeFactory;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.AbstractNullnessChecker;
import org.checkerframework.checker.nullness.CollectionToArrayHeuristics;
import org.checkerframework.checker.nullness.NullnessAnalysis;
import org.checkerframework.checker.nullness.NullnessAnnotatedTypeFormatter;
import org.checkerframework.checker.nullness.NullnessStore;
import org.checkerframework.checker.nullness.NullnessTransfer;
import org.checkerframework.checker.nullness.NullnessValue;
import org.checkerframework.checker.nullness.SystemGetPropertyHandler;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullType;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NonNullType;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.compatqual.PolyNullDecl;
import org.checkerframework.checker.nullness.compatqual.PolyNullType;
import org.checkerframework.checker.nullness.qual.LazyNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.Raw;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GeneralAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ImplicitsTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.PropagationTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.DependentTypes;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;

public class NullnessAnnotatedTypeFactory
extends InitializationAnnotatedTypeFactory<NullnessValue, NullnessStore, NullnessTransfer, NullnessAnalysis> {
    protected final AnnotationMirror NONNULL;
    protected final AnnotationMirror NULLABLE;
    protected final AnnotationMirror POLYNULL;
    protected final AnnotationMirror MONOTONIC_NONNULL;
    protected final DependentTypes dependentTypes;
    protected final SystemGetPropertyHandler systemGetPropertyHandler;
    protected final CollectionToArrayHeuristics collectionToArrayHeuristics;
    protected final GeneralAnnotatedTypeFactory generalFactory;
    protected final Set<Class<? extends Annotation>> nullnessAnnos;

    public NullnessAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFbc) {
        super(checker, useFbc);
        this.NONNULL = AnnotationUtils.fromClass(this.elements, NonNull.class);
        this.NULLABLE = AnnotationUtils.fromClass(this.elements, Nullable.class);
        this.POLYNULL = AnnotationUtils.fromClass(this.elements, PolyNull.class);
        this.MONOTONIC_NONNULL = AnnotationUtils.fromClass(this.elements, MonotonicNonNull.class);
        LinkedHashSet<Class<PolyAll>> tempNullnessAnnos = new LinkedHashSet<Class<PolyAll>>();
        tempNullnessAnnos.add(NonNull.class);
        tempNullnessAnnos.add(MonotonicNonNull.class);
        tempNullnessAnnos.add(Nullable.class);
        tempNullnessAnnos.add(PolyNull.class);
        tempNullnessAnnos.add(PolyAll.class);
        this.nullnessAnnos = Collections.unmodifiableSet(tempNullnessAnnos);
        this.addAliasedAnnotation(LazyNonNull.class, this.MONOTONIC_NONNULL);
        this.addAliasedAnnotation(com.sun.istack.internal.NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(Nonnull.class, this.NONNULL);
        this.addAliasedAnnotation(NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(lombok.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.eclipse.jdt.annotation.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.eclipse.jgit.annotations.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.jetbrains.annotations.NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.netbeans.api.annotations.common.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.jmlspecs.annotation.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(android.annotation.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(android.support.annotation.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(com.sun.istack.internal.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(UnknownNullness.class, this.NULLABLE);
        this.addAliasedAnnotation(CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(javax.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.eclipse.jdt.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.eclipse.jgit.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.jetbrains.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.netbeans.api.annotations.common.CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(NullAllowed.class, this.NULLABLE);
        this.addAliasedAnnotation(NullUnknown.class, this.NULLABLE);
        this.addAliasedAnnotation(org.jmlspecs.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(android.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(android.support.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(NullableDecl.class, this.NULLABLE);
        this.addAliasedAnnotation(PolyNullDecl.class, this.POLYNULL);
        this.addAliasedAnnotation(NonNullDecl.class, this.NONNULL);
        this.addAliasedAnnotation(MonotonicNonNullDecl.class, this.MONOTONIC_NONNULL);
        this.addAliasedAnnotation(NullableType.class, this.NULLABLE);
        this.addAliasedAnnotation(PolyNullType.class, this.POLYNULL);
        this.addAliasedAnnotation(NonNullType.class, this.NONNULL);
        this.addAliasedAnnotation(MonotonicNonNullType.class, this.MONOTONIC_NONNULL);
        this.generalFactory = new GeneralAnnotatedTypeFactory(checker);
        this.dependentTypes = new DependentTypes(checker, this.generalFactory);
        this.systemGetPropertyHandler = new SystemGetPropertyHandler(this.processingEnv, this);
        this.postInit();
        this.collectionToArrayHeuristics = new CollectionToArrayHeuristics(this.processingEnv, this);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        AbstractNullnessChecker ckr = (AbstractNullnessChecker)this.checker;
        if (ckr.useFbc) {
            return Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Nullable.class, MonotonicNonNull.class, NonNull.class, UnderInitialization.class, Initialized.class, UnknownInitialization.class, FBCBottom.class, PolyNull.class, PolyAll.class)));
        }
        return Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Nullable.class, MonotonicNonNull.class, NonNull.class, NonRaw.class, Raw.class, PolyNull.class, PolyAll.class)));
    }

    @Override
    public void setRoot(CompilationUnitTree root) {
        this.generalFactory.setRoot(root);
        super.setRoot(root);
    }

    @Override
    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean useFlow) {
        super.addComputedTypeAnnotations(tree, type, useFlow);
        this.dependentTypes.handle(tree, type);
    }

    protected void replacePolyQualifier(AnnotatedTypeMirror lhsType, Tree context) {
        NullnessValue inferred;
        if ((lhsType.hasAnnotation(PolyNull.class) || lhsType.hasAnnotation(PolyAll.class)) && (inferred = (NullnessValue)this.getInferredValueFor(context)) != null && inferred.isPolyNullNull) {
            lhsType.replaceAnnotation(this.NULLABLE);
        }
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> fromUse = super.constructorFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType constructor = (AnnotatedTypeMirror.AnnotatedExecutableType)fromUse.first;
        this.dependentTypes.handleConstructor(tree, this.generalFactory.getAnnotatedType(tree), constructor);
        return fromUse;
    }

    @Override
    public List<VariableTree> getUninitializedInvariantFields(NullnessStore store, TreePath path, boolean isStatic, List<? extends AnnotationMirror> receiverAnnotations) {
        List<VariableTree> candidates = super.getUninitializedInvariantFields(store, path, isStatic, receiverAnnotations);
        ArrayList<VariableTree> result = new ArrayList<VariableTree>();
        for (VariableTree c : candidates) {
            AnnotatedTypeMirror type = this.getAnnotatedType(c);
            boolean isPrimitive = TypesUtils.isPrimitive(type.getUnderlyingType());
            if (isPrimitive) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    protected NullnessAnalysis createFlowAnalysis(List<Pair<VariableElement, NullnessValue>> fieldValues) {
        return new NullnessAnalysis(this.checker, this, fieldValues);
    }

    @Override
    public NullnessTransfer createFlowTransferFunction(CFAbstractAnalysis<NullnessValue, NullnessStore, NullnessTransfer> analysis) {
        return new NullnessTransfer((NullnessAnalysis)analysis);
    }

    @Override
    protected AnnotatedTypeFormatter createAnnotatedTypeFormatter() {
        return new NullnessAnnotatedTypeFormatter(this.checker.hasOption("printVerboseGenerics"), this.checker.hasOption("printAllQualifiers"));
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        this.systemGetPropertyHandler.handle(tree, method);
        this.collectionToArrayHeuristics.handle(tree, method);
        return mfuPair;
    }

    @Override
    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3, ReturnTree r) {
        AnnotatedTypeMirror result = super.getMethodReturnType(m3, r);
        this.replacePolyQualifier(result, r);
        return result;
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        ImplicitsTypeAnnotator implicitsTypeAnnotator = new ImplicitsTypeAnnotator(this);
        implicitsTypeAnnotator.addTypeClass(AnnotatedTypeMirror.AnnotatedNoType.class, this.NONNULL);
        implicitsTypeAnnotator.addTypeClass(AnnotatedTypeMirror.AnnotatedPrimitiveType.class, this.NONNULL);
        return new ListTypeAnnotator(new PropagationTypeAnnotator(this), implicitsTypeAnnotator, new NullnessTypeAnnotator(this), new InitializationAnnotatedTypeFactory.CommitmentTypeAnnotator(this));
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        ImplicitsTreeAnnotator implicitsTreeAnnotator = new ImplicitsTreeAnnotator(this);
        implicitsTreeAnnotator.addTreeKind(Tree.Kind.NEW_CLASS, this.NONNULL);
        implicitsTreeAnnotator.addTreeKind(Tree.Kind.NEW_ARRAY, this.NONNULL);
        return new ListTreeAnnotator(new NullnessPropagationAnnotator(this), implicitsTreeAnnotator, new NullnessTreeAnnotator(this), new InitializationAnnotatedTypeFactory.CommitmentTreeAnnotator(this));
    }

    private void annotateIfStatic(Element elt, AnnotatedTypeMirror type) {
        if (elt == null) {
            return;
        }
        if (elt.getKind().isClass() || elt.getKind().isInterface() || NullnessAnnotatedTypeFactory.isSystemField(elt)) {
            type.replaceAnnotation(this.NONNULL);
        }
    }

    private static boolean isSystemField(Element elt) {
        if (!elt.getKind().isField()) {
            return false;
        }
        if (!ElementUtils.isStatic(elt) || !ElementUtils.isFinal(elt)) {
            return false;
        }
        VariableElement var = (VariableElement)elt;
        boolean inJavaPackage = ElementUtils.getQualifiedClassName(var).toString().startsWith("java.");
        return var.getConstantValue() != null || var.getSimpleName().contentEquals("class") || inJavaPackage;
    }

    public Set<Class<? extends Annotation>> getNullnessAnnotations() {
        return this.nullnessAnnos;
    }

    @Override
    public Set<Class<? extends Annotation>> getInvalidConstructorReturnTypeAnnotations() {
        HashSet<Class<? extends Annotation>> l = new HashSet<Class<? extends Annotation>>(super.getInvalidConstructorReturnTypeAnnotations());
        l.addAll(this.getNullnessAnnotations());
        return l;
    }

    @Override
    public AnnotationMirror getFieldInvariantAnnotation() {
        Elements elements = this.processingEnv.getElementUtils();
        return AnnotationUtils.fromClass(elements, NonNull.class);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new NullnessQualifierHierarchy(factory, null);
    }

    protected class NullnessQualifierHierarchy
    extends InitializationAnnotatedTypeFactory.InitializationQualifierHierarchy {
        public NullnessQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, Object[] arg) {
            super(f, arg);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(rhs) || NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(lhs)) {
                return this.isSubtypeInitialization(rhs, lhs);
            }
            return super.isSubtype(rhs, lhs);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(a1) || NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(a2)) {
                return this.leastUpperBoundInitialization(a1, a2);
            }
            return super.leastUpperBound(a1, a2);
        }
    }

    protected class NullnessTypeAnnotator
    extends InitializationAnnotatedTypeFactory.CommitmentTypeAnnotator {
        public NullnessTypeAnnotator(InitializationAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory) {
            super(atypeFactory);
        }
    }

    protected class NullnessTreeAnnotator
    extends TreeAnnotator {
        public NullnessTreeAnnotator(NullnessAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, AnnotatedTypeMirror type) {
            Element elt = InternalUtils.symbol(node);
            if (elt.getKind() == ElementKind.EXCEPTION_PARAMETER && !type.isAnnotatedInHierarchy(NullnessAnnotatedTypeFactory.this.NONNULL)) {
                type.addAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type);
            if (elt.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return null;
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }
    }

    protected class NullnessPropagationAnnotator
    extends PropagationTreeAnnotator {
        public NullnessPropagationAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            return null;
        }
    }
}

