/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;

public class ElementAnnotationUtil {
    public static void applyAllElementAnnotations(List<? extends AnnotatedTypeMirror> types, List<? extends Element> elements, AnnotatedTypeFactory typeFactory) {
        if (types.size() != elements.size()) {
            ErrorReporter.errorAbort("Number of types and elements don't match!types ( " + PluginUtil.join(", ", types) + " ) " + "element ( " + PluginUtil.join(", ", elements) + " ) ");
        }
        for (int i = 0; i < types.size(); ++i) {
            ElementAnnotationApplier.apply(types.get(i), elements.get(i), typeFactory);
        }
    }

    static void addAnnotationsFromElement(AnnotatedTypeMirror type, List<? extends AnnotationMirror> annotations) {
        AnnotatedTypeMirror innerType = AnnotatedTypes.innerMostType(type);
        innerType.addAnnotations(annotations);
    }

    static boolean contains(Object enumValue, Object[] expectedValues) {
        for (Object expected : expectedValues) {
            if (!enumValue.equals(expected)) continue;
            return true;
        }
        return false;
    }

    static Map<TargetType, List<Attribute.TypeCompound>> partitionByTargetType(Collection<Attribute.TypeCompound> annos, List<Attribute.TypeCompound> unmatched, TargetType ... targetTypes) {
        HashMap<TargetType, List<Attribute.TypeCompound>> targetTypeToAnnos = new HashMap<TargetType, List<Attribute.TypeCompound>>();
        for (TargetType targetType : targetTypes) {
            targetTypeToAnnos.put(targetType, new ArrayList(10));
        }
        for (Attribute.TypeCompound anno : annos) {
            List annoSet = (List)targetTypeToAnnos.get((Object)anno.getPosition().type);
            if (annoSet != null) {
                annoSet.add(anno);
                continue;
            }
            if (unmatched == null) continue;
            unmatched.add(anno);
        }
        return targetTypeToAnnos;
    }

    static void annotateViaTypeAnnoPosition(AnnotatedTypeMirror type, Collection<Attribute.TypeCompound> annos) {
        IdentityHashMap<AnnotatedTypeMirror.AnnotatedWildcardType, WildcardBoundAnnos> wildcardToAnnos = new IdentityHashMap<AnnotatedTypeMirror.AnnotatedWildcardType, WildcardBoundAnnos>();
        for (Attribute.TypeCompound anno : annos) {
            AnnotatedTypeMirror target = ElementAnnotationUtil.getTypeAtLocation(type, anno.position.location);
            if (target.getKind() == TypeKind.WILDCARD) {
                ElementAnnotationUtil.addWildcardToBoundMap((AnnotatedTypeMirror.AnnotatedWildcardType)target, anno, wildcardToAnnos);
                continue;
            }
            target.addAnnotation(anno);
        }
        for (WildcardBoundAnnos wildcardAnnos : wildcardToAnnos.values()) {
            wildcardAnnos.apply();
        }
    }

    private static void addWildcardToBoundMap(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, Attribute.TypeCompound anno, Map<AnnotatedTypeMirror.AnnotatedWildcardType, WildcardBoundAnnos> wildcardToAnnos) {
        WildcardBoundAnnos boundAnnos = wildcardToAnnos.get(wildcard);
        if (boundAnnos == null) {
            boundAnnos = new WildcardBoundAnnos(wildcard);
            wildcardToAnnos.put(wildcard, boundAnnos);
        }
        boundAnnos.addAnnotation(anno);
    }

    static boolean isOnComponentType(Attribute.TypeCompound typeCompound) {
        return !typeCompound.position.location.isEmpty();
    }

    static int getBoundIndexOffset(List<? extends AnnotatedTypeMirror> upperBoundTypes) {
        int boundIndexOffset = ((Type)upperBoundTypes.get(0).getUnderlyingType()).isInterface() ? -1 : 0;
        return boundIndexOffset;
    }

    static AnnotatedTypeMirror getTypeAtLocation(AnnotatedTypeMirror type, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.isEmpty()) {
            return type;
        }
        if (type.getKind() == TypeKind.NULL) {
            return ElementAnnotationUtil.getLocationTypeANT((AnnotatedTypeMirror.AnnotatedNullType)type, location);
        }
        if (type.getKind() == TypeKind.DECLARED) {
            return ElementAnnotationUtil.getLocationTypeADT((AnnotatedTypeMirror.AnnotatedDeclaredType)type, location);
        }
        if (type.getKind() == TypeKind.WILDCARD) {
            return ElementAnnotationUtil.getLocationTypeAWT((AnnotatedTypeMirror.AnnotatedWildcardType)type, location);
        }
        if (type.getKind() == TypeKind.ARRAY) {
            return ElementAnnotationUtil.getLocationTypeAAT((AnnotatedTypeMirror.AnnotatedArrayType)type, location);
        }
        ErrorReporter.errorAbort("ElementAnnotationUtil.getTypeAtLocation: only declared types, arrays, and null types can have annotations with location; found type: " + type + " location: " + location);
        return null;
    }

    private static AnnotatedTypeMirror getLocationTypeADT(AnnotatedTypeMirror.AnnotatedDeclaredType type, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.isEmpty()) {
            return type;
        }
        if (location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) && location.get((int)0).arg < type.getTypeArguments().size()) {
            return ElementAnnotationUtil.getTypeAtLocation(type.getTypeArguments().get(location.get((int)0).arg), ElementAnnotationUtil.tail(location));
        }
        if (location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE)) {
            int totalEncl = ElementAnnotationUtil.countEnclosing(type);
            int totalInner = ElementAnnotationUtil.countInner(location);
            if (totalInner > totalEncl) {
                return type;
            }
            if (totalInner == totalEncl) {
                List<TypeAnnotationPosition.TypePathEntry> loc = location;
                for (int i = 0; i < totalEncl; ++i) {
                    loc = ElementAnnotationUtil.tail(loc);
                }
                return ElementAnnotationUtil.getTypeAtLocation(type, loc);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType toret = type;
            List<TypeAnnotationPosition.TypePathEntry> loc = location;
            for (int i = 0; i < totalEncl - totalInner; ++i) {
                if (toret.getEnclosingType() == null) continue;
                toret = toret.getEnclosingType();
                loc = ElementAnnotationUtil.tail(loc);
            }
            return ElementAnnotationUtil.getTypeAtLocation(toret, loc);
        }
        return type;
    }

    private static int countInner(List<TypeAnnotationPosition.TypePathEntry> location) {
        int cnt = 0;
        while (!location.isEmpty() && location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE)) {
            ++cnt;
            location = ElementAnnotationUtil.tail(location);
        }
        return cnt;
    }

    private static int countEnclosing(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        int cnt = 0;
        while (type.getEnclosingType() != null) {
            ++cnt;
            type = type.getEnclosingType();
        }
        return cnt;
    }

    private static AnnotatedTypeMirror getLocationTypeANT(AnnotatedTypeMirror.AnnotatedNullType type, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.size() == 1 && location.get((int)0).tag == TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) {
            return type;
        }
        ErrorReporter.errorAbort("ElementAnnotationUtil.getLocationTypeANT: invalid location " + location + " for type: " + type);
        return null;
    }

    private static AnnotatedTypeMirror getLocationTypeAWT(AnnotatedTypeMirror.AnnotatedWildcardType type, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.size() == 1) {
            return type;
        }
        if (!location.isEmpty() && location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.WILDCARD)) {
            if (AnnotatedTypes.hasExplicitExtendsBound(type)) {
                return ElementAnnotationUtil.getTypeAtLocation(type.getExtendsBound(), ElementAnnotationUtil.tail(location));
            }
            if (AnnotatedTypes.hasExplicitSuperBound(type)) {
                return ElementAnnotationUtil.getTypeAtLocation(type.getSuperBound(), ElementAnnotationUtil.tail(location));
            }
            return ElementAnnotationUtil.getTypeAtLocation(type.getExtendsBound(), ElementAnnotationUtil.tail(location));
        }
        ErrorReporter.errorAbort("ElementAnnotationUtil.getLocationTypeAWT: invalid location " + location + " for type: " + type);
        return null;
    }

    private static AnnotatedTypeMirror getLocationTypeAAT(AnnotatedTypeMirror.AnnotatedArrayType type, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.size() >= 1 && location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.ARRAY)) {
            AnnotatedTypeMirror comptype = type.getComponentType();
            return ElementAnnotationUtil.getTypeAtLocation(comptype, ElementAnnotationUtil.tail(location));
        }
        ErrorReporter.errorAbort("ElementAnnotationUtil.annotateAAT: invalid location " + location + " for type: " + type);
        return null;
    }

    private static <T> List<T> tail(List<T> list) {
        return list.subList(1, list.size());
    }

    private static final class WildcardBoundAnnos {
        public final AnnotatedTypeMirror.AnnotatedWildcardType wildcard;
        public final Set<AnnotationMirror> upperBoundAnnos;
        public final Set<AnnotationMirror> lowerBoundAnnos;
        public final Set<AnnotationMirror> possiblyBoth;
        private final boolean isSuperBounded;
        private final boolean isUnbounded;

        WildcardBoundAnnos(AnnotatedTypeMirror.AnnotatedWildcardType wildcard) {
            this.wildcard = wildcard;
            this.upperBoundAnnos = AnnotationUtils.createAnnotationSet();
            this.lowerBoundAnnos = AnnotationUtils.createAnnotationSet();
            this.possiblyBoth = AnnotationUtils.createAnnotationSet();
            this.isSuperBounded = AnnotatedTypes.hasExplicitSuperBound(wildcard);
            this.isUnbounded = AnnotatedTypes.hasNoExplicitBound(wildcard);
        }

        void addAnnotation(Attribute.TypeCompound anno) {
            boolean isInFrontOfWildcard;
            boolean bl = isInFrontOfWildcard = anno.getPosition().location.last() != TypeAnnotationPosition.TypePathEntry.WILDCARD;
            if (isInFrontOfWildcard && this.isUnbounded) {
                this.possiblyBoth.add(anno);
            } else if (isInFrontOfWildcard) {
                if (this.isSuperBounded) {
                    this.upperBoundAnnos.add(anno);
                } else {
                    this.lowerBoundAnnos.add(anno);
                }
            } else if (this.isSuperBounded) {
                this.lowerBoundAnnos.add(anno);
            } else {
                this.upperBoundAnnos.add(anno);
            }
        }

        void apply() {
            AnnotatedTypeMirror extendsBound = this.wildcard.getExtendsBound();
            AnnotatedTypeMirror superBound = this.wildcard.getSuperBound();
            for (AnnotationMirror extAnno : this.upperBoundAnnos) {
                extendsBound.addAnnotation(extAnno);
            }
            for (AnnotationMirror supAnno : this.lowerBoundAnnos) {
                superBound.addAnnotation(supAnno);
            }
            for (AnnotationMirror anno : this.possiblyBoth) {
                superBound.addAnnotation(anno);
                if (extendsBound.getAnnotationInHierarchy(anno) != null) continue;
                extendsBound.addAnnotation(anno);
            }
        }
    }
}

