/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.framework.test.ImmutableTestConfiguration;
import org.checkerframework.framework.test.SimpleOptionMap;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.util.PluginUtil;

public class TestConfigurationBuilder {
    private List<File> diagnosticFiles;
    private List<File> testSourceFiles;
    private Set<String> processors;
    private SimpleOptionMap options;
    private boolean shouldEmitDebugInfo;
    public static final String TESTS_OUTPUTDIR = "tests.outputDir";

    public static TestConfigurationBuilder getDefaultConfigurationBuilder(String testSourcePath, File outputClassDirectory, String classPath, Iterable<File> testSourceFiles, Iterable<String> processors, List<String> options, boolean shouldEmitDebugInfo) {
        String jdkJarPath;
        TestConfigurationBuilder configBuilder = new TestConfigurationBuilder().setShouldEmitDebugInfo(shouldEmitDebugInfo).addProcessors(processors).addOption("-Xmaxerrs", "9999").addOption("-g").addOption("-Xlint:unchecked").addOption("-XDrawDiagnostics").addOption("-AprintErrorStack").addSourceFiles(testSourceFiles);
        if (outputClassDirectory != null) {
            configBuilder.addOption("-d", outputClassDirectory.getAbsolutePath());
        }
        if (TestConfigurationBuilder.notNullOrEmpty(jdkJarPath = TestConfigurationBuilder.getJdkJarPathFromProperty())) {
            configBuilder.addOption("-Xbootclasspath/p:" + jdkJarPath);
        }
        configBuilder.addOptionIfValueNonEmpty("-sourcepath", testSourcePath).addOption("-implicit:class").addOption("-classpath", classPath);
        configBuilder.addOptions(options);
        return configBuilder;
    }

    public static TestConfigurationBuilder getDefaultConfigurationBuilder(String testSourcePath, File testFile, String checkerName, List<String> options, boolean shouldEmitDebugInfo) {
        String classpath = TestConfigurationBuilder.getDefaultClassPath();
        File outputDir = TestConfigurationBuilder.getOutputDirFromProperty();
        List<File> javaFiles = Arrays.asList(testFile);
        List<String> processors = Arrays.asList(checkerName);
        return TestConfigurationBuilder.getDefaultConfigurationBuilder(testSourcePath, outputDir, classpath, javaFiles, processors, options, shouldEmitDebugInfo);
    }

    public static TestConfiguration buildDefaultConfiguration(String testSourcePath, File outputClassDirectory, String classPath, Iterable<File> testSourceFiles, Iterable<String> processors, List<String> options, boolean shouldEmitDebugInfo) {
        TestConfigurationBuilder builder = TestConfigurationBuilder.getDefaultConfigurationBuilder(testSourcePath, outputClassDirectory, classPath, testSourceFiles, processors, options, shouldEmitDebugInfo);
        return builder.validateThenBuild(true);
    }

    private static boolean notNullOrEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static TestConfiguration buildDefaultConfiguration(String testSourcePath, File testFile, String checkerName, List<String> options, boolean shouldEmitDebugInfo) {
        TestConfigurationBuilder builder = TestConfigurationBuilder.getDefaultConfigurationBuilder(testSourcePath, testFile, checkerName, options, shouldEmitDebugInfo);
        return builder.validateThenBuild(true);
    }

    public TestConfigurationBuilder() {
        this.diagnosticFiles = new ArrayList<File>();
        this.testSourceFiles = new ArrayList<File>();
        this.processors = new LinkedHashSet<String>();
        this.options = new SimpleOptionMap();
        this.shouldEmitDebugInfo = false;
    }

    public TestConfigurationBuilder(TestConfiguration initialConfig) {
        this.diagnosticFiles = new ArrayList<File>(initialConfig.getDiagnosticFiles());
        this.testSourceFiles = new ArrayList<File>(initialConfig.getTestSourceFiles());
        this.processors = new LinkedHashSet<String>(initialConfig.getProcessors());
        this.options = new SimpleOptionMap();
        this.addOptions(initialConfig.getOptions());
        this.shouldEmitDebugInfo = initialConfig.shouldEmitDebugInfo();
    }

    public List<String> validate(boolean requireProcessors) {
        Map<String, String> optionMap;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.testSourceFiles == null || !this.testSourceFiles.iterator().hasNext()) {
            errors.add("No source files specified!");
        }
        if (requireProcessors && !this.processors.iterator().hasNext()) {
            errors.add("No processors were specified!");
        }
        if (!(optionMap = this.options.getOptions()).containsKey("-d") || optionMap.get("-d") == null) {
            errors.add("No output directory was specified.");
        }
        if (optionMap.containsKey("-processor")) {
            errors.add("Processors should not be added to the options list");
        }
        return errors;
    }

    public TestConfigurationBuilder adddToPathOption(String key, String toAppend) {
        this.options.addToPathOption(key, toAppend);
        return this;
    }

    public TestConfigurationBuilder addDiagnosticFile(File diagnostics) {
        this.diagnosticFiles.add(diagnostics);
        return this;
    }

    public TestConfigurationBuilder addDiagnosticFiles(Iterable<File> diagnostics) {
        this.diagnosticFiles = TestConfigurationBuilder.catListAndIterable(this.diagnosticFiles, diagnostics);
        return this;
    }

    public TestConfigurationBuilder setDiagnosticFiles(List<File> diagnosticFiles) {
        this.diagnosticFiles = new ArrayList<File>(diagnosticFiles);
        return this;
    }

    public TestConfigurationBuilder addSourceFile(File sourceFile) {
        this.testSourceFiles.add(sourceFile);
        return this;
    }

    public TestConfigurationBuilder addSourceFiles(Iterable<File> sourceFiles) {
        this.testSourceFiles = TestConfigurationBuilder.catListAndIterable(this.testSourceFiles, sourceFiles);
        return this;
    }

    public TestConfigurationBuilder setSourceFiles(List<File> sourceFiles) {
        this.testSourceFiles = new ArrayList<File>(sourceFiles);
        return this;
    }

    public TestConfigurationBuilder setOptions(Map<String, String> options) {
        this.options.setOptions(options);
        return this;
    }

    public TestConfigurationBuilder addOption(String option) {
        this.options.addOption(option);
        return this;
    }

    public TestConfigurationBuilder addOption(String option, String value) {
        this.options.addOption(option, value);
        return this;
    }

    public TestConfigurationBuilder addOptionIfValueNonEmpty(String option, String value) {
        if (value != null && !value.isEmpty()) {
            return this.addOption(option, value);
        }
        return this;
    }

    public TestConfigurationBuilder addOptions(Map<String, String> options) {
        this.options.addOptions(options);
        return this;
    }

    public TestConfigurationBuilder addOptions(Iterable<String> newOptions) {
        this.options.addOptions(newOptions);
        return this;
    }

    public TestConfigurationBuilder setProcessors(Iterable<String> processors) {
        this.processors.clear();
        for (String proc : processors) {
            this.processors.add(proc);
        }
        return this;
    }

    public TestConfigurationBuilder addProcessor(String processor) {
        this.processors.add(processor);
        return this;
    }

    public TestConfigurationBuilder addProcessors(Iterable<String> processors) {
        for (String processor : processors) {
            this.processors.add(processor);
        }
        return this;
    }

    public TestConfigurationBuilder emitDebugInfo() {
        this.shouldEmitDebugInfo = true;
        return this;
    }

    public TestConfigurationBuilder dontEmitDebugInfo() {
        this.shouldEmitDebugInfo = false;
        return this;
    }

    public TestConfigurationBuilder setShouldEmitDebugInfo(boolean shouldEmitDebugInfo) {
        this.shouldEmitDebugInfo = shouldEmitDebugInfo;
        return this;
    }

    public TestConfiguration build() {
        return new ImmutableTestConfiguration(this.diagnosticFiles, this.testSourceFiles, new ArrayList<String>(this.processors), this.options.getOptions(), this.shouldEmitDebugInfo);
    }

    public TestConfiguration validateThenBuild(boolean requireProcessors) {
        List<String> errors = this.validate(requireProcessors);
        if (errors.isEmpty()) {
            return this.build();
        }
        throw new RuntimeException("Attempted to build invalid test configuration:\nErrors:\n" + PluginUtil.join("\n", errors) + "\n" + this.toString() + "\n");
    }

    public List<String> flatOptions() {
        return this.options.getOptionsAsList();
    }

    public String toString() {
        return "TestConfigurationBuilder:\ntestSourceFiles=" + (this.testSourceFiles == null ? "null" : PluginUtil.join(" ", this.testSourceFiles)) + "\n" + "processors=" + (this.processors == null ? "null" : PluginUtil.join(", ", this.processors)) + "\n" + "options=" + (this.options == null ? "null" : PluginUtil.join(", ", this.options.getOptionsAsList())) + "\n" + "shouldEmitDebugInfo=" + this.shouldEmitDebugInfo;
    }

    private static <T> List<T> catListAndIterable(List<T> list, Iterable<? extends T> iterable) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (T listObject : list) {
            newList.add(listObject);
        }
        for (Object iterObject : iterable) {
            newList.add(iterObject);
        }
        return newList;
    }

    public static File getOutputDirFromProperty() {
        return new File(System.getProperty(TESTS_OUTPUTDIR, "tests" + File.separator + "build" + File.separator + "testclasses"));
    }

    public static String getDefaultClassPath() {
        String classpath = System.getProperty("tests.classpath", "tests" + File.separator + "build");
        String globalclasspath = System.getProperty("java.class.path", "");
        return "build" + File.pathSeparator + "junit-4.12.jar" + File.pathSeparator + "hamcrest-core-1.3.jar" + File.pathSeparator + classpath + File.pathSeparator + globalclasspath;
    }

    public static String getJdkJarPathFromProperty() {
        return System.getProperty("JDK_JAR");
    }
}

