/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.visitor;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeComparer;
import org.checkerframework.javacutil.ErrorReporter;

public class AnnotatedTypeMerger
extends AnnotatedTypeComparer<Void> {
    private final AnnotationMirror top;

    public static void merge(AnnotatedTypeMirror from, AnnotatedTypeMirror to) {
        if (from == to) {
            ErrorReporter.errorAbort("From == to");
        }
        new AnnotatedTypeMerger().visit(from, to);
    }

    public static void merge(AnnotatedTypeMirror from, AnnotatedTypeMirror to, AnnotationMirror top) {
        if (from == to) {
            ErrorReporter.errorAbort("From == to");
        }
        new AnnotatedTypeMerger(top).visit(from, to);
    }

    public AnnotatedTypeMerger() {
        this.top = null;
    }

    public AnnotatedTypeMerger(AnnotationMirror top) {
        this.top = top;
    }

    @Override
    protected Void compare(AnnotatedTypeMirror one, AnnotatedTypeMirror two) {
        if (one != null && two != null) {
            this.replaceAnnotations(one, two);
        }
        return null;
    }

    @Override
    protected Void combineRs(Void r1, Void r2) {
        return r1;
    }

    protected void replaceAnnotations(AnnotatedTypeMirror one, AnnotatedTypeMirror two) {
        if (this.top == null) {
            two.replaceAnnotations(one.getAnnotations());
        } else {
            AnnotationMirror replacement = one.getAnnotationInHierarchy(this.top);
            if (replacement != null) {
                two.replaceAnnotation(one.getAnnotationInHierarchy(this.top));
            }
        }
    }

    @Override
    public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable from, AnnotatedTypeMirror to) {
        this.resolvePrimaries(from, to);
        return (Void)super.visitTypeVariable(from, to);
    }

    @Override
    public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType from, AnnotatedTypeMirror to) {
        this.resolvePrimaries(from, to);
        return (Void)super.visitWildcard(from, to);
    }

    public void resolvePrimaries(AnnotatedTypeMirror from, AnnotatedTypeMirror to) {
        if (from.getKind() == TypeKind.WILDCARD || from.getKind() == TypeKind.TYPEVAR) {
            if (this.top != null) {
                if (from.getAnnotationInHierarchy(this.top) == null) {
                    to.removeAnnotationInHierarchy(this.top);
                }
            } else {
                for (AnnotationMirror toPrimaryAnno : to.getAnnotations()) {
                    if (from.getAnnotationInHierarchy(toPrimaryAnno) != null) continue;
                    to.removeAnnotation(toPrimaryAnno);
                }
            }
        } else {
            ErrorReporter.errorAbort("ResolvePrimaries' from argument should be a type variable OR wildcard\nfrom=" + from.toString(true) + "\n" + "to=" + to.toString(true));
        }
    }
}

