/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class InternalUtils {
    private static final boolean RETURN_INVOKE_CONSTRUCTOR = true;

    private InternalUtils() {
        throw new AssertionError((Object)"Class InternalUtils cannot be instantiated.");
    }

    public static Element symbol(Tree tree) {
        if (tree == null) {
            ErrorReporter.errorAbort("InternalUtils.symbol: tree is null");
            return null;
        }
        if (!(tree instanceof JCTree)) {
            ErrorReporter.errorAbort("InternalUtils.symbol: tree is not a valid Javac tree");
            return null;
        }
        if (TreeUtils.isExpressionTree(tree)) {
            tree = TreeUtils.skipParens((ExpressionTree)tree);
        }
        switch (tree.getKind()) {
            case VARIABLE: 
            case METHOD: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case TYPE_PARAMETER: {
                return TreeInfo.symbolFor((JCTree)tree);
            }
            case METHOD_INVOCATION: {
                return TreeInfo.symbol(((JCTree.JCMethodInvocation)tree).getMethodSelect());
            }
            case ASSIGNMENT: {
                return TreeInfo.symbol((JCTree)((Object)((AssignmentTree)tree).getVariable()));
            }
            case ARRAY_ACCESS: {
                return InternalUtils.symbol(((ArrayAccessTree)tree).getExpression());
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree).constructor;
            }
            case MEMBER_REFERENCE: {
                return ((JCTree.JCMemberReference)tree).sym;
            }
        }
        return TreeInfo.symbol((JCTree)tree);
    }

    public static boolean isAnonymousConstructor(MethodTree method) {
        Element e = InternalUtils.symbol(method);
        if (e == null || !(e instanceof Symbol)) {
            return false;
        }
        return (((Symbol)e).flags() & 0x20000000L) != 0L;
    }

    public static ExecutableElement constructor(NewClassTree tree) {
        if (!(tree instanceof JCTree.JCNewClass)) {
            ErrorReporter.errorAbort("InternalUtils.constructor: not a javac internal tree");
            return null;
        }
        JCTree.JCNewClass newClassTree = (JCTree.JCNewClass)tree;
        if (tree.getClassBody() != null) {
            JCTree.JCMethodDecl anonConstructor = (JCTree.JCMethodDecl)TreeInfo.declarationFor(newClassTree.constructor, newClassTree);
            assert (anonConstructor != null);
            assert (anonConstructor.body.stats.size() == 1);
            JCTree.JCExpressionStatement stmt = (JCTree.JCExpressionStatement)anonConstructor.body.stats.head;
            JCTree.JCMethodInvocation superInvok = (JCTree.JCMethodInvocation)stmt.expr;
            return (ExecutableElement)((Object)TreeInfo.symbol(superInvok.meth));
        }
        Symbol e = newClassTree.constructor;
        assert (e instanceof ExecutableElement);
        return (ExecutableElement)((Object)e);
    }

    public static final List<AnnotationMirror> annotationsFromTypeAnnotationTrees(List<? extends AnnotationTree> annos) {
        ArrayList<AnnotationMirror> annotations = new ArrayList<AnnotationMirror>(annos.size());
        for (AnnotationTree annotationTree : annos) {
            annotations.add(((JCTree.JCAnnotation)annotationTree).attribute);
        }
        return annotations;
    }

    public static final List<? extends AnnotationMirror> annotationsFromTree(AnnotatedTypeTree node) {
        return InternalUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCAnnotatedType)node).annotations);
    }

    public static final List<? extends AnnotationMirror> annotationsFromTree(TypeParameterTree node) {
        return InternalUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCTypeParameter)node).annotations);
    }

    public static final List<? extends AnnotationMirror> annotationsFromArrayCreation(NewArrayTree node, int level) {
        assert (node instanceof JCTree.JCNewArray);
        JCTree.JCNewArray newArray = (JCTree.JCNewArray)node;
        if (level == -1) {
            return InternalUtils.annotationsFromTypeAnnotationTrees(newArray.annotations);
        }
        if (newArray.dimAnnotations.length() > 0 && level >= 0 && level < newArray.dimAnnotations.size()) {
            return InternalUtils.annotationsFromTypeAnnotationTrees((List<? extends AnnotationTree>)newArray.dimAnnotations.get(level));
        }
        return Collections.emptyList();
    }

    public static TypeMirror typeOf(Tree tree) {
        return ((JCTree)tree).type;
    }

    public static boolean isCaptured(TypeVariable typeVar) {
        if (typeVar instanceof Type.AnnotatedType) {
            return ((Type.TypeVar)((Type.AnnotatedType)typeVar).unannotatedType()).isCaptured();
        }
        return ((Type.TypeVar)typeVar).isCaptured();
    }

    public static boolean isClassType(TypeMirror type) {
        return type instanceof Type.ClassType;
    }

    public static TypeMirror leastUpperBound(ProcessingEnvironment processingEnv, TypeMirror tm1, TypeMirror tm2) {
        Type bound;
        Type t1 = ((Type)tm1).unannotatedType();
        Type t2 = ((Type)tm2).unannotatedType();
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        Types types = Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t2;
            }
            if (types.isAssignable(t2, t1)) {
                return t1;
            }
            return processingEnv.getTypeUtils().getNoType(TypeKind.NONE);
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            WildcardType wc1 = (WildcardType)((Object)t1);
            bound = (Type)wc1.getExtendsBound();
            if (bound == null) {
                Elements elements = processingEnv.getElementUtils();
                return elements.getTypeElement("java.lang.Object").asType();
            }
            t1 = bound;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            WildcardType wc2 = (WildcardType)((Object)t2);
            bound = (Type)wc2.getExtendsBound();
            if (bound == null) {
                Elements elements = processingEnv.getElementUtils();
                return elements.getTypeElement("java.lang.Object").asType();
            }
            t2 = bound;
        }
        return types.lub(t1, t2);
    }

    public static TypeMirror greatestLowerBound(ProcessingEnvironment processingEnv, TypeMirror tm1, TypeMirror tm2) {
        Type t1 = ((Type)tm1).unannotatedType();
        Type t2 = ((Type)tm2).unannotatedType();
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        Types types = Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t1;
            }
            if (types.isAssignable(t2, t1)) {
                return t2;
            }
            return processingEnv.getTypeUtils().getNoType(TypeKind.NONE);
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            return t2;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            return t1;
        }
        return types.glb(t1, t2);
    }

    public static TypeMirror substituteMethodReturnType(TypeMirror methodType, TypeMirror substitutedReceiverType) {
        if (methodType.getKind() != TypeKind.TYPEVAR) {
            return methodType;
        }
        String t = methodType.toString();
        Type finalReceiverType = (Type)substitutedReceiverType;
        int i = 0;
        for (Symbol.TypeSymbol typeSymbol : finalReceiverType.tsym.getTypeParameters()) {
            if (t.equals(typeSymbol.toString())) {
                return finalReceiverType.getTypeArguments().get(i);
            }
            ++i;
        }
        assert (false);
        return null;
    }

    public static Context getJavacContext(ProcessingEnvironment env) {
        return ((JavacProcessingEnvironment)env).getContext();
    }

    public static TypeElement getTypeElement(TypeMirror type) {
        return (TypeElement)((Object)((Type)type).tsym);
    }
}

