/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.Wildcard;

public class QualParams<Q>
implements Map<String, Wildcard<Q>> {
    private Map<String, Wildcard<Q>> map;
    private PolyQual<Q> primary;

    public QualParams() {
        this.map = new HashMap<String, Wildcard<Q>>();
    }

    public QualParams(String name, Q qual, PolyQual<Q> primary) {
        this(name, new Wildcard<Q>(qual), primary);
    }

    public QualParams(String name, Wildcard<Q> qual, PolyQual<Q> primary) {
        this();
        this.map.put(name, qual);
        this.primary = primary;
    }

    public QualParams(PolyQual<Q> primary) {
        this();
        this.primary = primary;
    }

    public QualParams(Map<String, Wildcard<Q>> map, PolyQual<Q> primary) {
        this.map = new HashMap<String, Wildcard<Q>>(map);
        this.primary = primary;
    }

    public QualParams<Q> substituteAll(Map<String, Wildcard<Q>> substs) {
        if ("__@RegexBottom__".equals(this.toString()) || "__@RegexBottom__".equals(substs.toString())) {
            ErrorReporter.errorAbort("__@RegexBottom__ should never be a parameter to substitute.");
        }
        HashMap<String, Wildcard<Q>> newMap = new HashMap<String, Wildcard<Q>>();
        for (String string : this.map.keySet()) {
            Wildcard<Q> newValue = this.map.get(string).substitute(substs);
            newMap.put(string, newValue);
        }
        HashMap qualSubst = new HashMap();
        for (String k : substs.keySet()) {
            qualSubst.put(k, substs.get(k).getUpperBound());
        }
        PolyQual<Q> polyQual = this.primary == null ? null : this.primary.substitute(qualSubst);
        return new QualParams<Q>(newMap, polyQual);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Wildcard<Q>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualParams that = (QualParams)o;
        if (this.map != null ? !this.map.equals(that.map) : that.map != null) {
            return false;
        }
        return !(this.primary != null ? !this.primary.equals(that.primary) : that.primary != null);
    }

    @Override
    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }

    @Override
    public Wildcard<Q> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Wildcard<Q> put(String key, Wildcard<Q> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Wildcard<Q>> m) {
        this.map.putAll(m);
    }

    @Override
    public Wildcard<Q> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public QualParams<Q> clone() {
        QualParams<Q> clone = new QualParams<Q>();
        clone.putAll(this);
        clone.setPrimary(this.getPrimary());
        return clone;
    }

    public String toString() {
        String result = String.valueOf(this.primary);
        if (this.map.size() > 0) {
            result = result + " <<";
            boolean first = true;
            for (Map.Entry<String, Wildcard<Q>> entry : this.map.entrySet()) {
                if (!first) {
                    result = result + ",";
                } else {
                    first = false;
                }
                result = result + entry.getKey() + "=" + entry.getValue();
            }
            result = result + ">>";
        }
        return result;
    }

    @Override
    public Collection<Wildcard<Q>> values() {
        return this.map.values();
    }

    public PolyQual<Q> getPrimary() {
        return this.primary;
    }

    public void setPrimary(PolyQual<Q> primary) {
        this.primary = primary;
    }
}

