//-----------------------------------------------------------------------------
// File: rfitsio.cpp
//
// Desc: Wrapper for the CFITSIO library for use from the R and S-PLUS.
//       The CFITSIO library can be found at: 
//       
//       http://heasarc.gsfc.nasa.gov/docs/software/fitsio/fitsio.html
//
// Copyright (c) 2003 Dimitrios Zervas. All rights reserved
//-----------------------------------------------------------------------------

#include "fitsio.h"

//-----------------------------------------------------------------------------
// Name: RFitsio_GetSize
// Desc: Get FITS image size.
//-----------------------------------------------------------------------------
void RFitsio_GetSize( long* plNumPixels, long* plWidth, long* plHeight, const char** ppszFileName )
{
	fitsfile *pFitsFile;
    int iStatus = 0, iFound;
	long alAxes[2];

	// Open FITS file.
    ffopen( &pFitsFile, ppszFileName[ 0 ], READONLY, &iStatus );

    // Get image width and height.
    ffgknj( pFitsFile, "NAXIS", 1, 2, alAxes, &iFound, &iStatus );

	// Number of pixels in the image.
    *plNumPixels = alAxes[ 1 ] != 0 ? alAxes[ 0 ] * alAxes[ 1 ] : alAxes[ 0 ];

    *plWidth     = alAxes[ 0 ];
    *plHeight    = alAxes[ 1 ];

	// Close FITS file.
    ffclos( pFitsFile, &iStatus );

} // end RFitsio_GetSize

//-----------------------------------------------------------------------------
// Name: RFitsio_ReadImage
// Desc: Read FITS image.
//-----------------------------------------------------------------------------
void RFitsio_ReadImage( float* pfBuffer, const long* plNumPixels, const char** ppszFileName )
{
	fitsfile *pFitsFile;
    int iStatus = 0, iAnyNul = 0;
	float fNulVal = 0;

	// Open FITS file.
    ffopen( &pFitsFile, ppszFileName[ 0 ], READONLY, &iStatus );

	// Read FITS file to pfBuffer.
    ffgpv( pFitsFile, TFLOAT, 1, *plNumPixels, &fNulVal, pfBuffer, &iAnyNul, &iStatus );

	// Close FITS file.
    ffclos( pFitsFile, &iStatus );

} // end RFitsio_ReadImage
