

// URL 체크 및 background로 전송
function checkAndSendUrl(url) {
	// .ts 파일만 체크
	if (!url.includes('.ts')) return;

	// 필터 조건 체크
	const isPstaticDomain = url.includes('.pstatic.net');
	const hasGliveClip = url.includes('glive-clip');
	const hasHls = url.includes('/hls/');
	const hasTsExtension = url.includes('.ts');

	
	

	if (isPstaticDomain && hasGliveClip && hasHls && hasTsExtension) {
		

		// Extension context가 유효한지 먼저 확인
		if (!chrome.runtime?.id) {
			
			return;
		}

		// background script로 전송
		try {
			chrome.runtime
				.sendMessage({
					type: 'HLS_SEGMENT_DETECTED',
					url: url
				})
				.then((response) => {
					
				})
				.catch((err) => {
					console.error('Failed to send message to background:', err);
				});
		} catch (err) {
			console.error('Error sending message:', err);
		}
	} else {
		
	}
}

// PerformanceObserver로 모든 네트워크 리소스 감지
const observer = new PerformanceObserver((list) => {
	for (const entry of list.getEntries()) {
		if (entry.entryType === 'resource') {
			const url = entry.name;

			// 모든 리소스 로깅 (디버깅용)
			// 

			// .ts 파일만 체크
			if (url.includes('.ts')) {
				
				checkAndSendUrl(url);
			}
		}
	}
});

// 리소스 타입 관찰 시작
observer.observe({ entryTypes: ['resource'] });


// 이미 로드된 리소스도 체크
const existingResources = performance.getEntriesByType('resource');

existingResources.forEach((entry) => {
	const url = entry.name;
	
	if (url.includes('.ts')) {
		
		checkAndSendUrl(url);
	}
});

// window 객체가 있는 경우에만 후킹 (content script 환경)
if (typeof window !== 'undefined') {
	// 원본 fetch 저장 (보조 수단)
	const originalFetch = window.fetch;
	const originalXHROpen = XMLHttpRequest.prototype.open;
	const originalXHRSend = XMLHttpRequest.prototype.send;

	// Fetch 후킹
	window.fetch = function (...args) {
		const url = args[0];

		if (typeof url === 'string') {
			
			checkAndSendUrl(url);
		}

		return originalFetch.apply(this, args);
	};

	// XMLHttpRequest 후킹
	XMLHttpRequest.prototype.open = function (method, url, ...rest) {
		this._url = url;
		return originalXHROpen.apply(this, [method, url, ...rest]);
	};

	XMLHttpRequest.prototype.send = function (...args) {
		if (this._url) {
			
			checkAndSendUrl(this._url);
		}
		return originalXHRSend.apply(this, args);
	};

	
}
