/**
 * A Single Page Application (SPA) for connecting to and managing deployed
 * bulletin boards.
 *
 * @packageDocumentation
 */
import './globals';

import React from 'react';
import ReactDOM from 'react-dom/client';
import { ThemeProvider } from '@mui/material';
import {
  toLedgerNetworkId,
  toRuntimeNetworkId,
  toZswapNetworkId,
  type NetworkId,
} from '@midnight-ntwrk/midnight-js-network-id';
import { setNetworkId } from '@midnight-ntwrk/compact-runtime';
import { setNetworkId as zwapSetNetworkId } from '@midnight-ntwrk/zswap';
import { setNetworkId as ledgerSetNetworkId } from '@midnight-ntwrk/ledger';
import App from './App';
import CssBaseline from '@mui/material/CssBaseline';
import { theme } from './config/theme';
import '@midnight-ntwrk/dapp-connector-api';
import * as pino from 'pino';
import { DeployedBoardProvider } from './contexts';

const networkId = import.meta.env.VITE_NETWORK_ID as NetworkId;

// Ensure that the network IDs are set within the Midnight libraries.
setNetworkId(toRuntimeNetworkId(networkId));
zwapSetNetworkId(toZswapNetworkId(networkId));
ledgerSetNetworkId(toLedgerNetworkId(networkId));

// Create a default `pino` logger and configure it with the configured logging level.
export const logger = pino.pino({
  level: import.meta.env.VITE_LOGGING_LEVEL as string,
});

logger.trace('networkId = ', networkId);

ReactDOM.createRoot(document.getElementById('root') as HTMLElement).render(
  <React.StrictMode>
    <CssBaseline />
    <ThemeProvider theme={theme}>
      <DeployedBoardProvider logger={logger}>
        <App />
      </DeployedBoardProvider>
    </ThemeProvider>
  </React.StrictMode>,
);
