-- Mike Sizer 2016
-- get current song from either spotify, itunes or soundcloud

if (application "Safari" is running) then
tell application "Safari"
set safari_windows to every window
repeat with safari_window in safari_windows
try
set soundcloud_tabs to (tabs of safari_window whose URL contains "soundcloud.com")

repeat with soundcloud_tab in soundcloud_tabs
set tabTitle to name of soundcloud_tab as string
if tabTitle contains "▶" or (tabTitle contains " by ") and tabTitle does not contain " | " then

if the character 1 of tabTitle is equal to "▶" then
set tabTitle to text 3 thru end of tabTitle as text
end if

return tabTitle
end if
end repeat
end try
end repeat
end tell
end if

if (application "Google Chrome" is running) then
tell application "Google Chrome"
set chrome_windows to every window
repeat with chrome_window in chrome_windows
try
set soundcloud_tabs to (tabs of chrome_window whose URL contains "soundcloud.com")

repeat with soundcloud_tab in soundcloud_tabs
set tabTitle to title of soundcloud_tab as string
if tabTitle contains "▶" or (tabTitle contains " by ") and tabTitle does not contain " | " then

if the character 1 of tabTitle is equal to "▶" then
set tabTitle to text 3 thru end of tabTitle as text
end if

return tabTitle
end if
end repeat
end try
end repeat
end tell
end if

if (application "iTunes" is running) then
tell application "iTunes"
if player state is playing then
set current_artist to artist of current track as string
set current_track to name of current track as string
return current_track & " by " & current_artist
end if
end tell
end if

if (application "Spotify" is running) then
tell application "Spotify"
if player state is playing then
set current_artist to artist of current track as string
set current_track to name of current track as string
return current_track & " by " & current_artist
end if
end tell
end if

return "false"