﻿<?php
	include_once('header.php');
	$gamesList = [];
	
	$message = "";
	$alert = "";
	if (!empty($_POST['action'])) {
		$name = $_POST["name"];
		if (empty($name)) {
			$message = $lang['fill_all_data'];
			$alert = "alert alert-danger";
		} else {
			$today = date('YmdHis');
			$rand = rand(0, $today);
			$token = "game" . substr($rand, -4);
			if ($stmt = $user_home->prepareQuery("INSERT INTO games(name, token) VALUES(?, ?)")) {
				$stmt->bind_param('ss', $name, $token);
				if ($stmt->execute()) {
					if ($stmt = $user_home->prepareQuery("CREATE TABLE IF NOT EXISTS {$token}_variables (
		  `game_id` int(11) NOT NULL,
		  `user_id` varchar(64) NOT NULL,
		  PRIMARY KEY (`user_id`),
		  UNIQUE KEY `user_id` (`user_id`),
		  KEY `game_id` (`game_id`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;")) {
						if ($stmt->execute()) {
							if ($stmt = $user_home->prepareQuery("ALTER TABLE `{$token}_variables` ADD CONSTRAINT `{$token}_variables` FOREIGN KEY (`game_id`) REFERENCES games(id) ON DELETE CASCADE ON UPDATE CASCADE;")) {
								if ($stmt->execute()) {
									$message = $lang['game_created'];
									$alert = "alert alert-success";
								}
							}
						}
					}
				} else {
					$message = $lang['database_error'];
					$alert = "alert alert-danger";
				}
			}
		}
	}
	
	if ($stmt = $user_home->runQuery("SELECT * FROM games")) {
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$gamesList[] = $row;
		}
	}
?>
	<div id="message" <?= ($message == '' ? 'style="display:none"' : ''); ?>>
		<div class="<?= $alert; ?> alert-dismissible fade show" role="alert" id="alert">
			<?= $message; ?>
			<button type="button" class="close" data-dismiss="alert" aria-label="<?= $lang['close']; ?>">
				<span aria-hidden="true">&times;</span>
			</button>
		</div>
	</div>
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<li class="breadcrumb-item"><a href="index.php"><?= $lang['dashboard']; ?></a></li>
		<li class="breadcrumb-item active" aria-current="page"><?= $lang['games']; ?></li>
	</ol>
</nav>
<div class="row">
	<div class="col-12">
		<div class="widget widget-table">
			<div class="widget-header">
				<i class="fas fa-gamepad"></i>
				<h3> <?= $lang['games']; ?></h3>
				<button type="button" onclick="document.querySelector('#addgame').scrollIntoView({ behavior: 'smooth' });" class="btn btn-success btn-sm"><i class="fas fa-plus-circle"></i>&nbsp;<?= $lang['add_game']; ?></button>
			</div>
			<div class="widget-content">
				<table class="table table-bordered table-striped table-hover"  id="paginated">
					<thead class="thead-inverse">
						<tr>
							<th width="5%"><?= $lang['id']; ?></th>
							<th width="20%"><?= $lang['name']; ?></th>
							<th width="15%"><?= $lang['token']; ?></th>
							<th class="td-actions" width="40%"></th>
							<th class="td-actions" width="20%"> </th>
						</tr>
					</thead>
					<tbody>
						<?php if(count($gamesList)==0) {
							echo '<tr><td colspan="5"><div class="alert alert-danger">'.$lang["no_game"].'</div></td></tr>';
						} ?>
						<?php foreach ($gamesList as $game) : ?>
						<tr id="row<?= $game['id']; ?>">
							<td style="font-size: 15px;"><?= $game['id']; ?></td>
							<td style="font-size: 15px;" id="name<?= $game['id']; ?>"><?= $game['name']; ?></td>
							<td style="text-align:left; direction: ltr; font-size: 15px;"><input type="text" id="token" value="<?= $game['token']; ?>" class="form-control" onclick="this.select();" readonly /></td>
							<td>
								<a href="variables.php?token=<?= $game['token']; ?>" class="btn btn-primary btn-sm"><i class="fab fa-fonticons"></i>&nbsp;&nbsp;<?= $lang['manage_variables']; ?></i></a>
								<a href="values.php?id=<?= $game['id']; ?>&token=<?= $game['token']; ?>" class="btn btn-primary btn-sm"><i class="fas fa-database"></i>&nbsp;&nbsp;<?= $lang['manage_values']; ?></i></a>
							</td>
							<td>
								<button type="button" class="btn btn-warning btn-sm" id="edit_button<?= $game['id']; ?>" onclick="edit_game('<?= $game['id']; ?>');"><i class="fas fa-edit"></i>&nbsp;&nbsp;<?= $lang['edit']; ?></button>
								<button type="button" class="btn btn-success btn-sm" style="display: none; margin-left: 3px;" id="save_button<?= $game['id']; ?>" onclick="save_game('<?= $game['id']; ?>');"><i class="fas fa-save"></i>&nbsp;&nbsp;<?= $lang['save']; ?></button>
								<button type="button" class="btn btn-danger btn-sm" id="delete_game<?= $game['id']; ?>"><i class="far fa-trash-alt"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></a>
<script type="text/javascript">
$('#delete_game<?= $game['id']; ?>').on("click", function () {
	$.confirm({
		title: "<?= $lang['delete']; ?> <?= $game['name']; ?>!",
		content: "<?= $lang['delete_game_question']; ?>",
		theme: 'bootstrap',
		buttons: {
			Yes: {
				text: "<?= $lang['yes']; ?>",
				btnClass: "btn-blue",
				keys: [
					"enter",
					"shift"
				],
				action: function () {
					delete_game("<?= $game['id']; ?>", "<?= $game['token']; ?>");
				}
			},
			Cancel: {
				text: "<?= $lang['cancel']; ?>",
				action: function () {}
			}
		}
	});
});
</script>
							</td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<div class="row">
		<div class="col-12">
			<div class="widget">
				<div class="widget-header"> <i class="fas fa-plus-circle"></i>
						<h3> <?= $lang['add_game']; ?></h3>
					</div>
					<div class="widget-content">
						<form action="" method="POST" id="addgame">
							<input type="hidden" id="action" name="action" value="create" />
							<div class="form-group">
								<label for="name"><?= $lang['name']; ?></label>
								<input type="text" id="name" class="form-control" name="name" required>
							</div>
							<button type="submit" class="btn btn-primary"><?=$lang['add']; ?></button>
						</form>
					</div>
				</div>
			</div>
	  </div>
<script type="text/javascript">
function delete_game(id, token) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteGame&id=" + id + "&token=" + token;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                document.getElementById("alert").innerHTML = "<?= $lang['game_deleted_success']; ?>";
                var row = document.getElementById("row" + id);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                document.getElementById("alert").innerHTML = "<?= $lang['game_deleted_failed']; ?>";
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}
var gameName;
function edit_game(id) {
	gameName = document.getElementById("name" + id).innerHTML;
	document.getElementById("name" + id).innerHTML = "<input type='text' class='form-control' id='name_text" + id + "' value='" + gameName + "'>";
	document.getElementById("edit_button" + id).style.display = "none";
	document.getElementById("save_button" + id).style.display = "inline-block";
}

function save_game(id) {
	var newname = document.getElementById("name_text" + id).value;

	if (window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	} else {
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	var url = "ajax.php?action=editGame&id=" + id + "&name=" + newname;

	xmlhttp.open("GET", url, true);
	xmlhttp.onreadystatechange = function () {
		if (this.readyState == 4 && this.status == 200) {
			document.getElementById("edit_button" + id).style.display = "inline-block";
			document.getElementById("save_button" + id).style.display = "none";
			document.getElementById("message").style.display = "block";
			if (xmlhttp.responseText == true) {
				document.getElementById("alert").className = "alert alert-success alert-dismissible fade show";
				document.getElementById("name" + id).innerHTML = newname;
				document.getElementById("alert").innerHTML = "<?= $lang['game_edit_success']; ?>";
			} else {
				document.getElementById("name" + id).innerHTML = gameName;
				document.getElementById("alert").className = "alert alert-danger alert-dismissible fade show";
				document.getElementById("alert").innerHTML = "<?= $lang['game_edit_failed']; ?>";
			}
			setTimeout(function () {
				$('#message').fadeOut('slow');
			}, 3000);
		}
	};
	xmlhttp.send();
}
</script>
<?php include_once('footer.php'); ?>