﻿<?php
	if (!isset($_SESSION)) {
	  session_start();
	}
	if (!file_exists('install/lock')) {
		header('Location: install/index.php?lang=en');
		return;
	}
	
	$available_langs = array('en','fa');
	
	if (isset($_SESSION['lang'])==false) {
		$_SESSION['lang'] = 'fa';
	}
	if(isset($_GET['lang']) && $_GET['lang'] != ''){
		if(in_array($_GET['lang'], $available_langs)) {
			unset($_SESSION['lang']);
			$_SESSION['lang'] = $_GET['lang'];
		}
	}
	$language = $_SESSION['lang'];
	
	include('language/'.$_SESSION['lang'].'.php');
	
	require_once 'include/class.user.php';
	$user_login = new USER();
	
	if($user_login->is_logged_in()!="") {
		$user_login->redirect('index.php');
	}

if(isset($_POST['btn-login'])) {
	$email = trim($_POST['txtemail']);
	$upass = trim($_POST['txtupass']);

	if($user_login->login($email,$upass)) {
		$user_login->redirect('index.php');
	}
}
?>

<!DOCTYPE html>
<html>
	<head>
		<title><?= $lang['login_title']; ?></title>
		<link href="assets/css/bootstrap.css" rel="stylesheet" media="screen">
		<link href="assets/css/signin-<?= $language; ?>.css" rel="stylesheet" media="screen">
		<link href="assets/css/balloon.css" rel="stylesheet"  type="text/css" />
		<script src="assets/js/ajax.js"></script>
	</head>
	<body>
		<div class="container">
			<div class="card card-container">
				<img id="profile-img" class="profile-img-card" src="assets/img/avatar_2x.png" />
				<p id="profile-name" class="profile-name-card"></p>
				<form class="form-signin" method="post">
					<?php if(isset($_GET['error'])) { ?>
						<div class='alert alert-danger'>
							<strong><?= $lang['login_failed']; ?></strong> 
						</div>
					<?php } ?>
					<span id="reauth-email" class="reauth-email"></span>
					<input type="text" class="form-control" placeholder="<?= $lang['email_or_username']; ?>" name="txtemail" required autofocus>
					<input type="password" class="form-control" placeholder="<?= $lang['password']; ?>" name="txtupass" required>
					<button class="btn btn-lg btn-primary btn-block btn-signin" name="btn-login" type="submit"><?= $lang['login']; ?></button>
				</form>
				<a href="forget.php" class="forgot-password"><?= $lang['lost_password']; ?></a>
			</div>
		</div>
		<div class="lang"><a href="login.php?lang=fa" data-balloon="<?= $lang['persian']; ?>" data-balloon-pos="right">فا</a>/ <a href="login.php?lang=en" data-balloon="<?= $lang['english']; ?>" data-balloon-pos="right">EN</a></div>
	</body>
</html>