<?php
	include_once("header.php");
	if(!$user_home->is_logged_in()) {
		$user_home->redirect('login.php');
	}
	$message = "";
	$alert = "";
	if (!empty($_POST['action'])) {
		$action = $_POST["action"];
		switch ($action) {
			case 'changepass':
				$current = $_POST["current"];
				$new = $_POST["new"];
				$confirm = $_POST["confirm"];
				if (empty($current) || empty($new) || empty($confirm)) {
					$message = $lang['fill_all_data'];
					$alert = "alert alert-danger";
				} else {
					$stmt = $user_home->prepareQuery("SELECT password FROM users WHERE id=?");
					$stmt->bind_param('i', $_SESSION['userId']);
					$stmt->execute();

					$stmt->store_result();
					$stmt->bind_result($password);
					$stmt->fetch();
					
					if ($stmt->num_rows == 1) {
						if ($password == md5($current)) {
							if ($new == $confirm) {
								$stmt = $user_home->prepareQuery("UPDATE users SET password=? WHERE id=?");
								$hash_new = md5($new);
								$stmt->bind_param('si', $hash_new, $_SESSION['userId']);
								$stmt->execute();
								$message = $lang['password_changed'];
								$alert = "alert alert-success";
							} else {
								$message = $lang['passwords_not_match'];
								$alert = "alert alert-danger";
							}
						} else {
							$message = $lang['current_password_error'];
							$alert = "alert alert-danger";
						}
					} else {
						$message = $lang['database_error'];
						$alert = "alert alert-danger";
					}
				}
				break;
			case 'details':
				$sitetitle = $_POST["sitename"];
				$username = $_POST["username"];
				$useremail = $_POST["email"];
				if (empty($sitetitle) || empty($username) || empty($useremail)) {
					$message = $lang['fill_all_data'];
					$alert = "alert alert-danger";
				} else {
					$stmt = $user_home->prepareQuery("UPDATE users SET username=?, email=?, sitename=? WHERE id=1");
					$stmt->bind_param('sss', $username, $useremail, $sitetitle);
					$stmt->execute();
					$message = $lang['details_changed'];
					$alert = "alert alert-success";
				}
				break;
		}
	}
?>
	<?php if (!empty($message)) { ?>
		<div id="message">
			<div class="<?= $alert ?> alert-dismissible fade show" role="alert" id="alert">
				<?= $message; ?>
				<button type="button" class="close" data-dismiss="alert" aria-label="<?= $lang['close']; ?>">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
		</div>
	<?php } ?>
	
		<div class="row">
			<div class="col">
				<div class="widget">
					<div class="widget-header"> <i class="fas fa-key"></i>
						<h3> <?= $lang['change_password']; ?></h3>
					</div>
					<div class="widget-content">
						<form action="" method="POST">
							<input type="hidden" name="action" value="changepass" />
							<div class="form-group">
								<label for="current"><?= $lang['current_password']; ?></label>
								<input type="password" id="current" class="form-control" name="current" required><br>
								<label for="new"><?= $lang['new_password']; ?></label>
								<input type="password" id="new" class="form-control" name="new" required><br>
								<label for="confirm"><?= $lang['confirm_password']; ?></label>
								<input type="password" id="confirm" class="form-control" name="confirm" required>
							</div>
							<button type="submit" class="btn btn-primary"><?=$lang['change_password']; ?></button>
						</form>
					</div>
				</div>
			</div>
			<div class="col">
				<div class="widget">
					<div class="widget-header"> <i class="fas fa-cog"></i>
						<h3> <?= $lang['change_details']; ?></h3>
					</div>
					<div class="widget-content">
						<form action="" method="POST">
							<input type="hidden" name="action" value="details" />
							<div class="form-group">
								<label for="sitename"><?= $lang['sitename']; ?></label>
								<input type="text" id="sitename" class="form-control" name="sitename" value="<?= $site_title; ?>" required><br>
								<label for="username"><?= $lang['admin_username']; ?></label>
								<input type="text" id="username" class="form-control" name="username" value="<?= $user_name; ?>" required><br>
								<label for="email"><?= $lang['admin_email']; ?></label>
								<input type="email" id="email" class="form-control" name="email" value="<?= $user_email; ?>" required>
							</div>
							<button type="submit" class="btn btn-primary"><?=$lang['change_details']; ?></button>
						</form>
					</div>
				</div>
			</div>
	  </div>
<?php include_once('footer.php'); ?>