﻿<?php
	include_once('header.php');
	
	if (!empty($_GET['token'])) {
		$token = $_GET['token'];
	} else {
		$user_home->redirect('games.php');
	}
	$message = "";
	$alert = "";
	if (!empty($_POST['action'])) {
		$action = $_POST['action'];
		if ($action == "add") {
			$edit = $_POST["edit"];
			$variable_key = $_POST["variable_key"];
			$variable_type = $_POST["variable_type"];
			$has_default = false;
			if (isset($_POST['variable_default'])) {
				$variable_default = $_POST["variable_default"];
				$has_default = true;
			}
			
			if (empty($variable_key)) {
				$message = $lang['fill_all_data'];
				$alert = "alert alert-danger";
			} else {
				if ($edit == 0) {
					try {
						$sql_query = "ALTER TABLE `" . $token . "_variables` ADD $variable_key $variable_type NOT NULL";
						if($has_default) {
							$sql_query .= " DEFAULT '$variable_default'";
						}
						if ($stmt = $user_home->prepareQuery($sql_query)) {
							if ($stmt->execute()) {
								$message = $lang['add_variable_success'];
								$alert = "alert alert-success";
							} else {
								$message = $lang['database_error'];
								$alert = "alert alert-danger";
							}
						} else {
							$message = $lang['database_error'];
							$alert = "alert alert-danger";
						}
					} catch (Exception $e) {
						if (strpos($e->getMessage(), 'Duplicate') !== false) {
							$message = $lang['duplicate_variable_error'];
						} else {
							$message = $lang['database_error'];
						}
						$alert = "alert alert-danger";
					}
				} else {
					$edit_key = $_POST["edit_key"];
					$sql_query2 = "ALTER TABLE `" . $token . "_variables` CHANGE $edit_key $variable_key $variable_type";
					if($has_default) {
						$sql_query2 .= " DEFAULT '$variable_default'";
					}
					if ($stmt = $user_home->prepareQuery($sql_query2)) {
						if ($stmt->execute()) {
							$message = $lang['edit_variable_success'];
							$alert = "alert alert-success";
						} else {
							$message = $lang['database_error'];
							$alert = "alert alert-danger";
						}
					} else {
						$message = $lang['database_error'];
						$alert = "alert alert-danger";
					}
				}
			}
		} else if ($action == "delete") {
			$delete_key = $_POST["key"];
			if ($stmt = $user_home->prepareQuery("ALTER TABLE `" . $token . "_variables` DROP $delete_key")) {
				if ($stmt->execute()) {
					$message = $lang['delete_variable_success'];
					$alert = "alert alert-success";
				} else {
					$message = $lang['database_error'];
					$alert = "alert alert-danger";
				}
			} else {
				$message = $lang['database_error'];
				$alert = "alert alert-danger";
			}
		}
	}
	
	$sql1 = "SELECT id, name FROM games WHERE token= ?";
	
	if ($stmt = $user_home->prepareQuery($sql1)) {
		$stmt->bind_param('s', $token);
		$stmt->execute();

		$stmt->store_result();
		$stmt->bind_result($gameId, $gameName);
		$stmt->fetch();
		$stmt->free_result();
	}
	
	$fields = array();
	$types = array();
	$defaults = array();
	
	if ($stmt = $user_home->runQuery("SHOW COLUMNS FROM " . $token . "_variables")) {
		$i = 0;
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$fields[$i] = $row['Field'];
			$types[$i] = $row['Type'];
			$defaults[$i] = $row['Default'];
			$i++;
		}
	}
?>
	<?php if (!empty($message)) { ?>
		<div id="message">
			<div class="<?= $alert; ?> alert-dismissible fade show" role="alert" id="alert">
				<?= $message; ?>
				<button type="button" class="close" data-dismiss="alert" aria-label="<?= $lang['close']; ?>">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
		</div>
	<?php } ?>
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<li class="breadcrumb-item"><a href="index.php"><?= $lang['dashboard']; ?></a></li>
		<li class="breadcrumb-item"><a href="games.php"><?= $lang['games']; ?></a></li>
		<li class="breadcrumb-item active" aria-current="page"><?= sprintf($lang['manage_variables_title'], $gameName); ?></li>
	</ol>
</nav>
      <div class="row">
			<div class="col-12">
				<div class="widget widget-table">
					<div class="widget-header"> <i class="fab fa-fonticons"></i>
						<h3> <?= sprintf($lang['manage_variables_title'], $gameName); ?></h3>
						<button type="button" onclick="document.querySelector('#addvariable').scrollIntoView({ behavior: 'smooth' });" class="btn btn-success btn-sm"><i class="fas fa-plus-circle"></i>&nbsp;<?= $lang['add_variable']; ?></button>
						<a href="values.php?id=<?= $gameId; ?>&token=<?= $token; ?>#addvalue" class="btn btn-success btn-sm" style="margin: 0 3px;"><i class="fas fa-plus-circle"></i>&nbsp;<?= $lang['add_value']; ?></a>
					</div>
					<div class="widget-content">
						<table class="table table-striped table-hover table-variables" style="overflow-y: hidden">
							<thead class="thead-inverse">
                                <tr>
                                    <th width="30%"><?= $lang['variable_key']; ?></th>
                                    <th width="10%"><?= $lang['variable_type']; ?></th>
                                    <th width="40%"><?= $lang['variable_default']; ?></th>
									<th width="20%"></th>
                                </tr>
							</thead>
							<tbody>
<?php
	if(count($fields)==2) {
		echo '<tr><td colspan="4" id="no_variable"><div class="alert alert-danger">'.$lang["no_variable"].'</div></td></tr>';
	} else {
		$count = count($fields);
		for ($x = 2; ($x < $count); $x++) {
			$v_type = "String";
			$v_default = $defaults[$x];
			if (strpos($types[$x], 'int(11)') !== false) {
				$v_type = "Integer";
			} else if (strpos($types[$x], 'text') !== false) {
				$v_type = "Text";
			} else if (strpos($types[$x], 'tinyint') !== false) {
				$v_type = "Boolean";
				switch($v_default) {
					case 0:
						$v_default = "false";
						break;
					case 1:
						$v_default = "true";
						break;
				}
			}
?>
	<tr>
		<td><?= $fields[$x]; ?></td>
		<td><?= $v_type; ?></td>
		<td><?= $v_default; ?></td>
		<td>
			<form action="" id="delete_variable_<?= $fields[$x]; ?>" method="POST">
				<button type="button" class="btn btn-warning btn-sm" onclick="edit_variable('<?= $fields[$x]; ?>', '<?= $types[$x]; ?>', '<?= $defaults[$x]; ?>');"><i class="fas fa-edit"></i>&nbsp;&nbsp;<?= $lang['edit']; ?></button>
				<input type="hidden" id="action" name="action" value="delete" />
				<input type="hidden" id="key" name="key" value="<?= $fields[$x]; ?>" />
				<button type="submit" id="delete" class="btn btn-danger btn-sm"><i class="far fa-trash-alt"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></button>
			</form>
<script type="text/javascript">
$(function() {
	$('#delete_variable_<?= $fields[$x]; ?>').submit(function(event) {
		event.preventDefault();
		var form = $(this)[0];

		$.confirm({
			theme: 'white',
			title: "<?= $lang['delete']; ?> <?= $fields[$x]; ?>!",
			content: "<?= $lang['delete_variable_question']; ?>",
			buttons: {
				Yes: {
					text: "<?= $lang['yes']; ?>",
					btnClass: "btn-blue",
					action: function () {
						form.submit();
					}
				},
				Cancel: {
					text: "<?= $lang['cancel']; ?>",
					action: function () {}
				}
			}
		});
	});
});
</script>
		</td>
	</tr>
<?php
		} 
	}
?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
      <div class="row">
			<div class="col-12">
				<div class="widget">
					<div class="widget-header"> <i class="fas fa-plus-circle"></i>
						<h3> <?= $lang['add_variable']; ?></h3>
					</div>
					<div class="widget-content">
						<form action="" method="POST" id="addvariable">
							<input type="hidden" id="action" name="action" value="add" />
							<input type="hidden" id="edit" name="edit" value="0" />
							<input type="hidden" id="edit_key" name="edit_key" value="0" />
							<div class="row">
								<div class="form-group col-md-4">
									<label for="variable_key"><?= $lang['variable_key']; ?></label>
									<input type="text" id="variable_key" class="form-control" name="variable_key" required>
								</div>
								<div class="form-group col-md-2">
									<label for="variable_type"><?= $lang['variable_type']; ?></label>
									<select name="variable_type" id="variable_type" class="custom-select" style="width: 100%">
										<option value="varchar(255)">String</option>
										<option value="text">Text</option>
										<option value="int(11)">Integer</option>
										<option value="tinyint(1)">Boolean</option>
									</select>
								</div>
								<div class="form-group col-md-6" id="default_val">
									<label for="variable_default"><?= $lang['variable_default']; ?></label>
									<input type="text" id="variable_default" class="form-control" name="variable_default" required>
								</div>
							</div>
							<button type="submit" id="btn-add" class="btn btn-primary"><?= $lang['add']; ?></button>
							<button type="button" class="btn btn-danger" id="canceledit" style="display:none;" onclick="cancel_edit()"><?=$lang['cancel']; ?></button>
						</form>
					</div>
				</div>
			</div>
	  </div>
<script type="text/javascript">
$(document).ready(function() {
    $('.table').DataTable({
        "order": []
    });
    $('.table').parent().addClass('table-responsive');
	var variable_type = $("#variable_type").val();
	setType(variable_type);
	
	$("#variable_type").change(function () {
        var val = $(this).val();
        setType(val);
    });
});
function setType(val) {
	if (val == "varchar(255)") {
		$("#default_val").html('<label for="variable_default"><?= $lang['variable_default']; ?></label><input type="text" id="variable_default" class="form-control" name="variable_default" required>');
	} else if (val == "text") {
		$("#default_val").html('<label for="variable_default"><?= $lang['variable_default']; ?></label><textarea type="text" id="variable_default" class="form-control" disabled></textarea>');
	} else if (val == "int(11)") {
		$("#default_val").html('<label for="variable_default"><?= $lang['variable_default']; ?></label><input type="number" value="0" id="variable_default" class="form-control" name="variable_default" required>');
	} else if (val == "tinyint(1)") {
		$("#default_val").html('<label for="variable_default"><?= $lang['variable_default']; ?></label><select name="variable_default" id="variable_default" class="custom-select" style="width: 100%"><option value="1">True</option><option value="0">False</option></select>');
	}
}
function edit_variable(key, type, def) {
	$("#btn-add").text("<?= $lang['edit']; ?>");
	$("#canceledit").css("display", "inline-block");
	$("#edit").val("1");
	$("#edit_key").val(key);
	$("#variable_key").val(key);
	$("#variable_type").val(type).change();
	setType(type);
	$("#variable_default").val(def);
	document.querySelector('#addvariable').scrollIntoView({ behavior: 'smooth' });
}
function cancel_edit() {
	$("#edit").val("0");
	$("#edit_key").val("0");
	$("#variable_key").val("");
	$("#canceledit").css("display", "none");
	$("#btn-add").text("<?= $lang['add_variable']; ?>");
	$("#variable_type").val("varchar(255)");
	setType("varchar(255)");
	$("#variable_default").val("");
	document.querySelector('.table').scrollIntoView({ behavior: 'smooth' });
}
</script>
<?php include_once('footer.php'); ?>