<?php
	ob_start();
	if (!isset($_SESSION)) {
	  session_start();
	}
	if (!file_exists('install/lock')) {
		header('Location: install/index.php?lang=en');
		return;
	}

	$available_langs = array('en','fa');

	if (isset($_SESSION['lang'])==false) {
		$_SESSION['lang'] = 'fa';
	}
	if(isset($_GET['lang']) && $_GET['lang'] != ''){
		if(in_array($_GET['lang'], $available_langs)) {
			unset($_SESSION['lang']);
			$_SESSION['lang'] = $_GET['lang'];
		}
	}
	$language = $_SESSION['lang'];

	include('language/'.$_SESSION['lang'].'.php');

	require_once 'include/class.user.php';

	$user_home = new USER();
	$site_url = "";
	
	if ($stmt = $user_home->runQuery("SELECT * FROM users WHERE id=1")) {
		while ($rowa = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$site_url = $rowa['url'];
			$user_email = $rowa['email'];
			$user_name = $rowa['username'];
			$site_title = $rowa['sitename'];
			$version = $rowa['version'];
		}
	}
	
	if (strpos($_SERVER['REQUEST_URI'], 'settings') !== false) {
		$title = $lang['settings'].' - '.$site_title;
	} else if (strpos($_SERVER['REQUEST_URI'], 'admin') !== false) {
		$title = $lang['dashboard'].' - '.$site_title;
	} else if (strpos($_SERVER['REQUEST_URI'], 'update') !== false) {
		$title = $lang['update'].' - '.$site_title;
	} else if (strpos($_SERVER['REQUEST_URI'], 'games') !== false) {
		$title = $lang['games'].' - '.$site_title;
	} else if (strpos($_SERVER['REQUEST_URI'], 'variables') !== false) {
		$title = $lang['manage_variables'].' - '.$site_title;
	} else if (strpos($_SERVER['REQUEST_URI'], 'values') !== false) {
		$title = $lang['manage_values'].' - '.$site_title;
	} else {
		$title = $site_title;
	}
	
	if(!$user_home->is_logged_in()) {
		$user_home->redirect('login.php');
	}
?>
    <!DOCTYPE html>
    <html lang="<?= $language; ?>">

    <head>
        <meta charset="utf-8">
        <title>
            <?= $title; ?>
        </title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
        <meta name="apple-mobile-web-app-capable" content="yes">
		<link rel="icon" type="image/png" href="assets/img/favicon.ico">
        <link href="assets/css/tether.css" rel="stylesheet">
        <link href="assets/css/bootstrap.css" rel="stylesheet">
        <link href="assets/css/font-awesome-all.min.css" rel="stylesheet">
        <link href="assets/css/style-<?= $language; ?>.css" rel="stylesheet">
        <link href="assets/css/jquery-confirm.css" rel="stylesheet" type="text/css" />
        <link href="assets/css/balloon.css" rel="stylesheet" type="text/css" />
        <link href="assets/css/jquery.dataTables-<?= $language; ?>.css" rel="stylesheet" type="text/css" />
        <script src="assets/js/jquery-3.2.1.min.js"></script>
        <script src="assets/js/tether.js"></script>
        <script src="assets/js/bootstrap.js"></script>
        <script src="assets/js/ajax.js"></script>
        <script src="assets/js/jquery-confirm.js"></script>
        <script src="assets/js/jquery.jeditable.js"></script>
        <script src="assets/js/jquery.dataTables.min-<?= $language; ?>.js"></script>
        <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    </head>

    <body>
		<nav class="navbar navbar-toggleable-md navbar-inverse bg-inverse sticky-top">
            <button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" data-target="#navbarText" aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <a class="navbar-brand" href="index.php">
                <img src="assets/img/logo.png" alt="OnStorage"><?= $lang['onstorage']; ?>
            </a>
            <div class="collapse navbar-collapse" id="navbarText">
                <ul class="navbar-nav <?php if ($language=='fa') {echo 'ml-auto';} else {echo 'mr-auto';} ?>">
						<li class="nav-item <?php if ((strpos($_SERVER['REQUEST_URI'], 'index') !== false) or (strpos($_SERVER['REQUEST_URI'], '.php') == false)) {echo 'active';} ?>">
                            <a class="nav-link" href="index.php"><i class="fas fa-tachometer-alt"></i> <?= $lang['dashboard']; ?></a>
                        </li>
                        <li class="nav-item <?php if ((strpos($_SERVER['REQUEST_URI'], 'games') !== false) or (strpos($_SERVER['REQUEST_URI'], 'variables') !== false) or (strpos($_SERVER['REQUEST_URI'], 'values') !== false)) {echo 'active';} ?>">
                            <a class="nav-link" href="games.php"><i class="fas fa-gamepad"></i> <?= $lang['games']; ?></a>
                        </li>
                        <li class="nav-item <?php if (strpos($_SERVER['REQUEST_URI'], 'settings') !== false) {echo 'active';} ?>">
                            <a class="nav-link" href="settings.php"><i class="fas fa-cog"></i> <?= $lang['settings']; ?></a>
                        </li>
						<?php if (file_exists('update.php')) { ?>
							<li class="nav-item <?php if (strpos($_SERVER['REQUEST_URI'], 'update') !== false) {echo 'active';} ?>">
								<a class="nav-link" href="update.php"><i class="fas fa-sync-alt fa-spin"></i> <?= $lang['update']; ?></a>
							</li>
						<?php } ?>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt"></i> <?= $lang['logout']; ?></a>
                        </li>
                </ul>
                <span class="navbar-text">
		<?php if ($language=='en') {?>
			<a href="<?php if (strpos($_SERVER['REQUEST_URI'], '?') !== false) {if (strpos($_SERVER['REQUEST_URI'], '&lang=en') === false) {echo $_SERVER['REQUEST_URI'].'&lang=fa';} else {echo str_replace('lang=en','lang=fa',$_SERVER['REQUEST_URI']);}} else {echo '?lang=fa';} ?>"><i class="fas fa-language"></i> <?= $lang['persian']; ?></a>
		<?php } else { ?>
			<a href="<?php if (strpos($_SERVER['REQUEST_URI'], '?') !== false) {if (strpos($_SERVER['REQUEST_URI'], '&lang=fa') === false) {echo $_SERVER['REQUEST_URI'].'&lang=en';} else {echo str_replace('lang=fa','lang=en',$_SERVER['REQUEST_URI']);}} else {echo '?lang=en';} ?>"><i class="fas fa-language"></i> <?= $lang['english']; ?></a>
		<?php } ?>
    </span>
            </div>
        </nav> 
        <div class="container">