﻿<?php
	if (!isset($_SESSION)) {
	  session_start();
	}
	if (!file_exists('install/lock')) {
		header('Location: install/index.php?lang=en');
		return;
	}
	
	$available_langs = array('en','fa');
	
	if (isset($_SESSION['lang'])==false) {
		$_SESSION['lang'] = 'fa';
	}
	if(isset($_GET['lang']) && $_GET['lang'] != ''){
		if(in_array($_GET['lang'], $available_langs)) {
			unset($_SESSION['lang']);
			$_SESSION['lang'] = $_GET['lang'];
		}
	}
	$language = $_SESSION['lang'];
	
	include('language/'.$_SESSION['lang'].'.php');
	
	require_once 'include/class.user.php';
	$user = new USER();
	
	if($user->is_logged_in()!="") {
		$user->redirect('index.php');
	}

if(isset($_POST['btn-submit'])) {
	$email = $_POST['txtemail'];
	
	$stmt = $user->prepareQuery("SELECT url, username FROM users WHERE id=1 LIMIT 1");
	$stmt->execute();
	$stmt->store_result();
	$stmt->bind_result($site_url, $username);
	$stmt->fetch();
	
	$stmt = $user->prepareQuery("SELECT id FROM users WHERE email=? LIMIT 1");
	$stmt->bind_param('s', $email);
	$stmt->execute();
	$stmt->store_result();
	$stmt->bind_result($userId);
	$stmt->fetch();
	if($stmt->num_rows == 1) {
		$id = base64_encode($userId);
		$code = md5(uniqid(rand()));
		
		$stmt = $user->prepareQuery("UPDATE users SET token=? WHERE email=?");
		$stmt->bind_param('ss', $code, $email);
		$stmt->execute();
		$reset_link = $site_url."resetpass.php?id=".$id."&code=".$code;
		
		$message = sprintf($lang['reset_email_message'], $username, $reset_link);
		$subject = $lang['reset_email_subject'];
		
		$user->send_mail($email,$message,$subject);
		$msg = "<div class='alert alert-success'>".sprintf($lang['forget_success'], $email)."</div>";
	} else {
		$msg = "<div class='alert alert-danger'>".$lang['forget_error']."</div>";
	}
}
?>
<html>
	<head>
		<title><?= $lang['forget_title']; ?></title>
		<link href="assets/css/bootstrap.css" rel="stylesheet" media="screen">
		<link href="assets/css/signin-<?= $language; ?>.css" rel="stylesheet" media="screen">
		<link href="assets/css/balloon.css" rel="stylesheet"  type="text/css" />
		<script src="assets/js/ajax.js"></script>
	</head>
	<body>
		<div class="container">
			<div class="card card-container">
				<img id="profile-img" class="profile-img-card" src="assets/img/avatar_2x.png" />
				<p id="profile-name" class="profile-name-card"></p>
				<form class="form-signin" method="post">
					<?php if(isset($msg)) { ?>
						<?= $msg; ?>
					<?php } ?>
					<span id="reauth-email" class="reauth-email"></span>
					<input type="email" class="form-control" placeholder="<?= $lang['email']; ?>" name="txtemail" required autofocus>
					<button class="btn btn-lg btn-primary btn-block btn-signin" name="btn-submit" type="submit"><?= $lang['get_password']; ?></button>
				</form>
				<a href="login.php" class="forgot-password"><?= $lang['login_title']; ?></a>
			</div>
		</div>
		<div class="lang"><a href="forget.php?lang=fa" data-balloon="<?= $lang['persian']; ?>" data-balloon-pos="right">فا</a>/ <a href="forget.php?lang=en" data-balloon="<?= $lang['english']; ?>" data-balloon-pos="right">EN</a></div>
	</body>
</html>