﻿<?php

class Install {

	public $message = "";
	public $alert = "";
	
    public function __construct() {
        if ($_SERVER['REQUEST_METHOD'] === "POST") {
            $this->checkAction();
        }
    }
	
    private function checkAction() {
		if(strpos($_SERVER['REQUEST_URI'], 'fa') !== false){
			include("../language/fa.php");
		} else {
			include("../language/en.php");
		}
        if (!empty($_POST['action'])) {
            $action = filter_var($_POST['action'], FILTER_SANITIZE_STRING);
            switch ($action) {
                case "new":
					$siteurl = filter_var($_POST["siteurl"], FILTER_SANITIZE_STRING);
                    if (!empty($_POST["dbhostname"])) {
                        $dbhostname = filter_var($_POST["dbhostname"], FILTER_SANITIZE_STRING);
                    }
                    if (!empty($_POST["dbusername"])) {
                        $dbusername = filter_var($_POST["dbusername"], FILTER_SANITIZE_STRING);
                    }
					$dbpassword = filter_var($_POST["dbpassword"], FILTER_SANITIZE_STRING);
                    if (!empty($_POST["dbdatabase"])) {
                        $dbdatabase = filter_var($_POST["dbdatabase"], FILTER_SANITIZE_STRING);
                    }
                    if (!empty($_POST["adminusername"])) {
                        $adminusername = filter_var($_POST["adminusername"], FILTER_SANITIZE_STRING);
                    }
                    if (!empty($_POST["adminemail"])) {
                        $adminemail = filter_var($_POST["adminemail"], FILTER_VALIDATE_EMAIL);
                    }
                    if (!empty($_POST["adminpassword"])) {
                        $adminpassword = filter_var($_POST["adminpassword"], FILTER_SANITIZE_STRING);
                    }
                    if (!empty($_POST["sitename"])) {
                        $sitename = filter_var($_POST["sitename"], FILTER_SANITIZE_STRING);
                    }
                    
                    if (empty($dbhostname) || empty($dbusername) || empty($dbdatabase) || empty($adminusername) || empty($adminemail) || empty($adminpassword) || empty($siteurl) || empty($sitename)) {
                        $this->message = $lang['fill_all_data'];
						$this->alert = "alert alert-danger";
						return;
                    } else {
                        $this->install($dbhostname, $dbusername, $dbpassword, $dbdatabase, $adminusername, $adminemail, $adminpassword, $siteurl, $sitename);
                    }
                    
                    break;

                case "upgrade":

                    break;
            }
        } else if (!empty($_GET["action"])) {
            $action = filter_var($_GET['action'], FILTER_SANITIZE_STRING);
            switch ($action) {
            }
        }
    }

    private function install($dbhostname, $dbusername, $dbpassword, $dbdatabase, $adminusername, $adminemail, $adminpassword, $siteurl, $sitename) {
		if(strpos($_SERVER['REQUEST_URI'], 'fa') !== false){
			include("../language/fa.php");
		} else {
			include("../language/en.php");
		}
       error_reporting(E_ALL ^ E_WARNING ^ E_NOTICE);
	   $mysql = new \mysqli($dbhostname, $dbusername, $dbpassword, $dbdatabase);

		if ($mysql->connect_error) {
			$this->message = $lang['database_error'];
			$this->alert = "alert alert-danger";
			return;
		}

        if ($mysql) {
            
            $templine = '';
            $lines = file('db.sql');

            foreach ($lines as $line) {
                if (substr($line, 0, 2) == '--' || $line == '')
                    continue;

                $templine .= $line;
                if (substr(trim($line), -1, 1) == ';') {
                    $mysql->query($templine);
                    $templine = '';
                }
            }

			$fp = fopen("lock","wb");
			fwrite($fp, "www.miladesign.ir");
			fclose($fp);
			
            $file = file_get_contents("../include/dbconfig.php");

            $file = str_replace("__DBHOSTNAME__", $dbhostname, $file);
            $file = str_replace("__DBUSERNAME__", $dbusername, $file);
            $file = str_replace("__DBPASSWORD__", $dbpassword, $file);
            $file = str_replace("__DBDATABASE__", $dbdatabase, $file);

            file_put_contents("../include/dbconfig.php", $file);
			
			require_once 'class.user.php';
			$user_home = new USER();
            $user_home->register($adminusername, $adminemail, $adminpassword, $siteurl, $sitename, $mysql);
			
			if (file_exists('../update.php')) {
				unlink("../update.php");
			}
			$this->message = $lang['install_success'];
			$this->alert = "alert alert-success";
			header( "Refresh: 2; url=../index.php");
        }
    }

    private function upgrade() {

    }
}