﻿<?php
	if (!isset($_SESSION)) {
	  session_start();
	}
	if (!file_exists('install/lock')) {
		header('Location: install/index.php?lang=en');
		return;
	}
	
	$available_langs = array('en','fa');
	
	if (isset($_SESSION['lang'])==false) {
		$_SESSION['lang'] = 'fa';
	}
	if(isset($_GET['lang']) && $_GET['lang'] != ''){
		if(in_array($_GET['lang'], $available_langs)) {
			unset($_SESSION['lang']);
			$_SESSION['lang'] = $_GET['lang'];
		}
	}
	$language = $_SESSION['lang'];
	
	include('language/'.$_SESSION['lang'].'.php');
require_once 'include/class.user.php';
$user = new USER();

if(empty($_GET['id']) && empty($_GET['code'])) {
	$user->redirect('login.php');
}

if(isset($_GET['id']) && isset($_GET['code'])) {
	$id = base64_decode($_GET['id']);
	$code = $_GET['code'];
	
	$stmt = $user->prepareQuery("SELECT id, username FROM users WHERE id=? AND token=?");
	$stmt->bind_param('is', $id, $code);
	$stmt->execute();
	$stmt->store_result();
	$stmt->bind_result($userId, $username);
	$stmt->fetch();
	if($stmt->num_rows == 1) {
		if(isset($_POST['btn-reset-pass'])) {
			$pass = $_POST['pass'];
			$cpass = $_POST['confirm-pass'];
			
			if($cpass!==$pass) {
				$msg = "<div class='alert alert-danger'>".$lang['passwords_not_match']."</div>";
			} else {
				$password = md5($cpass);
				$stmt = $user->prepareQuery("UPDATE users SET password=? WHERE id=?");
				$stmt->bind_param('si', $password, $userId);
				$stmt->execute();
				
				$msg = "<div class='alert alert-success'>".$lang['password_changed']."</div>";
				header("refresh:2;login.php");
			}
		}	
	} else {
		$msg = "<div class='alert alert-danger'>".$lang['reset_error']."</div>";
	}
}
?>
<html>
	<head>
		<title><?= $lang['reset_title']; ?></title>
		<link href="assets/css/bootstrap.css" rel="stylesheet" media="screen">
		<link href="assets/css/signin-<?= $language; ?>.css" rel="stylesheet" media="screen">
		<link href="assets/css/balloon.css" rel="stylesheet"  type="text/css" />
		<script src="assets/js/ajax.js"></script>
	</head>
	<body>
		<div class="container">
			<div class="card card-container">
				<img id="profile-img" class="profile-img-card" src="assets/img/avatar_2x.png" />
				<p id="profile-name" class="profile-name-card"></p>
				<div class='alert alert-info'>
					<strong><?= $lang['hello']; ?></strong> <?php echo $username; ?>! <?= $lang['reset_info']; ?>
				</div>
				<form class="form-signin" method="post">
					<?php if(isset($msg)) { ?>
						<?= $msg; ?>
					<?php } ?>
					<span id="reauth-email" class="reauth-email"></span>
					<input type="password" class="form-control" placeholder="<?= $lang['new_password']; ?>" name="pass" required autofocus>
					<input type="password" class="form-control" placeholder="<?= $lang['confirm_password']; ?>" name="confirm-pass" required>
					<button class="btn btn-lg btn-primary btn-block btn-signin" name="btn-reset-pass" type="submit"><?= $lang['reset_title']; ?></button>
				</form>
				<a href="login.php" class="forgot-password"><?= $lang['login_title']; ?></a>
			</div>
		</div>
		<div class="lang"><a href="resetpass.php?lang=fa&id=<?= $_GET['id']; ?>&code=<?= $_GET['code']; ?>" data-balloon="<?= $lang['persian']; ?>" data-balloon-pos="right">فا</a>/ <a href="resetpass.php?lang=en&id=<?= $_GET['id']; ?>&code=<?= $_GET['code']; ?>" data-balloon="<?= $lang['english']; ?>" data-balloon-pos="right">EN</a></div>
	</body>
</html>