(function($) {
   "use strict"


 var dlabChartlist = function(){
	
	var screenWidth = $(window).width();

	var MemUsage =0.0;
	var CpuUsage =0.0;
	var DiskUsage =0.0;
	var realTimeTcpCnt =0.0;

	var flotBar1 = function(){
		$.plot("#flotBar1", [{
			data: [[0, 3], [2, 8], [4, 5], [6, 13], [8, 5], [10, 7], [12, 4], [14, 6]]
		}], {
			series: {
				bars: {
					show: true,
					lineWidth: 0,
					fillColor: '#FFA7D7'
				}
			},
			grid: {
				borderWidth: 1,
				borderColor: 'transparent'
			},
			yaxis: {
				tickColor: 'transparent',
				font: {
					color: '#fff',
					size: 10
				}
			},
			xaxis: {
				tickColor: 'transparent',
				font: {
					color: '#fff',
					size: 10
				}
			}
		});
	}
	
	var flotBar2 = function(){
		$.plot("#flotBar2", [{
			data: [[0, 3], [2, 8], [4, 5], [6, 13], [8, 5], [10, 7], [12, 8], [14, 10]],
			bars: {
				show: true,
				lineWidth: 0,
				fillColor: '#FFA7D7'
			}
		}, {
			data: [[1, 5], [3, 7], [5, 10], [7, 7], [9, 9], [11, 5], [13, 4], [15, 6]],
			bars: {
				show: true,
				lineWidth: 0,
				fillColor: '#ffaa2b'
			}
		}], 
		{
			grid: {
				borderWidth: 1,
				borderColor: 'transparent'
			},
			yaxis: {
				tickColor: 'transparent',
				font: {
					color: '#fff',
					size: 10
				}
			},
			xaxis: {
				tickColor: 'transparent',
				font: {
					color: '#fff',
					size: 10
				}
			}
		});
	}
	
	var flotLine1 = function(){
		var newCust = [[0, 2], [1, 3], [2, 6], [3, 5], [4, 7], [5, 8], [6, 10]];
		var retCust = [[0, 1], [1, 2], [2, 5], [3, 3], [4, 5], [5, 6], [6, 9]];

		var plot = $.plot($('#flotLine1'), [
			{
				data: newCust,
				label: 'New Customer',
				color: '#FFA7D7'
			},
			{
				data: retCust,
				label: 'Returning Customer',
				color: '#ffaa2b'
			}
		],
		{
			series: {
				lines: {
					show: true,
					lineWidth: 1
				},
				shadowSize: 0
			},
			points: {
				show: false,
			},
			legend: {
				noColumns: 1,
				position: 'nw'
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderColor: '#ddd',
				borderWidth: 0,
				labelMargin: 5,
				backgroundColor: 'transparent'
			},
			yaxis: {
				min: 0,
				max: 15,
				color: 'transparent',
				font: {
					size: 10,
					color: '#999'
				}
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#999'
				}
			}
		});
	}
	
	var flotLine2 = function(){
		var newCust = [[0, 2], [1, 3], [2, 6], [3, 5], [4, 7], [5, 8], [6, 10]];
		var retCust = [[0, 1], [1, 2], [2, 5], [3, 3], [4, 5], [5, 6], [6, 9]];
		
		var plot = $.plot($('#flotLine2'), [
			{
				data: newCust,
				label: 'New Customer',
				color: '#FFA7D7'
			},
			{
				data: retCust,
				label: 'Returning Customer',
				color: '#ffaa2b'
			}
		],
		{
			series: {
				lines: {
					show: false
				},
				splines: {
					show: true,
					tension: 0.4,
					lineWidth: 1,
					//fill: 0.4
				},
				shadowSize: 0
			},
			points: {
				show: false,
			},
			legend: {
				noColumns: 1,
				position: 'nw'
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderColor: '#ddd',
				borderWidth: 0,
				labelMargin: 5,
				backgroundColor: 'transparent'
			},
			yaxis: {
				min: 0,
				max: 15,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});		
	}
	
	var flotLine3 = function(){
		var newCust2 = [[0, 10], [1, 7], [2, 8], [3, 9], [4, 6], [5, 5], [6, 7]];
		var retCust2 = [[0, 8], [1, 5], [2, 6], [3, 8], [4, 4], [5, 3], [6, 6]];
		
		var plot = $.plot($('#flotLine3'), [
			{
				data: newCust2,
				label: 'New Customer',
				color: '#FFA7D7'
			},
			{
				data: retCust2,
				label: 'Returning Customer',
				color: '#ffaa2b'
			}
		],
		{
			series: {
				lines: {
					show: true,
					lineWidth: 1
				},
				shadowSize: 0
			},
			points: {
				show: true,
			},
			legend: {
				noColumns: 1,
				position: 'nw'
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderColor: '#ddd',
				borderWidth: 0,
				labelMargin: 5,
				backgroundColor: 'transparent'
			},
			yaxis: {
				min: 0,
				max: 15,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
	}
	
	var flotArea1 = function(){
		var newCust = [[0, 2], [1, 3], [2, 6], [3, 5], [4, 7], [5, 8], [6, 10]];
		var retCust = [[0, 1], [1, 2], [2, 5], [3, 3], [4, 5], [5, 6], [6, 9]];
		
		var plot = $.plot($('#flotArea1'), [
			{
				data: newCust,
				label: 'New Customer',
				color: '#FFA7D7'
			},
			{
				data: retCust,
				label: 'Returning Customer',
				color: '#ffaa2b'
			}
		],
		{
			series: {
				lines: {
					show: true,
					lineWidth: 0,
					fill: 1
				},
				shadowSize: 0
			},
			points: {
				show: false,
			},
			legend: {
				noColumns: 1,
				position: 'nw'
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderColor: '#ddd',
				borderWidth: 0,
				labelMargin: 5,
				backgroundColor: 'transparent'
			},
			yaxis: {
				min: 0,
				max: 15,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
	}
	
	var flotArea2 = function(){
		var newCust = [[0, 2], [1, 3], [2, 6], [3, 5], [4, 7], [5, 8], [6, 10]];
		var retCust = [[0, 1], [1, 2], [2, 5], [3, 3], [4, 5], [5, 6], [6, 9]];
		
		var plot = $.plot($('#flotArea2'), [
			{
				data: newCust,
				label: 'New Customer',
				color: '#FFA7D7'
			},
			{
				data: retCust,
				label: 'Returning Customer',
				color: '#ffaa2b'
			}
		],
		{
			series: {
				lines: {
					show: false
				},
				splines: {
					show: true,
					tension: 0.4,
					lineWidth: 0,
					fill: 1
				},
				shadowSize: 0
			},
			points: {
				show: false,
			},
			legend: {
				noColumns: 1,
				position: 'nw'
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderColor: '#ddd',
				borderWidth: 0,
				labelMargin: 5,
				backgroundColor: 'transparent'
			},
			yaxis: {
				min: 0,
				max: 15,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
	}
	
	var flotLine4 = function(){
		var previousPoint = null;

		$('#flotLine4, #flotLine4').bind('plothover', function (event, pos, item) {
			$('#x').text(pos.x.toFixed(2));
			$('#y').text(pos.y.toFixed(2));

			if (item) {
				if (previousPoint != item.dataIndex) {
					previousPoint = item.dataIndex;

					$('#tooltip').remove();
					var x = item.datapoint[0].toFixed(2),
						y = item.datapoint[1].toFixed(2);

					showTooltip(item.pageX, item.pageY, item.series.label + ' of ' + x + ' = ' + y);
				}
			} else {

				$('#tooltip').remove();
				previousPoint = null;
			}
		});
		$('#flotLine4, #flotLine4').bind('plotclick', function (event, pos, item) {
			if (item) {
				plot.highlight(item.series, item.datapoint);
			}
		});
	}

	function showTooltip(x, y, contents) {
		$('<div id="tooltip" class="tooltipflot">' + contents + '</div>').css({
			position: 'absolute',
			display: 'none',
			top: y + 5,
			left: x + 5
		}).appendTo('body').fadeIn(200);
	}

	var StatisticalMemCpu = function(){
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function () {
			if (xhr.readyState == 4 && xhr.status == 200) {
				var data = xhr.responseText;
				data = JSON.parse(data);
				MemUsage = parseFloat(Number(data.memory_usage+1.0).toFixed(2));
				CpuUsage = parseFloat(Number(data.cpu_usage+1.0).toFixed(2));
				DiskUsage = parseFloat(Number(data.disk_usage).toFixed(2));
				realTimeTcpCnt = data.total_tcp_cnt;
				document.getElementById("cpuUsage").innerHTML = 'Cpu使用率 '+CpuUsage +'%';
				document.getElementById("memUsage").innerHTML = '内存使用率 '+MemUsage +'%';
				document.getElementById("diskUsage").innerHTML = '磁盘使用率 '+DiskUsage +'%';
				document.getElementById("realtimeTcpCnt").innerHTML = 'TCP实时连接数 '+realTimeTcpCnt;
			}
		}
		var intervalId =  window.setInterval(function clock()
		{
			xhr.open('GET','api/statistical',true)
			xhr.send();
		},2*1000);
		xhr.open('GET','api/statistical',true)
		xhr.send();
	}

	var flotRealtime1 = function(){
		var data = [], totalPoints = 50;
		function getRandomData() {
			if (data.length > 0)
				data = data.slice(1);
			while (data.length < totalPoints) {
				data.push(CpuUsage);
			}
			var res = [];
			for (var i = 0; i < data.length; ++i) {
				res.push([i, data[i]])
			}
			return res;
		}
		
		// Set up the control widget
		var updateInterval = 1000;
		
		var plot5 = $.plot('#flotRealtime1', [getRandomData()], {
			colors: ['#FFA7D7'],
			series: {
				lines: {
					show: true,
					lineWidth: 0,
					fill: 0.9
				},
				shadowSize: 0	// Drawing is faster without shadows
			},
			grid: {
				borderColor: 'transparent',
				borderWidth: 1,
				labelMargin: 5
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			yaxis: {
				min: 0,
				max: 100,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
		update_plot4();
		function update_plot4() {
			plot5.setData([getRandomData()]);
			plot5.draw();
			setTimeout(update_plot4, updateInterval);
		}
	}
	
	var flotRealtime2 = function(){
		var data = [], totalPoints = 50;
		function getRandomData() {
			if (data.length > 0)
				data = data.slice(1);
			while (data.length < totalPoints) {
				data.push(MemUsage);
			}
			var res = [];
			for (var i = 0; i < data.length; ++i) {
				res.push([i, data[i]])
			}
			return res;
		}
		
		// Set up the control widget
		var updateInterval = 1000;
		
		var plot5 = $.plot('#flotRealtime2', [getRandomData()], {
			colors: ['#FFA7D7'],
			series: {
				lines: {
					show: true,
					lineWidth: 0,
					fill: 0.9
				},
				shadowSize: 0	// Drawing is faster without shadows
			},
			grid: {
				borderColor: 'transparent',
				borderWidth: 1,
				labelMargin: 5
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			yaxis: {
				min: 0,
				max: 100,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
		update_plot5();
		function update_plot5() {
			plot5.setData([getRandomData()]);
			plot5.draw();
			setTimeout(update_plot5, updateInterval);
		}
	}

	var flotRealtime3 = function(){
		var data = [], totalPoints = 50;
		function getRandomData() {
			if (data.length > 0)
				data = data.slice(1);
			while (data.length < totalPoints) {
				data.push(DiskUsage);
			}
			var res = [];
			for (var i = 0; i < data.length; ++i) {
				res.push([i, data[i]])
			}
			return res;
		}
		
		// Set up the control widget
		var updateInterval = 1000;
		
		var plot5 = $.plot('#flotRealtime3', [getRandomData()], {
			colors: ['#FFA7D7'],
			series: {
				lines: {
					show: true,
					lineWidth: 0,
					fill: 0.9
				},
				shadowSize: 0	// Drawing is faster without shadows
			},
			grid: {
				borderColor: 'transparent',
				borderWidth: 1,
				labelMargin: 5
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			yaxis: {
				min: 0,
				max: 100,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
		update_plot5();
		function update_plot5() {
			plot5.setData([getRandomData()]);
			plot5.draw();
			setTimeout(update_plot5, updateInterval);
		}
	}
	var flotRealtime4 = function(){
		var data = [], totalPoints = 50;
		function getRandomData() {
			if (data.length > 0)
				data = data.slice(1);
			while (data.length < totalPoints) {
				data.push(realTimeTcpCnt);
			}
			var res = [];
			for (var i = 0; i < data.length; ++i) {
				res.push([i, data[i]])
			}
			return res;
		}
		
		// Set up the control widget
		var updateInterval = 1000;
		
		var plot5 = $.plot('#flotRealtime4', [getRandomData()], {
			colors: ['#FFA7D7'],
			series: {
				lines: {
					show: true,
					lineWidth: 0,
					fill: 0.9
				},
				shadowSize: 0	// Drawing is faster without shadows
			},
			grid: {
				borderColor: 'transparent',
				borderWidth: 1,
				labelMargin: 5
			},
			xaxis: {
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			},
			yaxis: {
				min: 0,
				max: 500,
				color: 'transparent',
				font: {
					size: 10,
					color: '#fff'
				}
			}
		});
		update_plot5();
		function update_plot5() {
			plot5.setData([getRandomData()]);
			plot5.draw();
			setTimeout(update_plot5, updateInterval);
		}
	}
	
	/* Function ============ */
	return {
		init:function(){
		},
		
		
		load:function(){
			flotBar1();	
			flotBar2();
			flotLine1();	
			flotLine2();	
			flotLine3();		
			flotArea1();
			flotArea2();
			flotLine4();
			flotRealtime1();
			flotRealtime2();
			flotRealtime3();
			flotRealtime4();
			StatisticalMemCpu();
		},
		
		resize:function(){
		}
	}

}();

jQuery(document).ready(function(){
});
	
jQuery(window).on('load',function(){
	dlabChartlist.load();
});

jQuery(window).on('resize',function(){
	dlabChartlist.resize();
});     

})(jQuery);