(function($) {
    /* "use strict" */
    var dlabChartlist = function() {
        var screenWidth = $(window).width();
        let draw = Chart.controllers.line.__super__.draw; //draw shadow
        var donutChart1 = function() {
            $("span.donut1").peity("donut", {
                width: "70",
                height: "70"
            });
        }
        var HistoryStatistical = function() {
            var HashRateOptions = {
                series: [{
                    name: 'hash rate',
                    data: [0],
                    //radius: 12,	
                }, ],
                chart: {
                    type: 'line',
                    height: 300,
                    toolbar: {
                        show: false,
                    },
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '70%',
                        endingShape: 'rounded'
                    },
                },
                colors: ['#886CC0'],
                dataLabels: {
                    enabled: false,
                },
                markers: {
                    shape: "circle",
                },

                legend: {
                    show: false,
                },
                stroke: {
                    show: true,
                    width: 2,
                    curve: 'smooth',
                    colors: ['var(--primary)'],
                },

                grid: {
                    borderColor: '#eee',
                    show: true,
                    xaxis: {
                        lines: {
                            show: true,
                        }
                    },
                    yaxis: {
                        lines: {
                            show: false,
                        }
                    },
                },
                xaxis: {
                    categories: [],
                    show: false,
                    labels: {
                        style: {
                            colors: '#7E7F80',
                            fontSize: '13px',
                            fontFamily: 'Poppins',
                            fontWeight: 100,
                            cssClass: 'apexcharts-xaxis-label',
                        },
                    },
                    crosshairs: {
                        show: false,
                    }
                },
                yaxis: {
                    show: true,
                    labels: {
                        offsetX: -15,
                        style: {
                            colors: '#7E7F80',
                            fontSize: '14px',
                            fontFamily: 'Poppins',
                            fontWeight: 100,
                        },
                        formatter: function(y) {
                            return y.toFixed(0) + "G";
                        }
                    },
                },
                fill: {
                    opacity: 1,
                    colors: '#FAC7B6'
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return val + " gh/s"
                        }
                    }
                }
            };
            var WorkerCntOptions = {
                series: [{
                    name: '矿机数',
                    data: [0],
                    //radius: 12,	
                }, ],
                chart: {
                    type: 'line',
                    height: 300,
                    toolbar: {
                        show: false,
                    },
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '70%',
                        endingShape: 'rounded'
                    },
                },
                colors: ['#886CC0'],
                dataLabels: {
                    enabled: false,
                },
                markers: {
                    shape: "circle",
                },

                legend: {
                    show: false,
                },
                stroke: {
                    show: true,
                    width: 2,
                    curve: 'smooth',
                    colors: ['var(--primary)'],
                },

                grid: {
                    borderColor: '#eee',
                    show: true,
                    xaxis: {
                        lines: {
                            show: true,
                        }
                    },
                    yaxis: {
                        lines: {
                            show: false,
                        }
                    },
                },
                xaxis: {
                    categories: [],
                    show: false,
                    labels: {
                        style: {
                            colors: '#7E7F80',
                            fontSize: '13px',
                            fontFamily: 'Poppins',
                            fontWeight: 100,
                            cssClass: 'apexcharts-xaxis-label',
                        },
                    },
                    crosshairs: {
                        show: false,
                    }
                },
                yaxis: {
                    show: true,
                    labels: {
                        offsetX: -15,
                        style: {
                            colors: '#7E7F80',
                            fontSize: '14px',
                            fontFamily: 'Poppins',
                            fontWeight: 100,
                        },
                        formatter: function(y) {
                            return y.toFixed(0) + "台";
                        }
                    },
                },
                fill: {
                    opacity: 1,
                    colors: '#FAC7B6'
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return val + " 台"
                        }
                    }
                }
            };
            var MineHashRateOptions = {
                series: [{
                    name: 'Net Profit',
                    data: [],
                    /* radius: 30,*/
                }, ],
                chart: {
                    type: 'line',
                    height: 50,
                    width: 180,
                    toolbar: {
                        show: false,
                    },
                    zoom: {
                        enabled: false
                    },
                    sparkline: {
                        enabled: true
                    }
                },

                colors: ['var(--primary)'],
                dataLabels: {
                    enabled: false,
                },

                legend: {
                    show: false,
                },
                stroke: {
                    show: true,
                    width: 2,
                    curve: 'smooth',
                    colors: ['var(--primary)'],
                },

                grid: {
                    show: false,
                    borderColor: '#eee',
                    padding: {
                        top: 0,
                        right: 0,
                        bottom: 0,
                        left: 0

                    }
                },
                states: {
                    normal: {
                        filter: {
                            type: 'none',
                            value: 0
                        }
                    },
                    hover: {
                        filter: {
                            type: 'none',
                            value: 0
                        }
                    },
                    active: {
                        allowMultipleDataPointsSelection: false,
                        filter: {
                            type: 'none',
                            value: 0
                        }
                    }
                },
                xaxis: {
                    categories: [],
                    axisBorder: {
                        show: false,
                    },
                    axisTicks: {
                        show: false
                    },
                    labels: {
                        show: false,
                        style: {
                            fontSize: '12px',
                        }
                    },
                    crosshairs: {
                        show: false,
                        position: 'front',
                        stroke: {
                            width: 1,
                            dashArray: 3
                        }
                    },
                    tooltip: {
                        enabled: true,
                        formatter: undefined,
                        offsetY: 0,
                        style: {
                            fontSize: '12px',
                        }
                    }
                },
                yaxis: {
                    show: false,
                },
                fill: {
                    opacity: 1,
                    colors: '#FB3E7A'
                },
                tooltip: {
                    enabled: false,
                    style: {
                        fontSize: '12px',
                    },
                    y: {
                        formatter: function(val) {
                            return "$" + val + " thousands"
                        }
                    }
                }
            };
            var MineWorkerCntoptions = {
                series: [{
                    name: 'Net Profit',
                    data: [],
                    /* radius: 30,	 */
                }, ],
                chart: {
                    type: 'line',
                    height: 50,
                    width: 180,
                    toolbar: {
                        show: false,
                    },
                    zoom: {
                        enabled: false
                    },
                    sparkline: {
                        enabled: true
                    }
                },

                colors: ['#0E8A74'],
                dataLabels: {
                    enabled: false,
                },

                legend: {
                    show: false,
                },
                stroke: {
                    show: true,
                    width: 2,
                    curve: 'smooth',
                    colors: ['var(--primary)'],
                },

                grid: {
                    show: false,
                    borderColor: '#eee',
                    padding: {
                        top: 0,
                        right: 0,
                        bottom: 0,
                        left: 0

                    }
                },
                states: {
                    normal: {
                        filter: {
                            type: 'none',
                            value: 0
                        }
                    },
                    hover: {
                        filter: {
                            type: 'none',
                            value: 0
                        }
                    },
                    active: {
                        allowMultipleDataPointsSelection: false,
                        filter: {
                            type: 'none',
                            value: 0
                        }
                    }
                },
                xaxis: {
                    categories: ['Jan', 'feb', 'Mar', 'Apr', 'May'],
                    axisBorder: {
                        show: false,
                    },
                    axisTicks: {
                        show: false
                    },
                    labels: {
                        show: false,
                        style: {
                            fontSize: '12px',
                        }
                    },
                    crosshairs: {
                        show: false,
                        position: 'front',
                        stroke: {
                            width: 1,
                            dashArray: 3
                        }
                    },
                    tooltip: {
                        enabled: true,
                        formatter: undefined,
                        offsetY: 0,
                        style: {
                            fontSize: '12px',
                        }
                    }
                },
                yaxis: {
                    show: false,
                },
                fill: {
                    opacity: 1,
                    colors: '#FB3E7A'
                },
                tooltip: {
                    enabled: false,
                    style: {
                        fontSize: '12px',
                    },
                    y: {
                        formatter: function(val) {
                            return "$" + val + " thousands"
                        }
                    }
                }
            };
            var chartBarHashRate = new ApexCharts(document.querySelector("#HistoryHashrate"), HashRateOptions);
            var chartBarWorkerCnt = new ApexCharts(document.querySelector("#HistoryWorker"), WorkerCntOptions);
            var chartBarMineHashRate = new ApexCharts(document.querySelector("#NewCustomersTotalHashRate"), MineHashRateOptions);
            var chartBarMineWorkerCnt = new ApexCharts(document.querySelector("#NewCustomersTotalWorker"), MineWorkerCntoptions);
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var data = xhr.responseText;
                    data = JSON.parse(data);
                    for (var p in data.worker_info) {
                        HashRateOptions.series[0].data[p] = parseFloat(Number(data.worker_info[p].hash_rate / 1000000000).toFixed(3));
                        HashRateOptions.xaxis.categories[p] = data.worker_info[p].time;

                        MineHashRateOptions.series[0].data[p] = parseFloat(Number(data.worker_info[p].hash_rate / 1000000000).toFixed(3));
                        MineHashRateOptions.xaxis.categories[p] = data.worker_info[p].time;

                        WorkerCntOptions.series[0].data[p] = data.worker_info[p].worker_cnt;
                        WorkerCntOptions.xaxis.categories[p] = data.worker_info[p].time;

                        MineWorkerCntoptions.series[0].data[p] = data.worker_info[p].worker_cnt;
                        MineWorkerCntoptions.xaxis.categories[p] = data.worker_info[p].time;
                    }
                    chartBarHashRate.render();
                    chartBarWorkerCnt.render();
                    chartBarMineHashRate.render();
                    chartBarMineWorkerCnt.render();
                }
            }
            xhr.open('GET', 'api/workerInfoHistory?coinType=ETC', true)
            xhr.send();
        }
        var Statistical = function() {
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var data = xhr.responseText;
                    data = JSON.parse(data);
                    document.getElementById("TotalWorker").innerHTML = data.etc.total_client;
                    document.getElementById("TotalShares").innerHTML = data.etc.total_share;
                    document.getElementById("TotalHashRate").innerHTML = parseFloat(Number(data.etc.total_hash_rate / 1000000000).toFixed(3));
                    document.getElementById("TotalHash1HoursShares").innerHTML = data.etc.hours_1_total_share;
                }
            }
            var intervalId = window.setInterval(function clock() {
                xhr.open('GET', 'api/statistical', true)
                xhr.send();
            }, 2 * 1000);
            xhr.open('GET', 'api/statistical', true)
            xhr.send();
        }
        var MinerAndPoolInfo = function() {
                var xhr = new XMLHttpRequest();
                xhr.onreadystatechange = function() {
                    if (xhr.readyState == 4 && xhr.status == 200) {
                        var data = xhr.responseText;
                        data = JSON.parse(data);
                        var divelementstr = "";
                        for (var p in data.pool_infos) {
                            var this_hashrate = parseFloat(Number(data.pool_infos[p].hash_rate / 1000000000).toFixed(3));
                            divelementstr += '<tr><td>' + data.pool_infos[p].name + '</td>' + '<td>' + 'TCP' + '</td>' + '<td>' + data.pool_infos[p].listen_port + '</td>' + '<td>' + this_hashrate + '</td>' + '<td>' + data.pool_infos[p].clients + '</td>' + '</tr>';
                        }
                        for (var p in data.pool_aes_infos) {
                            var this_hashrate = parseFloat(Number(data.pool_aes_infos[p].hash_rate / 1000000000).toFixed(3));
                            divelementstr += '<tr><td>' + data.pool_aes_infos[p].name + '</td>' + '<td>' + 'AES' + '</td>' + '<td>' + data.pool_aes_infos[p].listen_port + '</td>' + '<td>' + this_hashrate + '</td>' + '<td>' + data.pool_aes_infos[p].clients + '</td>' + '</tr>';
                        }
                        for (var p in data.pool_sll_infos) {
                            var this_hashrate = parseFloat(Number(data.pool_sll_infos[p].hash_rate / 1000000000).toFixed(3));
                            divelementstr += '<tr><td>' + data.pool_sll_infos[p].name + '</td>' + '<td>' + 'SSL' + '</td>' + '<td>' + data.pool_sll_infos[p].listen_port + '</td>' + '<td>' + this_hashrate + '</td>' + '<td>' + data.pool_sll_infos[p].clients + '</td>' + '</tr>';
                        }
                        document.getElementById("pool-list").innerHTML = divelementstr;
                        //加载数据后面好选择使用
                        var tablepoollist = $('#example-poollist').DataTable({
                            createdRow: function(row, data, index) {
                                $(row).addClass('selected')
                            },
                            language: {
                                paginate: {
                                    next: '<i class="fa fa-angle-double-right" aria-hidden="true"></i>',
                                    previous: '<i class="fa fa-angle-double-left" aria-hidden="true"></i>'
                                }
                            }
                        });
                        tablepoollist.on('click', 'tbody tr', function() {
                            var $row = tablepoollist.row(this).nodes().to$();
                            var hasClass = $row.hasClass('selected');
                            if (hasClass) {
                                $row.removeClass('selected')
                            } else {
                                $row.addClass('selected')
                            }
                        })
                        tablepoollist.rows().every(function() {
                            this.nodes().to$().removeClass('selected')
                        });
                    }
                }
                xhr.open('GET', 'api/poolInfo?coinType=ETC', true)
                xhr.send();
                var xhrClientInfo = new XMLHttpRequest();
                xhrClientInfo.onreadystatechange = function() {
                    if (xhrClientInfo.readyState == 4 && xhrClientInfo.status == 200) {
                        var data = xhrClientInfo.responseText;
                        data = JSON.parse(data);
                        var divelementstr = "";
                        for (var p in data.miner_base) {
                            var this_hashrate = parseFloat(Number(data.miner_base[p].total_hash_rate / 1000000000).toFixed(3));
                            if (data.miner_base[p].coin_type == "ETC") {
                                divelementstr += '<tr><td>' + data.miner_base[p].name + '<a href="userDashboard?coinType=ETC&miner=' + data.miner_base[p].name + '"' + 'target="_blank">  更多</a></td>' + '<td>' + this_hashrate + '</td>' + '<td>' + data.miner_base[p].total_worker + '<td>' + data.miner_base[p].total_shares + '<td>' + data.miner_base[p].total_1_hours_shares + '</td>' + '<td>' + data.miner_base[p].total_fee_shares + '</td>' + '<td>' + data.miner_base[p].total_author_fee_shares + '</td>' + '</tr>';
                            }
                        }
                        document.getElementById("eth-client-list").innerHTML = divelementstr;
                        //加载数据后面好选择使用
                        var tableuserlist = $('#example-userlist').DataTable({
                            createdRow: function(row, data, index) {
                                $(row).addClass('selected')
                            },
                            language: {
                                paginate: {
                                    next: '<i class="fa fa-angle-double-right" aria-hidden="true"></i>',
                                    previous: '<i class="fa fa-angle-double-left" aria-hidden="true"></i>'
                                }
                            }
                        });

                        tableuserlist.on('click', 'tbody tr', function() {
                            var $row = tableuserlist.row(this).nodes().to$();
                            var hasClass = $row.hasClass('selected');
                            if (hasClass) {
                                $row.removeClass('selected')
                            } else {
                                $row.addClass('selected')
                            }
                        })
                        tableuserlist.rows().every(function() {
                            this.nodes().to$().removeClass('selected')
                        });
                    }
                }
                xhrClientInfo.open('GET', 'api/minerInfo?coinType=ETC', true)
                xhrClientInfo.send();
            }
            /* Function ============ */
        return {
            init: function() {},
            load: function() {
                donutChart1();
                HistoryStatistical();
                Statistical();
                MinerAndPoolInfo();
            },
            resize: function() {}
        }
    }();
    jQuery(window).on('load', function() {
        setTimeout(function() {
            dlabChartlist.load();
        }, 1000);
    });
})(jQuery);