(function($) {
    /* "use strict" */
 	var dlabChartlist = function(){
		var screenWidth = $(window).width();
		var UserrevenueMap = function(){
			var options = {
				series: [
					{
						name: 'hash rate',
						data: [0],
						//radius: 12,	
					}, 				
				],
					chart: {
					type: 'line',
					height: 300,
					toolbar: {
						show: false,
					},
				},
				plotOptions: {
				bar: {
					horizontal: false,
					columnWidth: '70%',
					endingShape: 'rounded'
				},
				},
				colors:['#886CC0'],
				dataLabels: {
				enabled: false,
				},
				markers: {
					shape: "circle",
				},
		
				legend: {
					show: false,
				},
				stroke: {
				show: true,
				width: 2,
				curve:'smooth',
				colors:['var(--primary)'],
				},
				
				grid: {
					borderColor: '#eee',
					show: true,
					xaxis: {
						lines: {
							show: true,
						}
					},  
					yaxis: {
						lines: {
							show: false,
						}
					},  
				},
				xaxis: {
				categories: [],
				show:false,
				labels: {
					style: {
						colors: '#7E7F80',
						fontSize: '13px',
						fontFamily: 'Poppins',
						fontWeight: 100,
						cssClass: 'apexcharts-xaxis-label',
					},
				},
				crosshairs: {
				show: false,
				}
				},
				yaxis: {
				show:true,	
				labels: {
					offsetX: -15,
				style: {
					colors: '#7E7F80',
					fontSize: '14px',
					fontFamily: 'Poppins',
					fontWeight: 100,
					},
					formatter: function (y) {
						return y.toFixed(0) + "G";
					}
				},
				},
				fill: {
				opacity: 1,
				colors:'#FAC7B6'
				},
				tooltip: {
				y: {
					formatter: function (val) {
					return val + " gh/s"
					}
				}
				}
				};//jiangmin
				var chartBar1 = new ApexCharts(document.querySelector("#UserrevenueMap"), options);
				var xhr = new XMLHttpRequest();
				xhr.onreadystatechange = function () {
					if (xhr.readyState == 4 && xhr.status == 200) {
						var data = xhr.responseText;
						data = JSON.parse(data);
						for (var p in data.total_hash_rate_history){
							options.series[0].data[p] = parseFloat(Number(data.total_hash_rate_history[p].hash_rate ).toFixed(2)); 
							options.xaxis.categories[p] = data.total_hash_rate_history[p].time;
						}
						chartBar1.render();
					}
				}
				xhr.open('GET','api/totalHashRateHistory',true)
				xhr.send();
		}
		var UserrevenueMapClients = function(){
			var options = {
				series: [
				{
					name: '矿机数',
					data: [0],
					//radius: 12,	
				}, 				
			],
				chart: {
				type: 'line',
				height: 300,
				toolbar: {
					show: false,
				},
			},
			plotOptions: {
				bar: {
				horizontal: false,
				columnWidth: '70%',
				endingShape: 'rounded'
				},
			},
			colors:['#886CC0'],
			dataLabels: {
				enabled: false,
			},
			markers: {
				shape: "circle",
			},
	
			legend: {
				show: false,
			},
			stroke: {
				show: true,
				width: 2,
				curve:'smooth',
				colors:['var(--primary)'],
			},
			
			grid: {
				borderColor: '#eee',
				show: true,
				xaxis: {
					lines: {
						show: true,
					}
				},  
				yaxis: {
					lines: {
						show: false,
					}
				},  
			},
			xaxis: {
				categories: [],
				show:false,
				labels: {
				style: {
					colors: '#7E7F80',
					fontSize: '13px',
					fontFamily: 'Poppins',
					fontWeight: 100,
					cssClass: 'apexcharts-xaxis-label',
				},
				},
				crosshairs: {
				show: false,
				}
			},
			yaxis: {
			show:true,	
			labels: {
				offsetX: -15,
				style: {
					colors: '#7E7F80',
					fontSize: '14px',
					fontFamily: 'Poppins',
					fontWeight: 100,
				},
				formatter: function (y) {
					return y.toFixed(0) + "台";
				}
				},
			},
			fill: {
				opacity: 1,
				colors:'#FAC7B6'
			},
			tooltip: {
				y: {
				formatter: function (val) {
					return val + " 台"
				}
				}
			}
			};//jiangmin
			var chartBar1 = new ApexCharts(document.querySelector("#UserrevenueMapClients"), options);
			var xhr = new XMLHttpRequest();
			xhr.onreadystatechange = function () {
				if (xhr.readyState == 4 && xhr.status == 200) {
					var data = xhr.responseText;
					data = JSON.parse(data);
					for (var p in data.total_client_history){
						options.series[0].data[p] = parseFloat(Number(data.total_client_history[p].client_cnt).toFixed(2)); 
						options.xaxis.categories[p] = data.total_client_history[p].time;
					}
					chartBar1.render();
				}
			}
			xhr.open('GET','api/totalClientCntHistory',true)
			xhr.send();
		}
		var UserrevenueMapShares = function(){
			var options = {
				series: [
				{
					name: '份额数',
					data: [0],
					//radius: 12,	
				}, 				
			],
				chart: {
				type: 'line',
				height: 300,
				toolbar: {
					show: false,
				},
			},
			plotOptions: {
				bar: {
				horizontal: false,
				columnWidth: '70%',
				endingShape: 'rounded'
				},
			},
			colors:['#886CC0'],
			dataLabels: {
				enabled: false,
			},
			markers: {
				shape: "circle",
			},
	
			legend: {
				show: false,
			},
			stroke: {
				show: true,
				width: 2,
				curve:'smooth',
				colors:['var(--primary)'],
			},
			
			grid: {
				borderColor: '#eee',
				show: true,
				xaxis: {
					lines: {
						show: true,
					}
				},  
				yaxis: {
					lines: {
						show: false,
					}
				},  
			},
			xaxis: {
				categories: [],
				show:false,
				labels: {
				style: {
					colors: '#7E7F80',
					fontSize: '13px',
					fontFamily: 'Poppins',
					fontWeight: 100,
					cssClass: 'apexcharts-xaxis-label',
				},
				},
				crosshairs: {
				show: false,
				}
			},
			yaxis: {
			show:true,	
			labels: {
				offsetX: -15,
				style: {
					colors: '#7E7F80',
					fontSize: '14px',
					fontFamily: 'Poppins',
					fontWeight: 100,
				},
				formatter: function (y) {
					return y.toFixed(0) + "份";
				}
				},
			},
			fill: {
				opacity: 1,
				colors:'#FAC7B6'
			},
			tooltip: {
				y: {
				formatter: function (val) {
					return val + " 份"
				}
				}
			}
			};//jiangmin
			var chartBar1 = new ApexCharts(document.querySelector("#UserrevenueMapShares"), options);
			var xhr = new XMLHttpRequest();
			xhr.onreadystatechange = function () {
				if (xhr.readyState == 4 && xhr.status == 200) {
					var data = xhr.responseText;
					data = JSON.parse(data);
					for (var p in data.total_client_history){
						options.series[0].data[p] = parseFloat(Number(data.total_client_history[p].client_cnt).toFixed(2)); 
						options.xaxis.categories[p] = data.total_client_history[p].time;
					}
					chartBar1.render();
				}
			}
			xhr.open('GET','api/totalClientCntHistory',true)
			xhr.send();
		}
		/* Function ============ */
		return {
			init:function(){
			},
			load:function(){
			UserrevenueMap();
			UserrevenueMapClients();
			UserrevenueMapShares();
			},
			resize:function(){
			}
		}
	}();
	jQuery(window).on('load',function(){
		setTimeout(function(){
			dlabChartlist.load();
		}, 1000); 
	});
})(jQuery);