/*
 * Decompiled with CFR 0.152.
 */
package com.mistamek.drawablepreview.drawables;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.mistamek.drawablepreview.factories.IconPreviewFactory;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u001fJ\u0018\u0010!\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\"J\u0018\u0010#\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\"J\u0018\u0010$\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mistamek/drawablepreview/drawables/Utils;", "", "()V", "BOTTOM", "", "CENTER", "CENTER_HORIZONTAL", "CENTER_VERTICAL", "CLIP_HORIZONTAL", "CLIP_VERTICAL", "END", "FILL", "FILL_HORIZONTAL", "FILL_VERTICAL", "LEFT", "RIGHT", "START", "TOP", "drawResizedIcon", "", "src", "Ljava/awt/Image;", "out", "getPsiFileFromPath", "Lcom/intellij/psi/PsiFile;", "path", "parseAttributeAsColor", "Ljava/awt/Color;", "string", "defaultColor", "parseAttributeAsFloat", "", "defaultValue", "parseAttributeAsGravity", "", "parseAttributeAsInt", "parseAttributeAsPercent", "drawable-preview"})
public final class Utils {
    private static final String LEFT = "left";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String RIGHT = "right";
    private static final String CENTER_VERTICAL = "center_vertical";
    private static final String FILL_VERTICAL = "fill_vertical";
    private static final String CENTER_HORIZONTAL = "center_horizontal";
    private static final String FILL_HORIZONTAL = "fill_horizontal";
    private static final String CENTER = "center";
    private static final String FILL = "fill";
    private static final String CLIP_VERTICAL = "clip_vertical";
    private static final String CLIP_HORIZONTAL = "clip_horizontal";
    private static final String START = "start";
    private static final String END = "end";
    public static final Utils INSTANCE;

    public final int parseAttributeAsInt(@Nullable String string, int defaultValue) {
        String string2 = string;
        if (string2 != null) {
            int n;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String intString = string3;
            boolean bl3 = false;
            try {
                n = new Scanner(intString).useDelimiter("\\D+").nextInt();
            }
            catch (Exception e) {
                n = defaultValue;
            }
            return n;
        }
        return defaultValue;
    }

    public final float parseAttributeAsFloat(@Nullable String string, float defaultValue) {
        String string2 = string;
        if (string2 != null) {
            float f;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String floatString = string3;
            boolean bl3 = false;
            try {
                f = new Scanner(floatString).useDelimiter("[^0-9.]+").nextFloat();
            }
            catch (Exception e) {
                f = defaultValue;
            }
            return f;
        }
        return defaultValue;
    }

    public final float parseAttributeAsPercent(@Nullable String string, float defaultValue) {
        String string2 = string;
        if (string2 != null) {
            float f;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String percentString = string3;
            boolean bl3 = false;
            try {
                f = (float)new Scanner(percentString).useDelimiter("\\D+").nextInt() / 100.0f;
            }
            catch (Exception e) {
                f = defaultValue;
            }
            return f;
        }
        return defaultValue;
    }

    @Nullable
    public final Color parseAttributeAsColor(@Nullable String string, @Nullable Color defaultColor) {
        String string2 = string;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String colorString = string3;
            boolean bl3 = false;
            try {
                String string4 = colorString;
                int n = 1;
                boolean bl4 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                string4 = string6;
                n = 16;
                bl4 = false;
                long color = Long.parseLong(string4, CharsKt.checkRadix((int)n));
                if (colorString.length() == 7) {
                    color |= 0xFFFFFFFFFF000000L;
                }
                return new Color((int)color, true);
            }
            catch (Exception e) {
                Color color = defaultColor;
                return color;
            }
        }
        return defaultColor;
    }

    public final int parseAttributeAsGravity(@Nullable String string, int defaultValue) {
        String string2 = string;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String gravityString = string3;
            boolean bl3 = false;
            try {
                int value = 0;
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)gravityString, (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String gravity = (String)element$iv;
                    boolean bl4 = false;
                    String string4 = gravity;
                    boolean bl5 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    switch (((Object)StringsKt.trim((CharSequence)string5)).toString()) {
                        case "left": {
                            value |= 3;
                            break;
                        }
                        case "top": {
                            value |= 0x30;
                            break;
                        }
                        case "bottom": {
                            value |= 0x50;
                            break;
                        }
                        case "right": {
                            value |= 5;
                            break;
                        }
                        case "center_vertical": {
                            value |= 0x10;
                            break;
                        }
                        case "fill_vertical": {
                            value |= 0x70;
                            break;
                        }
                        case "center_horizontal": {
                            value |= 1;
                            break;
                        }
                        case "fill_horizontal": {
                            value |= 7;
                            break;
                        }
                        case "center": {
                            value |= 0x11;
                            break;
                        }
                        case "fill": {
                            value |= 0x77;
                            break;
                        }
                        case "clip_vertical": {
                            value |= 0x80;
                            break;
                        }
                        case "clip_horizontal": {
                            value |= 8;
                            break;
                        }
                        case "start": {
                            value |= 0x800003;
                            break;
                        }
                        case "end": {
                            value |= 0x800005;
                        }
                    }
                }
                return value == 0 ? defaultValue : value;
            }
            catch (Exception e) {
                int n = defaultValue;
                return n;
            }
        }
        return defaultValue;
    }

    @Nullable
    public final PsiFile getPsiFileFromPath(@NotNull String path) {
        Object object;
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        VirtualFile virtualFile2 = virtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile3;
            boolean bl3 = false;
            PsiManager psiManager = IconPreviewFactory.INSTANCE.getPsiManager();
            object = psiManager != null ? psiManager.findFile(it) : null;
        } else {
            object = null;
        }
        return object;
    }

    public final void drawResizedIcon(@NotNull Image src, @NotNull Image out) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        int originalWidth = src.getWidth(null);
        int originalHeight = src.getHeight(null);
        int boundWidth = out.getWidth(null);
        int boundHeight = out.getHeight(null);
        int newWidth = originalWidth;
        int newHeight = originalHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        float f = (float)(boundWidth - newWidth) / 2.0f;
        boolean bl = false;
        int paddingLeft = (int)Math.rint(f);
        float f2 = (float)(boundHeight - newHeight) / 2.0f;
        boolean bl2 = false;
        int paddingTop = (int)Math.rint(f2);
        out.getGraphics().drawImage(src, paddingLeft, paddingTop, newWidth, newHeight, null);
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

