/*
 * Decompiled with CFR 0.152.
 */
package com.mistamek.drawablepreview.drawables.dom;

import com.mistamek.drawablepreview.drawables.dom.Drawable;
import com.mistamek.drawablepreview.drawables.dom.LayerDrawableItem;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/LayerDrawable;", "Lcom/mistamek/drawablepreview/drawables/dom/Drawable;", "()V", "drawables", "Ljava/util/ArrayList;", "Lcom/mistamek/drawablepreview/drawables/dom/LayerDrawableItem;", "Lkotlin/collections/ArrayList;", "draw", "", "outputImage", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "resolveDimens", "image", "Companion", "drawable-preview"})
public final class LayerDrawable
extends Drawable {
    private final ArrayList<LayerDrawableItem> drawables = new ArrayList();
    private static final String ITEM_TAG = "item";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void inflate(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            NodeList $this$forEachAsElement$iv = nodeList;
            boolean $i$f$forEachAsElement = false;
            int n = 0;
            int n2 = $this$forEachAsElement$iv.getLength();
            while (n < n2) {
                void i$iv;
                Node childNode$iv = $this$forEachAsElement$iv.item((int)i$iv);
                if (childNode$iv instanceof Element) {
                    Element childNode = (Element)childNode$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)childNode.getTagName(), (Object)ITEM_TAG)) {
                        this.drawables.add(new LayerDrawableItem(childNode));
                    }
                }
                ++i$iv;
            }
        }
    }

    @Override
    public void draw(@NotNull BufferedImage outputImage) {
        Intrinsics.checkParameterIsNotNull((Object)outputImage, (String)"outputImage");
        super.draw(outputImage);
        this.resolveDimens(outputImage);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LayerDrawableItem it = (LayerDrawableItem)element$iv;
            boolean bl = false;
            it.draw(outputImage);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveDimens(BufferedImage image) {
        void $this$flatMapTo$iv$iv;
        int maxAttrSize;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv = this.drawables;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            LayerDrawableItem it = (LayerDrawableItem)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Integer[]{it.getHeight(), it.getWidth()});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        int n2 = maxAttrSize = n != null ? n : 0;
        if (maxAttrSize > 0) {
            throw (Throwable)new UnsupportedOperationException();
        }
        Iterable $this$flatMap$iv2 = this.drawables;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LayerDrawableItem it = (LayerDrawableItem)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Integer[]{it.getLeft(), it.getTop(), it.getRight(), it.getBottom()});
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Integer n3 = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv2));
        float maxPaddingArg = n3 != null ? (float)n3.intValue() : 0.0f;
        float maxPaddingWidth = (float)image.getWidth() * 0.3f;
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LayerDrawableItem layerDrawableItem = (LayerDrawableItem)element$iv;
            boolean bl = false;
            layerDrawableItem.setWidth(image.getWidth());
            layerDrawableItem.setHeight(image.getHeight());
            layerDrawableItem.setLeft((int)((float)layerDrawableItem.getLeft() / maxPaddingArg * maxPaddingWidth));
            layerDrawableItem.setTop((int)((float)layerDrawableItem.getTop() / maxPaddingArg * maxPaddingWidth));
            layerDrawableItem.setRight((int)((float)layerDrawableItem.getRight() / maxPaddingArg * maxPaddingWidth));
            layerDrawableItem.setBottom((int)((float)layerDrawableItem.getBottom() / maxPaddingArg * maxPaddingWidth));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/LayerDrawable$Companion;", "", "()V", "ITEM_TAG", "", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

