/*
 * Decompiled with CFR 0.152.
 */
package com.mistamek.drawablepreview.drawables.dom;

import com.mistamek.drawablepreview.drawables.Utils;
import com.mistamek.drawablepreview.drawables.dom.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 S2\u00020\u0001:\u0001SB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\u001d\u00104\u001a\u0004\u0018\u0001052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020:H\u0002J\u001b\u0010;\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\u0012\u0010<\u001a\u00020:2\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u001b\u0010?\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\b\u0010@\u001a\u00020:H\u0002J\u0012\u0010A\u001a\u00020:2\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u001b\u0010B\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u00108J\u0010\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J'\u0010G\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020-2\u0006\u0010K\u001a\u00020/H\u0002J\u001f\u0010L\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010MJ\u0010\u0010N\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010O\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010P\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010Q\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010R\u001a\u00020-2\u0006\u0010D\u001a\u00020EH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/GradientDrawable;", "Lcom/mistamek/drawablepreview/drawables/dom/Drawable;", "()V", "bottomLeftHeightRadius", "", "bottomLeftRadius", "bottomLeftWidthRadius", "bottomRightHeightRadius", "bottomRightRadius", "bottomRightWidthRadius", "centerGradientColor", "Ljava/awt/Color;", "color", "dashGap", "dashGapWidth", "endGradientColor", "gradientAngle", "", "gradientCenterX", "gradientCenterY", "gradientRadius", "gradientType", "height", "innerRadius", "innerRadiusRatio", "resolvedHeight", "resolvedStrokeWidth", "resolvedWidth", "shape", "startGradientColor", "strokeColor", "strokeWidth", "thickness", "thicknessRatio", "tintColor", "topLeftHeightRadius", "topLeftRadius", "topLeftWidthRadius", "topRightHeightRadius", "topRightRadius", "topRightWidthRadius", "width", "createStroke", "Ljava/awt/Stroke;", "draw", "", "outputImage", "Ljava/awt/image/BufferedImage;", "drawShape", "graphics", "Ljava/awt/Graphics2D;", "drawStroke", "getGradientPaint", "Ljava/awt/Paint;", "gradientColors", "", "([Ljava/awt/Color;)Ljava/awt/Paint;", "getLinePath", "Ljava/awt/Shape;", "getLinearGradient", "getOval", "forStroke", "", "getRadialGradient", "getRing", "getRoundPath", "getSweepGradient", "inflate", "element", "Lorg/w3c/dom/Element;", "inflateChildElements", "resolveCorners", "maxValue", "(FFLjava/lang/Float;)V", "resolveDimensions", "image", "resolveStroke", "(FLjava/lang/Float;)V", "updateCorners", "updateGradient", "updateSize", "updateSolid", "updateStroke", "Companion", "drawable-preview"})
public final class GradientDrawable
extends Drawable {
    private int shape;
    private int innerRadius = -1;
    private float innerRadiusRatio = 9.0f;
    private Color tintColor;
    private int thickness = -1;
    private float thicknessRatio = 9.0f;
    private int width = -1;
    private int height = -1;
    private int resolvedWidth = this.width;
    private int resolvedHeight = this.height;
    private float gradientCenterX = -1.0f;
    private float gradientCenterY = -1.0f;
    private int gradientType;
    private Color startGradientColor;
    private Color centerGradientColor;
    private Color endGradientColor;
    private int gradientAngle;
    private float gradientRadius = 0.5f;
    private Color color = new Color(0, 0, 0, 0);
    private Color strokeColor;
    private int strokeWidth = -1;
    private float dashGap;
    private float dashGapWidth;
    private float resolvedStrokeWidth = this.strokeWidth;
    private float topLeftRadius;
    private float topRightRadius;
    private float bottomLeftRadius;
    private float bottomRightRadius;
    private float topLeftWidthRadius;
    private float topLeftHeightRadius;
    private float topRightWidthRadius;
    private float topRightHeightRadius;
    private float bottomRightWidthRadius;
    private float bottomRightHeightRadius;
    private float bottomLeftWidthRadius;
    private float bottomLeftHeightRadius;
    private static final String SHAPE = "android:shape";
    private static final String OVAL_SHAPE = "oval";
    private static final String LINE = "line";
    private static final String RING = "ring";
    private static final String INNER_RADIUS = "android:innerRadius";
    private static final String INNER_RADIUS_RATIO = "android:innerRadiusRatio";
    private static final String THICKNESS = "android:thickness";
    private static final String THICKNESS_RATIO = "android:thicknessRatio";
    private static final String SIZE = "size";
    private static final String WIDTH = "android:width";
    private static final String HEIGHT = "android:height";
    private static final String TINT = "android:tint";
    private static final String GRADIENT = "gradient";
    private static final String ANGLE = "android:angle";
    private static final String CENTER_COLOR = "android:centerColor";
    private static final String CENTER_X = "android:centerX";
    private static final String CENTER_Y = "android:centerY";
    private static final String END_COLOR = "android:endColor";
    private static final String GRADIENT_RADIUS = "android:gradientRadius";
    private static final String START_COLOR = "android:startColor";
    private static final String TYPE = "android:type";
    private static final String RADIAL_GRADIENT_TYPE = "radial";
    private static final String SWEEP_GRADIENT_TYPE = "sweep";
    private static final String SOLID = "solid";
    private static final String COLOR = "android:color";
    private static final String STROKE = "stroke";
    private static final String DASH_GAP = "android:dashGap";
    private static final String DASH_WIDTH = "android:dashWidth";
    private static final String CORNERS = "corners";
    private static final String RADIUS = "android:radius";
    private static final String TOP_LEFT_RADIUS = "android:topLeftRadius";
    private static final String BOTTOM_LEFT_RADIUS = "android:bottomLeftRadius";
    private static final String BOTTOM_RIGHT_RADIUS = "android:bottomRightRadius";
    private static final String TOP_RIGHT_RADIUS = "android:topRightRadius";
    private static final int DEFAULT_INT_VALUE = -1;
    private static final float DEFAULT_INNER_RADIUS_RATIO = 9.0f;
    private static final float DEFAULT_THICKNESS_RATIO = 9.0f;
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        this.tintColor = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute(TINT), this.tintColor);
        String string = element.getAttribute(SHAPE);
        if (string != null) {
            int n;
            Object object = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = object;
            boolean bl3 = false;
            switch (it) {
                case "oval": {
                    n = 1;
                    break;
                }
                case "line": {
                    n = 2;
                    break;
                }
                case "ring": {
                    n = 3;
                    break;
                }
                default: {
                    n = this.shape;
                }
            }
            object = n;
            bl = false;
            bl2 = false;
            int it2 = ((Number)object).intValue();
            boolean bl4 = false;
            this.shape = it2;
        }
        if (this.shape == 3) {
            this.innerRadius = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(INNER_RADIUS), this.innerRadius);
            if (this.innerRadius == -1) {
                this.innerRadiusRatio = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(INNER_RADIUS_RATIO), this.innerRadiusRatio);
            }
            this.thickness = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(THICKNESS), this.thickness);
            if (this.thickness == -1) {
                this.thicknessRatio = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(THICKNESS_RATIO), this.thicknessRatio);
            }
        }
        this.inflateChildElements(element);
    }

    /*
     * WARNING - void declaration
     */
    private final void inflateChildElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            NodeList $this$forEachAsElement$iv = nodeList;
            boolean $i$f$forEachAsElement = false;
            int n = 0;
            int n2 = $this$forEachAsElement$iv.getLength();
            while (n < n2) {
                void i$iv;
                Node childNode$iv = $this$forEachAsElement$iv.item((int)i$iv);
                if (childNode$iv instanceof Element) {
                    Element childNode = (Element)childNode$iv;
                    boolean bl = false;
                    if (childNode.getTagName() != null) {
                        String string;
                        int n3 = -1;
                        switch (string.hashCode()) {
                            case 955046078: {
                                if (!string.equals(CORNERS)) break;
                                n3 = 1;
                                break;
                            }
                            case 109618859: {
                                if (!string.equals(SOLID)) break;
                                n3 = 2;
                                break;
                            }
                            case 3530753: {
                                if (!string.equals(SIZE)) break;
                                n3 = 3;
                                break;
                            }
                            case 89650992: {
                                if (!string.equals(GRADIENT)) break;
                                n3 = 4;
                                break;
                            }
                            case -891980232: {
                                if (!string.equals(STROKE)) break;
                                n3 = 5;
                                break;
                            }
                        }
                        switch (n3) {
                            case 3: {
                                this.updateSize(childNode);
                                break;
                            }
                            case 4: {
                                this.updateGradient(childNode);
                                break;
                            }
                            case 2: {
                                this.updateSolid(childNode);
                                break;
                            }
                            case 5: {
                                this.updateStroke(childNode);
                                break;
                            }
                            case 1: {
                                this.updateCorners(childNode);
                            }
                        }
                    }
                }
                ++i$iv;
            }
        }
    }

    private final void updateSize(Element element) {
        this.width = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(WIDTH), this.width);
        this.height = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(HEIGHT), this.height);
    }

    /*
     * Unable to fully structure code
     */
    private final void updateGradient(Element element) {
        block4: {
            block5: {
                this.gradientCenterX = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute("android:centerX"), this.gradientCenterX);
                this.gradientCenterY = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute("android:centerY"), this.gradientCenterY);
                v0 = element.getAttribute("android:type");
                if (v0 == null) break block4;
                var2_2 = v0;
                var3_3 = false;
                var4_4 = false;
                $this$run = var2_2;
                $i$a$-run-GradientDrawable$updateGradient$1 = false;
                var7_8 = $this$run;
                switch (var7_8.hashCode()) {
                    case 109850348: {
                        if (!var7_8.equals("sweep")) ** break;
                        break;
                    }
                    case -938579425: {
                        if (!var7_8.equals("radial")) ** break;
                        v1 = 1;
                        break block5;
                    }
                }
                v1 = 2;
                break block5;
                v1 = this.gradientType;
            }
            var2_2 = v1;
            var3_3 = false;
            var4_4 = false;
            it = ((Number)var2_2).intValue();
            $i$a$-also-GradientDrawable$updateGradient$2 = false;
            this.gradientType = it;
        }
        this.startGradientColor = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute("android:startColor"), this.startGradientColor);
        this.centerGradientColor = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute("android:centerColor"), this.centerGradientColor);
        this.endGradientColor = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute("android:endColor"), this.endGradientColor);
        this.gradientAngle = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute("android:angle"), this.gradientAngle);
        this.gradientRadius = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute("android:gradientRadius"), this.gradientRadius);
    }

    private final void updateSolid(Element element) {
        Color color = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute(COLOR), this.color);
        if (color == null) {
            color = this.color;
        }
        this.color = color;
    }

    private final void updateStroke(Element element) {
        this.strokeColor = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute(COLOR), this.strokeColor);
        this.strokeWidth = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(WIDTH), this.strokeWidth);
        this.dashGap = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(DASH_GAP), this.dashGap);
        this.dashGapWidth = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(DASH_WIDTH), this.dashGapWidth);
    }

    private final void updateCorners(Element element) {
        String string = element.getAttribute(RADIUS);
        if (string != null) {
            Object object = string;
            boolean bl = false;
            boolean bl2 = false;
            String $this$run = object;
            boolean bl3 = false;
            object = Float.valueOf(Utils.INSTANCE.parseAttributeAsFloat($this$run, 0.0f));
            bl = false;
            bl2 = false;
            float it = ((Number)object).floatValue();
            boolean bl4 = false;
            this.topLeftRadius = it;
            this.topRightRadius = it;
            this.bottomLeftRadius = it;
            this.bottomRightRadius = it;
        }
        this.topLeftRadius = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(TOP_LEFT_RADIUS), this.topLeftRadius);
        this.topRightRadius = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(TOP_RIGHT_RADIUS), this.topRightRadius);
        this.bottomLeftRadius = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(BOTTOM_LEFT_RADIUS), this.bottomLeftRadius);
        this.bottomRightRadius = Utils.INSTANCE.parseAttributeAsFloat(element.getAttribute(BOTTOM_RIGHT_RADIUS), this.bottomRightRadius);
    }

    @Override
    public void draw(@NotNull BufferedImage outputImage) {
        Intrinsics.checkParameterIsNotNull((Object)outputImage, (String)"outputImage");
        super.draw(outputImage);
        this.resolveDimensions(outputImage);
        BufferedImage bufferedImage = new BufferedImage(this.resolvedWidth, this.resolvedHeight, 2);
        boolean bl = false;
        boolean bl2 = false;
        BufferedImage resizedImage = bufferedImage;
        boolean bl3 = false;
        Graphics2D graphics2D = resizedImage.createGraphics();
        boolean bl4 = false;
        boolean bl5 = false;
        Graphics2D resizedGraphics = graphics2D;
        boolean bl6 = false;
        resizedGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D2 = resizedGraphics;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D2, (String)"resizedGraphics");
        this.drawShape(graphics2D2);
        this.drawStroke(resizedGraphics);
        Graphics2D graphics2D3 = outputImage.createGraphics();
        if (graphics2D3 != null) {
            Graphics2D graphics2D4 = graphics2D3;
            boolean bl7 = false;
            boolean bl8 = false;
            Graphics2D graphics = graphics2D4;
            boolean bl9 = false;
            graphics.drawImage((Image)resizedImage, (outputImage.getWidth() - this.resolvedWidth) / 2, (outputImage.getHeight() - this.resolvedHeight) / 2, null);
            graphics.dispose();
        }
        resizedGraphics.dispose();
    }

    private final void resolveDimensions(BufferedImage image) {
        this.resolvedWidth = image.getWidth();
        this.resolvedHeight = image.getHeight();
        if (this.shape == 2) {
            this.resolveStroke(this.resolvedWidth, null);
            return;
        }
        if (this.shape == 3) {
            return;
        }
        Float maxValue = null;
        if (this.width > 0 && this.height > 0) {
            int n = this.width;
            int n2 = this.height;
            boolean bl = false;
            maxValue = Float.valueOf(Math.max(n, n2));
            this.resolvedWidth = (int)((float)image.getWidth() * ((float)this.width / maxValue.floatValue()));
            this.resolvedHeight = (int)((float)image.getHeight() * ((float)this.height / maxValue.floatValue()));
            this.gradientRadius = (float)image.getHeight() * (this.gradientRadius / maxValue.floatValue());
        } else {
            this.gradientRadius = image.getWidth();
        }
        this.resolveCorners(this.resolvedWidth, this.resolvedHeight, maxValue);
        this.resolveStroke(this.resolvedWidth, maxValue);
    }

    private final void resolveCorners(float width, float height, Float maxValue) {
        block4: {
            float half;
            float f;
            float maxCorner;
            Float f2 = ArraysKt.max((Float[])new Float[]{Float.valueOf(this.topLeftRadius), Float.valueOf(this.topRightRadius), Float.valueOf(this.bottomRightRadius), Float.valueOf(this.bottomLeftRadius)});
            float f3 = maxCorner = f2 != null ? f2.floatValue() * 4.0f : 0.0f;
            if (!(maxCorner > 0.0f)) break block4;
            Float f4 = maxValue;
            float maxValueToUse = f4 != null ? f4.floatValue() : maxCorner;
            float f5 = height * (this.topLeftRadius / maxValueToUse);
            GradientDrawable gradientDrawable = this;
            boolean bl = false;
            boolean bl2 = false;
            float it = f5;
            boolean bl3 = false;
            float f6 = height;
            boolean bl4 = false;
            gradientDrawable.topLeftHeightRadius = f = Math.min(it, f6);
            f5 = width * (this.topLeftRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl5 = false;
            f6 = width;
            bl4 = false;
            gradientDrawable.topLeftWidthRadius = f = Math.min(it, f6);
            f5 = height * (this.topRightRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl6 = false;
            f6 = height;
            bl4 = false;
            gradientDrawable.topRightHeightRadius = f = Math.min(it, f6);
            f5 = width * (this.topRightRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl7 = false;
            f6 = width;
            bl4 = false;
            gradientDrawable.topRightWidthRadius = f = Math.min(it, f6);
            f5 = height * (this.bottomRightRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl8 = false;
            f6 = height;
            bl4 = false;
            gradientDrawable.bottomRightHeightRadius = f = Math.min(it, f6);
            f5 = width * (this.bottomRightRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl9 = false;
            f6 = width;
            bl4 = false;
            gradientDrawable.bottomRightWidthRadius = f = Math.min(it, f6);
            f5 = height * (this.bottomLeftRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl10 = false;
            f6 = height;
            bl4 = false;
            gradientDrawable.bottomLeftHeightRadius = f = Math.min(it, f6);
            f5 = width * (this.bottomLeftRadius / maxValueToUse);
            gradientDrawable = this;
            bl = false;
            bl2 = false;
            it = f5;
            boolean bl11 = false;
            f6 = width;
            bl4 = false;
            gradientDrawable.bottomLeftWidthRadius = f = Math.min(it, f6);
            Float f7 = Float.valueOf(this.topLeftWidthRadius + this.topRightWidthRadius);
            bl = false;
            bl2 = false;
            it = ((Number)f7).floatValue();
            boolean bl12 = false;
            Float f8 = it > width ? f7 : null;
            if (f8 != null) {
                f7 = f8;
                bl = false;
                bl2 = false;
                it = ((Number)f7).floatValue();
                boolean bl13 = false;
                half = (it - width) / (float)2;
                this.topLeftWidthRadius -= half;
                this.topRightWidthRadius -= half;
            }
            f7 = Float.valueOf(this.bottomLeftWidthRadius + this.bottomRightWidthRadius);
            bl = false;
            bl2 = false;
            it = ((Number)f7).floatValue();
            boolean bl14 = false;
            Float f9 = it > width ? f7 : null;
            if (f9 != null) {
                f7 = f9;
                bl = false;
                bl2 = false;
                it = ((Number)f7).floatValue();
                boolean bl15 = false;
                half = (it - width) / (float)2;
                this.bottomLeftWidthRadius -= half;
                this.bottomRightWidthRadius -= half;
            }
            f7 = Float.valueOf(this.topLeftHeightRadius + this.bottomLeftHeightRadius);
            bl = false;
            bl2 = false;
            it = ((Number)f7).floatValue();
            boolean bl16 = false;
            Float f10 = it > height ? f7 : null;
            if (f10 != null) {
                f7 = f10;
                bl = false;
                bl2 = false;
                it = ((Number)f7).floatValue();
                boolean bl17 = false;
                half = (it - height) / (float)2;
                this.topLeftHeightRadius -= half;
                this.bottomLeftHeightRadius -= half;
            }
            f7 = Float.valueOf(this.topRightHeightRadius + this.bottomRightHeightRadius);
            bl = false;
            bl2 = false;
            it = ((Number)f7).floatValue();
            boolean bl18 = false;
            Float f11 = it > height ? f7 : null;
            if (f11 != null) {
                f7 = f11;
                bl = false;
                bl2 = false;
                it = ((Number)f7).floatValue();
                boolean bl19 = false;
                half = (it - height) / (float)2;
                this.topRightHeightRadius -= half;
                this.bottomRightHeightRadius -= half;
            }
        }
    }

    private final void resolveStroke(float width, Float maxValue) {
        if (maxValue != null) {
            float f;
            float f2 = width * ((float)this.strokeWidth / maxValue.floatValue());
            GradientDrawable gradientDrawable = this;
            boolean bl = false;
            boolean bl2 = false;
            float it = f2;
            boolean bl3 = false;
            float f3 = width * 0.5f;
            boolean bl4 = false;
            gradientDrawable.resolvedStrokeWidth = f = Math.min(it, f3);
            this.dashGap = width * (this.dashGap / maxValue.floatValue()) * (float)2;
            this.dashGapWidth = width * (this.dashGap / maxValue.floatValue());
        } else {
            this.resolvedStrokeWidth = width * 0.1f;
            if (this.dashGap > 0.0f || this.dashGapWidth > 0.0f) {
                this.dashGap = this.resolvedStrokeWidth;
                this.dashGapWidth = this.resolvedStrokeWidth;
            }
        }
    }

    private final void drawShape(Graphics2D graphics) {
        Shape shapeToUse;
        Shape shape;
        List gradientColors = ArraysKt.filterNotNull((Object[])new Color[]{this.startGradientColor, this.centerGradientColor, this.endGradientColor});
        if (gradientColors.isEmpty()) {
            graphics.setColor(this.color);
        } else {
            Color[] colorArray = new Color[3];
            Color color = this.startGradientColor;
            if (color == null) {
                Color color2 = Color.BLACK;
                color = color2;
                Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.BLACK");
            }
            colorArray[0] = color;
            Color color3 = this.centerGradientColor;
            if (color3 == null) {
                Color color4 = Color.BLACK;
                color3 = color4;
                Intrinsics.checkExpressionValueIsNotNull((Object)color4, (String)"Color.BLACK");
            }
            colorArray[1] = color3;
            Color color5 = this.endGradientColor;
            if (color5 == null) {
                Color color6 = Color.BLACK;
                color5 = color6;
                Intrinsics.checkExpressionValueIsNotNull((Object)color6, (String)"Color.BLACK");
            }
            colorArray[2] = color5;
            graphics.setPaint(this.getGradientPaint(colorArray));
        }
        switch (this.shape) {
            case 1: {
                shape = GradientDrawable.getOval$default(this, false, 1, null);
                break;
            }
            case 0: {
                shape = GradientDrawable.getRoundPath$default(this, false, 1, null);
                break;
            }
            case 3: {
                shape = this.getRing();
                break;
            }
            default: {
                shape = null;
            }
        }
        Shape shape2 = shapeToUse = shape;
        if (shape2 != null) {
            Shape shape3 = shape2;
            boolean bl = false;
            boolean bl2 = false;
            Shape it = shape3;
            boolean bl3 = false;
            graphics.fill(it);
        }
        graphics.setColor(null);
        graphics.setPaint(null);
    }

    private final Paint getGradientPaint(Color[] gradientColors) {
        Paint paint;
        switch (this.gradientType) {
            case 0: {
                paint = this.getLinearGradient(gradientColors);
                break;
            }
            case 1: {
                paint = this.getRadialGradient(gradientColors);
                break;
            }
            case 2: {
                paint = this.getSweepGradient(gradientColors);
                break;
            }
            default: {
                paint = null;
            }
        }
        return paint;
    }

    private final Paint getLinearGradient(Color[] gradientColors) {
        float widthF = this.resolvedWidth;
        float heightF = this.resolvedHeight;
        int resolvedAngle = this.gradientAngle % 360;
        float startX = 0.0f;
        float startY = 0.0f;
        float endX = 0.0f;
        float endY = 0.0f;
        switch (resolvedAngle) {
            case 0: {
                endX = widthF;
                break;
            }
            case 45: {
                startY = heightF;
                endX = widthF;
                break;
            }
            case 90: {
                startY = heightF;
                break;
            }
            case 135: {
                startX = widthF;
                startY = heightF;
                break;
            }
            case 180: {
                startX = widthF;
                break;
            }
            case 225: {
                startX = widthF;
                endY = heightF;
                break;
            }
            case 270: {
                endY = heightF;
                break;
            }
            case 315: {
                endX = widthF;
                endY = heightF;
            }
        }
        float f = this.gradientCenterX;
        float f2 = this.gradientCenterY;
        boolean bl = false;
        f = Math.max(f, f2);
        boolean bl2 = false;
        bl = false;
        float it = f;
        boolean bl3 = false;
        float maxGradientCenter = it < 0.0f ? 0.5f : (it == 0.0f ? 0.01f : (it >= 1.0f ? 0.99f : it));
        return new LinearGradientPaint(startX, startY, endX, endY, new float[]{0.0f, maxGradientCenter, 1.0f}, gradientColors);
    }

    private final Paint getRadialGradient(Color[] gradientColors) {
        return new RadialGradientPaint(this.gradientCenterX * (float)this.resolvedWidth, this.gradientCenterY * (float)this.resolvedHeight, this.gradientRadius, new float[]{0.0f, 0.5f, 1.0f}, gradientColors);
    }

    private final Paint getSweepGradient(Color[] gradientColors) {
        return new RadialGradientPaint(0.5f * (float)this.resolvedWidth, 0.5f * (float)this.resolvedHeight, this.resolvedWidth, new float[]{0.0f, 0.5f, 1.0f}, gradientColors);
    }

    private final void drawStroke(Graphics2D graphics) {
        block6: {
            Shape shapeToUse;
            Shape shape;
            if (!(this.resolvedStrokeWidth > 0.0f)) break block6;
            graphics.setColor(this.strokeColor);
            graphics.setStroke(this.createStroke());
            switch (this.shape) {
                case 1: {
                    shape = this.getOval(true);
                    break;
                }
                case 0: {
                    shape = this.getRoundPath(true);
                    break;
                }
                case 2: {
                    shape = this.getLinePath();
                    break;
                }
                default: {
                    shape = null;
                }
            }
            Shape shape2 = shapeToUse = shape;
            if (shape2 != null) {
                Shape shape3 = shape2;
                boolean bl = false;
                boolean bl2 = false;
                Shape it = shape3;
                boolean bl3 = false;
                graphics.draw(it);
            }
        }
    }

    private final Stroke createStroke() {
        if (this.dashGap == 0.0f || this.dashGapWidth == 0.0f) {
            return new BasicStroke(this.resolvedStrokeWidth);
        }
        return new BasicStroke(this.resolvedStrokeWidth, 0, 1, 1.0f, new float[]{this.dashGap, this.dashGapWidth}, 0.0f);
    }

    private final Shape getOval(boolean forStroke) {
        Shape shape;
        if (forStroke) {
            float halfStroke = this.resolvedStrokeWidth / (float)2;
            shape = new Ellipse2D.Float(halfStroke, halfStroke, (float)this.resolvedWidth - this.resolvedStrokeWidth, (float)this.resolvedHeight - this.resolvedStrokeWidth);
        } else {
            shape = new Ellipse2D.Float(0.0f, 0.0f, this.resolvedWidth, this.resolvedHeight);
        }
        return shape;
    }

    static /* synthetic */ Shape getOval$default(GradientDrawable gradientDrawable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return gradientDrawable.getOval(bl);
    }

    private final Shape getRoundPath(boolean forStroke) {
        if (forStroke) {
            Path2D.Float float_ = new Path2D.Float();
            boolean bl = false;
            boolean bl2 = false;
            Path2D.Float $this$apply = float_;
            boolean bl3 = false;
            float widthF = this.resolvedWidth;
            float heightF = this.resolvedHeight;
            float halfStroke = this.resolvedStrokeWidth / (float)2;
            float left = halfStroke - 0.5f;
            float top = halfStroke - 0.5f;
            float right = widthF - halfStroke;
            float bottom = heightF - halfStroke;
            $this$apply.moveTo(right - this.topRightWidthRadius + halfStroke, top);
            $this$apply.lineTo(right - this.topRightWidthRadius + halfStroke, top);
            $this$apply.quadTo(right, top, right, top + this.topRightHeightRadius - halfStroke);
            $this$apply.lineTo(right, bottom - this.bottomRightHeightRadius + halfStroke);
            $this$apply.quadTo(right, bottom, right - this.bottomRightWidthRadius + halfStroke, bottom);
            $this$apply.lineTo(left + this.bottomLeftWidthRadius - halfStroke, bottom);
            $this$apply.quadTo(left, bottom, left, bottom - this.bottomLeftHeightRadius + halfStroke);
            $this$apply.lineTo(left, top + this.topLeftHeightRadius - halfStroke);
            $this$apply.quadTo(left, top, left + this.topLeftWidthRadius - halfStroke, top);
            $this$apply.closePath();
            return float_;
        }
        Path2D.Float float_ = new Path2D.Float();
        boolean bl = false;
        boolean bl4 = false;
        Path2D.Float $this$apply = float_;
        boolean bl5 = false;
        float widthF = this.resolvedWidth;
        float heightF = this.resolvedHeight;
        $this$apply.moveTo(0.0f, 0.0f);
        $this$apply.lineTo(widthF - this.topRightWidthRadius, 0.0f);
        $this$apply.quadTo(widthF, 0.0f, widthF, 0.0f + this.topRightHeightRadius);
        $this$apply.lineTo(widthF, heightF - this.bottomRightHeightRadius);
        $this$apply.quadTo(widthF, heightF, widthF - this.bottomRightWidthRadius, heightF);
        $this$apply.lineTo(0.0f + this.bottomLeftWidthRadius, heightF);
        $this$apply.quadTo(0.0f, heightF, 0.0f, heightF - this.bottomLeftHeightRadius);
        $this$apply.lineTo(0.0f, 0.0f + this.topLeftHeightRadius);
        $this$apply.quadTo(0.0f, 0.0f, 0.0f + this.topLeftWidthRadius, 0.0f);
        $this$apply.closePath();
        return float_;
    }

    static /* synthetic */ Shape getRoundPath$default(GradientDrawable gradientDrawable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return gradientDrawable.getRoundPath(bl);
    }

    private final Shape getLinePath() {
        float f = (float)this.resolvedHeight / 2.0f;
        boolean bl = false;
        boolean bl2 = false;
        float it = f;
        boolean bl3 = false;
        return new Line2D.Float(0.0f, it, this.resolvedWidth, it);
    }

    private final Shape getRing() {
        float widthF = this.resolvedWidth;
        float heightF = this.resolvedHeight;
        float centerX = widthF / (float)2;
        float centerY = heightF / (float)2;
        double outerRadius = (double)widthF / 2.0;
        float resolvedThickness = widthF * 0.3f;
        Ellipse2D.Double outer = new Ellipse2D.Double((double)centerX - outerRadius, (double)centerY - outerRadius, outerRadius + outerRadius, outerRadius + outerRadius);
        Ellipse2D.Double inner = new Ellipse2D.Double((double)centerX - outerRadius + (double)resolvedThickness, (double)centerY - outerRadius + (double)resolvedThickness, outerRadius + outerRadius - (double)resolvedThickness - (double)resolvedThickness, outerRadius + outerRadius - (double)resolvedThickness - (double)resolvedThickness);
        Area area = new Area(outer);
        boolean bl = false;
        boolean bl2 = false;
        Area $this$apply = area;
        boolean bl3 = false;
        $this$apply.subtract(new Area(inner));
        return area;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/GradientDrawable$Companion;", "", "()V", "ANGLE", "", "BOTTOM_LEFT_RADIUS", "BOTTOM_RIGHT_RADIUS", "CENTER_COLOR", "CENTER_X", "CENTER_Y", "COLOR", "CORNERS", "DASH_GAP", "DASH_WIDTH", "DEFAULT_INNER_RADIUS_RATIO", "", "DEFAULT_INT_VALUE", "", "DEFAULT_THICKNESS_RATIO", "END_COLOR", "GRADIENT", "GRADIENT_RADIUS", "HEIGHT", "INNER_RADIUS", "INNER_RADIUS_RATIO", "LINE", "OVAL_SHAPE", "RADIAL_GRADIENT_TYPE", "RADIUS", "RING", "SHAPE", "SIZE", "SOLID", "START_COLOR", "STROKE", "SWEEP_GRADIENT_TYPE", "THICKNESS", "THICKNESS_RATIO", "TINT", "TOP_LEFT_RADIUS", "TOP_RIGHT_RADIUS", "TYPE", "WIDTH", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

