/*
 * Decompiled with CFR 0.152.
 */
package com.mistamek.drawablepreview.drawables.dom;

import com.mistamek.drawablepreview.drawables.ItemDrawableInflater;
import com.mistamek.drawablepreview.drawables.Utils;
import com.mistamek.drawablepreview.drawables.dom.Drawable;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/InsetDrawable;", "Lcom/mistamek/drawablepreview/drawables/dom/Drawable;", "()V", "drawable", "insetBottom", "", "insetLeft", "insetRight", "insetTop", "draw", "", "outputImage", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "Companion", "drawable-preview"})
public final class InsetDrawable
extends Drawable {
    private Drawable drawable;
    private int insetTop;
    private int insetLeft;
    private int insetRight;
    private int insetBottom;
    private static final String INSET = "android:inset";
    private static final String INSET_TOP = "android:insetTop";
    private static final String INSET_LEFT = "android:insetLeft";
    private static final String INSET_RIGHT = "android:insetRight";
    private static final String INSET_BOTTOM = "android:insetBottom";
    public static final Companion Companion = new Companion(null);

    @Override
    public void inflate(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        this.drawable = ItemDrawableInflater.INSTANCE.getDrawableWithInflate(element);
        int n = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(INSET), 0);
        boolean bl = false;
        boolean bl2 = false;
        int inset = n;
        boolean bl3 = false;
        this.insetTop = inset;
        this.insetLeft = inset;
        this.insetRight = inset;
        this.insetBottom = inset;
        this.insetTop = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(INSET_TOP), this.insetTop);
        this.insetLeft = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(INSET_LEFT), this.insetLeft);
        this.insetRight = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(INSET_RIGHT), this.insetRight);
        this.insetBottom = Utils.INSTANCE.parseAttributeAsInt(element.getAttribute(INSET_BOTTOM), this.insetBottom);
    }

    @Override
    public void draw(@NotNull BufferedImage outputImage) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)outputImage, (String)"outputImage");
            super.draw(outputImage);
            Drawable drawable = this.drawable;
            if (drawable == null) break block1;
            Drawable drawable2 = drawable;
            boolean bl = false;
            boolean bl2 = false;
            Drawable drawable3 = drawable2;
            boolean bl3 = false;
            Integer n = (Integer)ArraysKt.max((Comparable[])new Integer[]{this.insetTop, this.insetLeft, this.insetRight, this.insetBottom});
            float maxValueAsFloat = n != null ? n : this.insetLeft;
            int maxInsetSize = outputImage.getWidth() / 5;
            this.insetTop = (int)((float)this.insetTop / maxValueAsFloat * (float)maxInsetSize);
            this.insetLeft = (int)((float)this.insetLeft / maxValueAsFloat * (float)maxInsetSize);
            this.insetRight = (int)((float)this.insetRight / maxValueAsFloat * (float)maxInsetSize);
            this.insetBottom = (int)((float)this.insetBottom / maxValueAsFloat * (float)maxInsetSize);
            int width = outputImage.getWidth() - this.insetLeft - this.insetRight;
            int height = outputImage.getHeight() - this.insetTop - this.insetBottom;
            if (width <= 0 || height <= 0) {
                return;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            boolean bl4 = false;
            boolean bl5 = false;
            BufferedImage imageWithInsets = bufferedImage;
            boolean bl6 = false;
            drawable3.draw(imageWithInsets);
            Graphics graphics = outputImage.getGraphics();
            boolean bl7 = false;
            boolean bl8 = false;
            Graphics $this$apply = graphics;
            boolean bl9 = false;
            $this$apply.drawImage(imageWithInsets, this.insetLeft, this.insetTop, width, height, null);
            $this$apply.dispose();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/InsetDrawable$Companion;", "", "()V", "INSET", "", "INSET_BOTTOM", "INSET_LEFT", "INSET_RIGHT", "INSET_TOP", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

