/*
 * Decompiled with CFR 0.152.
 */
package com.mistamek.drawablepreview.drawables.dom;

import com.mistamek.drawablepreview.drawables.ItemDrawableInflater;
import com.mistamek.drawablepreview.drawables.Utils;
import com.mistamek.drawablepreview.drawables.dom.Drawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0004j\b\u0012\u0004\u0012\u00020\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/RippleDrawable;", "Lcom/mistamek/drawablepreview/drawables/dom/Drawable;", "()V", "backgroundDrawables", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "color", "Ljava/awt/Color;", "draw", "", "outputImage", "Ljava/awt/image/BufferedImage;", "inflate", "element", "Lorg/w3c/dom/Element;", "Companion", "drawable-preview"})
public final class RippleDrawable
extends Drawable {
    private Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private ArrayList<Drawable> backgroundDrawables = new ArrayList();
    private static final String COLOR = "android:color";
    private static final String ITEM_TAG = "item";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void inflate(@NotNull Element element) {
        Color color;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.inflate(element);
        RippleDrawable rippleDrawable = this;
        Color color2 = Utils.INSTANCE.parseAttributeAsColor(element.getAttribute(COLOR), this.color);
        if (color2 != null) {
            Color color3 = color2;
            RippleDrawable rippleDrawable2 = rippleDrawable;
            boolean bl = false;
            n = 0;
            Color it = color3;
            boolean bl2 = false;
            Color color4 = new Color(it.getRed(), it.getGreen(), it.getBlue(), (int)127.5f);
            rippleDrawable = rippleDrawable2;
            color = color4;
        } else {
            color = this.color;
        }
        rippleDrawable.color = color;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            NodeList $this$forEachAsElement$iv = nodeList;
            boolean $i$f$forEachAsElement = false;
            n = 0;
            int n2 = $this$forEachAsElement$iv.getLength();
            while (n < n2) {
                void i$iv;
                Node childNode$iv = $this$forEachAsElement$iv.item((int)i$iv);
                if (childNode$iv instanceof Element) {
                    Element childElement = (Element)childNode$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)childElement.getTagName(), (Object)ITEM_TAG)) {
                        if (ItemDrawableInflater.INSTANCE.getDrawableWithInflate(childElement) != null) {
                            Drawable drawable;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            Drawable it = drawable;
                            boolean bl5 = false;
                            this.backgroundDrawables.add(it);
                        }
                    }
                }
                ++i$iv;
            }
        }
    }

    @Override
    public void draw(@NotNull BufferedImage outputImage) {
        Intrinsics.checkParameterIsNotNull((Object)outputImage, (String)"outputImage");
        super.draw(outputImage);
        Iterable $this$forEach$iv = this.backgroundDrawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.draw(outputImage);
        }
        Graphics2D graphics2D = outputImage.createGraphics();
        boolean bl = false;
        boolean bl2 = false;
        Graphics2D graphics = graphics2D;
        boolean bl3 = false;
        int resolvedSize = (int)((float)outputImage.getWidth() * 0.5f);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D2 = graphics;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D2, (String)"graphics");
        graphics2D2.setColor(this.color);
        graphics.fillOval(outputImage.getWidth() / 2 - resolvedSize / 2, outputImage.getHeight() / 2 - resolvedSize / 2, resolvedSize, resolvedSize);
        graphics.dispose();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mistamek/drawablepreview/drawables/dom/RippleDrawable$Companion;", "", "()V", "COLOR", "", "ITEM_TAG", "drawable-preview"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

